package comparingDevices;

import java.io.File;
import java.util.Vector;

import pdfReport.PDFReport;

import com.lowagie.text.Chapter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;

/**
 * This class will compare the devices
 * @author MC
 *
 */
public class CompareDevices {
	public Vector<Device> vectDevices;
	public Device megaDevice;
	public Vector<Boolean[]> vectCompareMOC;
	public Vector<Boolean[]> vectCompareAtt;
	public Vector<Boolean[]> vectCompareNotif;
	public Vector<Boolean[]> vectCompareBehav;
	public Vector<String> vectFileNames;
	
	public CompareDevices()
	{
		vectDevices = new Vector<Device>();
		megaDevice = null;
		vectCompareAtt = new Vector<Boolean[]>();
		vectCompareBehav = new Vector<Boolean[]>();
		vectCompareMOC = new Vector<Boolean[]>();
		vectCompareNotif = new Vector<Boolean[]>();
	}
	public CompareDevices(Vector<String> vectFiles){
		vectFileNames = vectFiles;
		vectDevices = new Vector<Device>();
		megaDevice = null;
		vectCompareAtt = new Vector<Boolean[]>();
		vectCompareBehav = new Vector<Boolean[]>();
		vectCompareMOC = new Vector<Boolean[]>();
		vectCompareNotif = new Vector<Boolean[]>();
		
		for(int i = 0; i< vectFiles.size(); i++)
		{
			String fileName = (String)vectFiles.get(i);
			vectDevices.add(new Device(new File(fileName)));
		}
	}
	public void addDevice(Device device){
		vectDevices.add(device);
	}
	private void buildMegaDevice(){
		megaDevice = new Device();
		for(int i = 0; i<vectDevices.size(); i++){
			Device device = (Device)vectDevices.get(i);
			device.setOwner(i);
			megaDevice.addListMOC(device.vectMOC);
		}
		
		megaDevice.sortMOC();
	}
	public void compareMOC()
	{
		//build megadevice containing all the MOC objects
		buildMegaDevice();		
		
		// fill vectCompareMOC
		for(int i = 0; i<megaDevice.vectMOC.size(); i++){
			MOC objMoc = (MOC) megaDevice.vectMOC.get(i);
			Boolean [] array = new Boolean [vectDevices.size() + 1];
			
			for(int j = 0; j<array.length; j++)
				array[j] = new Boolean(false);
			
			if(objMoc.isPrivate){
				array[vectDevices.size()] = new Boolean(true);
			}
			
			for(int j = 0; j<objMoc.vectOwners.size(); j++){
				Integer index = (Integer)objMoc.vectOwners.get(j);
				array[index.intValue()] = new Boolean(true);
			}
			vectCompareMOC.add(array);
							
		}
	}
	public void compareAttributes(int index)
	{
		//build megadevice containing all the MOC objects
		if(megaDevice == null)
			buildMegaDevice();
		
		MOC objMOC = (MOC) megaDevice.vectMOC.get(index);
		
		// fill vectCompareAttr
		for(int i = 0; i<objMOC.vectAttributes.size(); i++){
			Attribute objAttr = (Attribute) objMOC.vectAttributes.get(i);
			Boolean [] array = new Boolean [vectDevices.size() + 1];
			for(int j = 0; j<array.length; j++)
				array[j] = new Boolean(false);
			for(int j = 0; j<objAttr.vectOwners.size(); j++){
				Integer k = (Integer)objAttr.vectOwners.get(j);
				array[k.intValue()] = new Boolean(true);
			}
			if(objAttr.isPrivate)
				array[vectDevices.size()] = new Boolean(true);
			vectCompareAtt.add(array);
							
		}
		
	}
	public Vector getVectAttributes(int indexMOC){
		return ((MOC)megaDevice.vectMOC.get(indexMOC)).vectAttributes;
	}
	public Vector getVectNotifications(int indexMOC){
		return ((MOC)megaDevice.vectMOC.get(indexMOC)).vectNotifications;
	}
	public Vector getVectBehaviours(int indexMOC){
		return ((MOC)megaDevice.vectMOC.get(indexMOC)).vectBehaviors;
	}
	public void compareBehaviours(int index){
		//build megadevice containing all the MOC objects
		if(megaDevice == null)
			buildMegaDevice();
		
		MOC objMOC = (MOC) megaDevice.vectMOC.get(index);
		
		// fill vectCompareAttr
		for(int i = 0; i<objMOC.vectBehaviors.size(); i++){
			Behavior objbehav = (Behavior) objMOC.vectBehaviors.get(i);
			Boolean [] array = new Boolean [vectDevices.size() + 1];
			for(int j = 0; j<array.length; j++)
				array[j] = new Boolean(false);
			
			if(objbehav.isPrivate)
				array[vectDevices.size()] = new Boolean(true);
			for(int j = 0; j<objbehav.vectOwners.size(); j++){
				Integer k = (Integer)objbehav.vectOwners.get(j);
				array[k.intValue()] = new Boolean(true);
			}
			vectCompareBehav.add(array);
							
		}
	}
	public void compareNotifications(int index){
		//build megadevice containing all the MOC objects
		if(megaDevice == null)
			buildMegaDevice();
		
		MOC objMOC = (MOC) megaDevice.vectMOC.get(index);
		
		// fill vectCompareAttr
		for(int i = 0; i<objMOC.vectNotifications.size(); i++){
			Notification objNotif = (Notification) objMOC.vectNotifications.get(i);
			Boolean [] array = new Boolean [vectDevices.size() + 1];
			for(int j = 0; j<array.length; j++)
				array[j] = new Boolean(false);
			
			if(objNotif.isPrivate)
				array[vectDevices.size()] = new Boolean(true);
			
			for(int j = 0; j<objNotif.vectOwners.size(); j++){
				Integer k = (Integer)objNotif.vectOwners.get(j);
				array[k.intValue()] = new Boolean(true);
			}
			vectCompareNotif.add(array);
							
		}
	}
	
	public void getPDFReport(PDFReport report) throws DocumentException{
		
		com.lowagie.text.Document document = report.doc;
		
		report.SetTitle("Comparison Report");
		report.addTitle();
		
		Chapter chapter;
								
		chapter = report.createChapter("MOC Objects Comparison" + "\n\n",new Paragraph(new Phrase("")));
		document.add(chapter);
		MyModel modelMoc = new MyModel(megaDevice.vectMOC, vectCompareMOC, vectFileNames);
		document.add(report.createTableFromTaleModel(modelMoc));
		
		
		
		for(int i = 0; i < vectCompareMOC.size(); i++){
			chapter = report.createChapter(modelMoc.getValueAt(i, 0) +" MOC Characteristics Comparison \n\n",new Paragraph(new Phrase("")));
			
			report.addSection("Attributes\n\n",null);
			compareAttributes(i);
			chapter.add(report.createTableFromTaleModel(new MyModel(getVectAttributes(i), vectCompareAtt, vectFileNames)));
			report.addSection("Behaviours\n\n", null);
			compareBehaviours(i);
			chapter.add(report.createTableFromTaleModel(new MyModel(getVectBehaviours(i), vectCompareAtt, vectFileNames)));
			report.addSection("Notifications\n\n", null);
			compareNotifications(i);
			chapter.add(report.createTableFromTaleModel(new MyModel(getVectNotifications(i), vectCompareAtt, vectFileNames)));
			document.add(chapter);
		}
			
		
		report.close();
	}

}
