package comparingDevices;

import java.util.Vector;

/**
 * This class is the base class for MOC, Atribute, Notification, Behavior
 * @author MC
 *
 */
public class Base implements Comparable<Base>{
	public String name;
	public boolean isPrivate;
	/**
	 * sera utilise par CompareDevices
	 */
	public Vector<Integer> vectOwners;
	public Base(String nameIn)
	{
		name = nameIn;
		vectOwners = new Vector<Integer>();
		isPrivate = false;
	}
	
	public int compareTo(Base arg0) {
		Base obj = arg0;
		if(obj != null)
			return name.compareTo(obj.name);
		else
			return -1;
	}
	public void addToOwners(Base obj)
	{
		vectOwners.addAll(obj.vectOwners);
	}
	public void setOwner(Integer i){
		vectOwners.add(i);
	}

}
