/*
 * INTU8.java
 *
 * Created on October 24, 2006, 5:03 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.MderLib;
import gov.nist.div897.Asn1ILib.*;
import gov.nist.div897.Asn1Lib.*;
import gov.nist.div897.DumpLib.*;
import java.io.*;
import java.math.*;

/**
 *
 * @author rtheimer
 */
public class INTU8 extends INTEGER{
    static final private String m_String_NameAsn1Type = "INT-U8";
    static final private INTEGER m_INTEGER_LowerBound = new INTEGER("{LOWERBOUND}",new byte[]{(byte)0x00});
    static final private INTEGER m_INTEGER_UpperBound = new INTEGER("{UPPERBOUND}",new byte[]{(byte)0x00,(byte)0xff});
    static final private Range m_Range = new Range(m_INTEGER_LowerBound, true, m_INTEGER_UpperBound, true);
    
    static public String getNameASN1Type(){
        return m_String_NameAsn1Type;
    }
    /** Creates a new instance of INTU8 */
    public INTU8() {
        super();
        RangeArrayList l_RangeArrayList = new RangeArrayList();
        l_RangeArrayList.add(m_Range);
        setRangeArrayList(l_RangeArrayList);
    }
    public INTU8(String a_String){
        this();
        setNameInstance(a_String);
    }
    public INTU8(String a_String_NameInstance, String a_String_Data){
        this();
        setNameInstance(a_String_NameInstance);
        setData(a_String_Data);
    }
    public INTU8(String a_String, byte[] a_byteArray){
        this();
        setNameInstance(a_String);
        setData(a_byteArray);
    }
    public INTU8(byte[] a_byteArray){
        this();
        setData(a_byteArray);
    }
    public BigInteger getDataAsBigInteger(){
        byte[] l_byteArray_Data = getData();
        byte[] l_byteArray = new byte[l_byteArray_Data.length+1];
        l_byteArray[0] = (byte)0x00;
        int l_int_Index = 1;
        for(byte l_byte : l_byteArray_Data) l_byteArray[l_int_Index++] = l_byte;
        return new BigInteger(l_byteArray);
    }
}
