/*
 * CHOICE.java
 *
 * Created on October 24, 2006, 5:25 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.Asn1Lib;
import gov.nist.div897.Asn1ILib.*;
import java.util.*;
import java.io.*;

import org.w3c.dom.Node;

/**
 *
 * @author rtheimer
 */
public class CHOICE extends Asn1Object{
    static final private String m_String_NameAsn1Type = "CHOICE";
    protected Asn1Object m_Asn1Object;
    protected Choices m_Choices;
    protected byte[] m_byteArray_ChoiceTag;
    /** Creates a new instance of CHOICE */
    static public Boolean IsCHOICE(){
        return true;
    }
    static public String getNameASN1Type(){
        return m_String_NameAsn1Type;
    }
    public CHOICE() {
        super();
        m_Choices = null;
        m_Asn1Object = null;
        m_byteArray_ChoiceTag = null;
    }
    public CHOICE(String a_String){
        this();
        setNameInstance(a_String);
    }
    public CHOICE(String a_String_NameInstance, String a_String_Data){
        this();
        setNameInstance(a_String_NameInstance);
        setData(a_String_Data);
    }
    public CHOICE(String a_String, byte[] a_byteArray){
        this();
        setNameInstance(a_String);
        setData(a_byteArray);
    }
    public CHOICE(byte[] a_byteArray){
        this();
        setData(a_byteArray);
    }
    public byte[] getChoiceTag(){
        return m_byteArray_ChoiceTag;
    }
    public Asn1Object MakeChoice(byte[] a_byteArray){
        m_Asn1Object = getChoiceObject(a_byteArray);
        return m_Asn1Object;
    }
    public Asn1Object getChoiceObject(byte[] a_byteArray){
    	Asn1Object asnObj;
    	INTEGER l_INTEGER = new INTEGER("",a_byteArray);
        String l_String = (String)m_Choices.get(l_INTEGER);
        asnObj = Asn1ModuleServer.instantiateAsn1Object(l_String);
        Set l_Set = m_Choices.entrySet();
        for (Iterator l_Iterator = l_Set.iterator(); l_Iterator.hasNext();) {
            Map.Entry l_MapEntry = (Map.Entry)l_Iterator.next();
            Asn1Object l_Asn1Object = (Asn1Object)l_MapEntry.getKey();
            if(l_Asn1Object.equals(l_INTEGER)){
                asnObj.setNameInstance(l_Asn1Object.getNameInstance());
                m_byteArray_ChoiceTag = a_byteArray.clone();
                break;
            }
        }
        return asnObj;
    }
    public Asn1Object getChoice(){
        return m_Asn1Object;
    }
    public Choices getChoices(){
        return m_Choices;
    }
    public boolean setChoices(Choices a_Choices){
        m_Choices = a_Choices;
        return true;
    }
    public void printXML(PrintStream a_PrintStream){
        if(m_Asn1Object != null) m_Asn1Object.printXML(a_PrintStream, getAttributes());
        else super.printXML(a_PrintStream, getAttributes());
        //m_Asn1Object.printXML(a_PrintStream);
    }
    public void printXML(PrintStream a_PrintStream, Attributes a_Attributes){
        if(m_Asn1Object != null) m_Asn1Object.printXML(a_PrintStream, a_Attributes);
        else super.printXML(a_PrintStream, getAttributes());
        //m_Asn1Object.printXML(a_PrintStream, a_Attributes);
    }
    
    public Asn1Object getChosenASN1Object(){
    	return m_Asn1Object;
    }
    
    @Override
    public void setData(byte[] a_byteArray) {
    	m_Asn1Object.setData(a_byteArray);
    }
//    public void setChosenASN1Object(Asn1Object objAsn){
//    	if(m_Choices.containsValue(Asn1ModuleServer.getASN1Name(objAsn.getClass())))
//    		m_Asn1Object = objAsn;
//    }
    
}
