/*
 * SizeRange.java
 *
 * Created on December 5, 2006, 2:12 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.Asn1ILib;
import java.io.*;
import java.math.*;
/**
 *
 * @author rtheimer
 */
public class SizeRange {
    private BigInteger m_BigInteger_LowerBound;
    boolean m_boolean_LowerBoundIncluded;
    private BigInteger m_BigInteger_UpperBound;
    boolean m_boolean_UpperBoundIncluded;
    
    /** Creates a new instance of SizeRange */
    public SizeRange() {
        m_BigInteger_LowerBound = null;
        m_boolean_LowerBoundIncluded = false;
        m_BigInteger_UpperBound = null;
        m_boolean_UpperBoundIncluded = false;
    }
    public SizeRange(BigInteger a_BigInteger_LowerBound, boolean a_boolean_LowerBoundIncluded,
            BigInteger a_BigInteger_UpperBound, boolean a_boolean_UpperBoundIncluded){
        this();
        m_boolean_LowerBoundIncluded = a_boolean_LowerBoundIncluded;
        m_boolean_UpperBoundIncluded = a_boolean_UpperBoundIncluded;
        if(a_BigInteger_LowerBound != null){
            m_BigInteger_LowerBound = a_BigInteger_LowerBound;
        }
        if(a_BigInteger_UpperBound != null){
            m_BigInteger_UpperBound = a_BigInteger_UpperBound;
        }
    }
    public BigInteger getLowerBound(){
        return m_BigInteger_LowerBound;
    }
    public boolean getLowerBoundIncluded(){
        return m_boolean_LowerBoundIncluded;
    }
    public BigInteger getUpperBound(){
        return m_BigInteger_UpperBound;
    }
    public boolean getUpperBoundIncluded(){
        return m_boolean_UpperBoundIncluded;
    }
    public void printXML(PrintStream a_PrintStream){
        String l_String_Line = String.format("<LowerBound Included=\"%1$s\">",Boolean.toString(m_boolean_LowerBoundIncluded));
        a_PrintStream.println(l_String_Line);
        if(m_BigInteger_LowerBound != null) a_PrintStream.println(m_BigInteger_LowerBound.toString());
        a_PrintStream.println("</LowerBound>");
        l_String_Line = String.format("<UpperBound Included=\"%1$s\">",Boolean.toString(m_boolean_UpperBoundIncluded));
        a_PrintStream.println(l_String_Line);
        if(m_BigInteger_UpperBound != null) a_PrintStream.println(m_BigInteger_UpperBound.toString());
        a_PrintStream.println("</UpperBound>");
    }
    
}
