/*
 * ANYArguments.java
 *
 * Created on November 17, 2006, 12:59 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.Asn1ILib;
import org.w3c.dom.*;
import java.util.*;

/**
 *
 * @author rtheimer
 */
public class ANYArguments extends HashMap<Asn1Object,String> {
    private String m_String_ParentClassName;
    private String m_String_AnyFieldName;
    private String m_String_DefinedByClassName;
    private String m_String_DefinedByFieldName;
    /** Creates a new instance of ANYArguments */
    public ANYArguments() {
        m_String_ParentClassName = "";
        m_String_AnyFieldName = "";
        m_String_DefinedByFieldName = "";
    }
    public ANYArguments(String a_String_ParentClassName,
            String a_String_AnyFieldName,
            String a_String_DefinedByClassName,
            String a_String_DefinedByFieldName) {
        this();
        setParentClassName(a_String_ParentClassName);
        setAnyFieldName(a_String_AnyFieldName);
        setDefinedByClassName(a_String_DefinedByClassName);
        setDefinedByFieldName(a_String_DefinedByFieldName);
    }
    public void setParentClassName(String a_String){
        m_String_ParentClassName = a_String;
    }
    public void setAnyFieldName(String a_String){
        m_String_AnyFieldName = a_String;
    }
    public void setDefinedByClassName(String a_String){
        m_String_DefinedByClassName = a_String;
    }
    public void setDefinedByFieldName(String a_String){
        m_String_DefinedByFieldName = a_String;
    }
    public String getParentClassName(){
        return m_String_ParentClassName;
    }
    public String getAnyFieldName(){
        return m_String_AnyFieldName;
    }
    public String getDefinedByFieldName(){
        return m_String_DefinedByFieldName;
    }
    public String getDefinedByClassName(){
        return m_String_DefinedByClassName;
    }
    private boolean addArgumentANY(String a_String_FieldName, String a_String_MappedClass, String a_String_Option){
        boolean l_boolean_Return = false;
        if(a_String_FieldName.equals(m_String_AnyFieldName)){
            Asn1Object l_Asn1Object = Asn1ModuleServer.instantiateAsn1Object(m_String_DefinedByClassName);
            l_Asn1Object.setData(a_String_Option);
            put(l_Asn1Object,a_String_MappedClass);
            l_boolean_Return = true;
        }
        return l_boolean_Return;
    }
    public void addNodeList(NodeList a_NodeList){
        for(int l_int_Index_NodeList=0; l_int_Index_NodeList<a_NodeList.getLength(); l_int_Index_NodeList++){
            Node l_Node = a_NodeList.item(l_int_Index_NodeList);
            if(l_Node.getNodeType() == Node.ELEMENT_NODE) addNode(l_Node);
        }
    }
    public boolean addNode(Node a_Node){
        boolean l_boolean_Return = false;
        if(isANYNode(a_Node)){
            Node l_Node_Any_Fieldname = a_Node.getAttributes().getNamedItem("fieldname");
            if(l_Node_Any_Fieldname != null){
                Node l_Node_Any_Mappedclass = a_Node.getAttributes().getNamedItem("mappedclass");
                if(l_Node_Any_Mappedclass != null){
                    Node l_Node_Any_Option = a_Node.getAttributes().getNamedItem("option");
                    if(l_Node_Any_Option != null){
                        String l_String_Filedname = l_Node_Any_Fieldname.getNodeValue();
                        String l_String_Mappedclass = l_Node_Any_Mappedclass.getNodeValue();
                        String l_String_Option = l_Node_Any_Option.getNodeValue();
                        l_boolean_Return = addArgumentANY(l_String_Filedname, l_String_Mappedclass, l_String_Option);
                    }
                }
            }
        }
        return l_boolean_Return;
    }
    static public boolean isANYNode(Node a_Node){
        boolean l_boolean_Return = false;
        if(a_Node.getNodeType() == Node.ELEMENT_NODE){
            String l_String_NodeName = a_Node.getNodeName();
            if(l_String_NodeName.equals("any")) l_boolean_Return = true;
        }
        return l_boolean_Return;
    }
}
