package dataTypeInterface;

import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1Lib.ANY;
import gov.nist.div897.Asn1Lib.BITSTRING;
import gov.nist.div897.Asn1Lib.CHOICE;
import gov.nist.div897.Asn1Lib.INTEGER;
import gov.nist.div897.Asn1Lib.OCTETSTRING;
import gov.nist.div897.Asn1Lib.SEQUENCE;
import gov.nist.div897.Asn1Lib.SEQUENCEOF;

public class ComponentAsnServer {
	static public IComponentAsn instantiateAsnComponent(IComponentAsn parent, Asn1Object objAsn){
		IComponentAsn comp = null;
		if (objAsn instanceof INTEGER) {
			INTEGER integer = (INTEGER) objAsn;
			comp = new ComponentAsnInteger(integer);
			
		}
		else if (objAsn instanceof SEQUENCE) {
			SEQUENCE sequence = (SEQUENCE) objAsn;
			comp = new ComponentAsnSequence(sequence);
			
		}
		else if (objAsn instanceof SEQUENCEOF) {
			SEQUENCEOF sequenceof = (SEQUENCEOF) objAsn;
			comp = new ComponentAsnSequenceOf(sequenceof);
			
		}
		
		else if (objAsn instanceof BITSTRING) {
			BITSTRING bitString = (BITSTRING) objAsn;
			comp = new ComponentAsnBitString(bitString);
			
		}
		else if(objAsn instanceof CHOICE) {
			CHOICE choice = (CHOICE) objAsn;
			comp = new ComponentAsnChoice(choice);
		}
		else if(objAsn instanceof OCTETSTRING){
			OCTETSTRING octetString = (OCTETSTRING) objAsn;
			comp = new ComponentAsnOctetString(octetString);
		}
		else if(objAsn instanceof ANY){
			ANY any = (ANY) objAsn;
			comp = new ComponentAsnAny(any, parent);
		}
		return comp;
	}
	
}
