package dataTypeInterface;

import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1Lib.SEQUENCE;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

import addingsToAsnLib.ValidateAsnObject;

public class ComponentAsnSequence implements IComponentAsn{
	Vector<IComponentAsn> vectComponents;
	JPanel seqPanel = null;
	SEQUENCE sequence = null;
	CollapsablePanel colPanel;
	
	public ComponentAsnSequence(SEQUENCE seq){
		sequence = seq;
		vectComponents = new Vector<IComponentAsn>();
		initComponents();
	}

	private void initComponents(){
		String toolTipText = Asn1ModuleServer.getNameASN1Type(sequence.getClass());
		seqPanel = new JPanel();
		
		colPanel = new CollapsablePanel();
		colPanel.setCollapsablePan(seqPanel);
		
		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.LINE_AXIS));		
				
		JLabel label = new JLabel(sequence.getNameInstance());
		label.setPreferredSize(new Dimension(90,0));
		label.setToolTipText(toolTipText);
		p.add(label);
		
		colPanel.setHeaderPan(p);
		
		seqPanel.setLayout(new BoxLayout(seqPanel, BoxLayout.PAGE_AXIS));
		//seqPanel.setBorder(BorderFactory.createTitledBorder(sequence.getNameInstance()));
		
		for(int i = 0; i < sequence.getSequenceCount(); i++){
			Asn1Object objAsn = sequence.getSequenceObject(i);
			IComponentAsn comp = null;
			
			IComponentAsn compTemp = null;
			if( i != 0){
				compTemp = vectComponents.get(vectComponents.size() - 1);
			}
			comp = ComponentAsnServer.instantiateAsnComponent(compTemp , objAsn);
			
			if(comp != null){
				seqPanel.add(comp.getComponent());
				//seqPanel.add(Box.createRigidArea(new Dimension(20,10)));
				
				vectComponents.add(comp);
			}
		}
	}
	public boolean saveData() {
		boolean ret = true;
		String error = "";
		for(int i = 0; i < vectComponents.size(); i++){
			IComponentAsn objComp = (IComponentAsn)vectComponents.get(i);
			if(!objComp.saveData()){
				ret = false;
				error = error.concat(ValidateAsnObject.getErrorMessage());
			}
		}
		ValidateAsnObject.setErrorMessage(error);
		return ret;
	}

	public void updateDataComp() {
		for(int i = 0; i < vectComponents.size(); i++){
			IComponentAsn objComp = (IComponentAsn)vectComponents.get(i);
			objComp.updateDataComp();
		}		
	}

	public Component getComponent() {
		return colPanel;
	}

	public Asn1Object getAsn1Object() {
		return sequence;
	}
	
}
