package transport;

import java.util.Vector;

/**
 * Represents a node of the tree table representing ICS transport 
 * @author MC
 *
 */
public class TableNode { 
    public String[] row; 
    Vector<TableNode> children;
    String defaultValues;
    public TableNode(String [] rowIn){
    	row = rowIn;
    	children = new Vector<TableNode>();
    	defaultValues = "";
    }
    public void addChild(TableNode child){
    	children.add(child);
    }
    public Vector getChildren(){
    	if(children.size() != 0)
    		return children;
    	else
    		return null;
    }
    
    /**
     * Returns the the string to be used to display this leaf in the JTree.
     */
    public String toString() { 
    	return row[0];
    }

}
