package modifyIcs;

import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;


/**
 * This panel allows viewing an ICS table to modify
 * @author MC
 */
public class JPanelICSTable extends JPanel {
    private static final long serialVersionUID = 1L;
    private Document doc;
    private JScrollPane jScrollPane;
    public JTableModifyICS jTable = null;
    private ICSDocuments icsDocs;
    
    public void setICSDocs(ICSDocuments obj)
    {
        icsDocs = obj;
        if(jTable != null)
        	jTable.setICSDocs(obj);
    }
    /**
     * Creates a new instance of JPanelICSTable
     */
    public JPanelICSTable() {
        super(new GridLayout());
    }
    /**
     * saveTable
     * @return
     */
    public Document saveTable()
    {
        return jTable.getDocSaved();
    }
    /**
     * createTableGeneral
     * @param docIn
     */
    public void createTableGeneral(Document docIn)
    {
        doc = docIn;
        if(jTable == null){
	        jTable = new JTableModifyGeneralICS(new DomToTableModelAdapter(doc));
	        jTable.setICSDocs(icsDocs);
	        jScrollPane = new JScrollPane(jTable);
	        add(jScrollPane);
	        setBorder(javax.swing.BorderFactory.createEmptyBorder());
        }
        else
        	jTable.setModel(new DomToTableModelAdapter(doc));
    }   
    /**
     * createTableService
     * @param docIn
     */
    public void createTableService(Document docIn)
    {
        doc = docIn;
        if(jTable == null){
	        jTable = new JTableModifyServiceICS(new DomToTableModelAdapter(doc));
	        jTable.setICSDocs(icsDocs);
	        jScrollPane = new JScrollPane(jTable);
	        add(jScrollPane);
	        setBorder(javax.swing.BorderFactory.createEmptyBorder());
        }
        else
        	jTable.setModel(new DomToTableModelAdapter(doc));
    } 
    
    public void init(){
    	if(jScrollPane != null){
    		remove(jScrollPane);
    		jTable = null;
    	}
    }
}
