/*
 * XMLFileFilter.java
 *
 * Created on March 16, 2004, 12:11 PM
 */
package icsDyn;

/**
 *
 * @author  Rob Snelick
 * Extend the File Filter class so that only certain extensions are allowed with
 * use in the File Chooser. Here we limit this to XML files only.
 */
public class XMLFileFilter extends javax.swing.filechooser.FileFilter {
  
  public boolean accept(java.io.File f) {
    
    if (f.isDirectory()) {
      return true;
    }

    String extension = ExtUtils.getExtension(f);
    if (extension != null) {
      if (extension.equals(ExtUtils.xml)) {
        return true;
      } else {
        return false;
      }
    }
    return false;
  }
 
  public String getDescription() {
    return ("XML files");
  }
  
}
