package icsDyn;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

/**
 * This dialog represents the about dialog
 * @author MC
 *
 */
public class AboutDialog extends JDialog implements ActionListener{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private JLabel lblTxt;
	private JButton btnOK;
	private JLabel lblImage;
	public Component parent;
	private static final String imagePath = "../img/logo-ICSGenerator.png";
	public AboutDialog(Component parent, JFrame frame){
		super(frame, true);
		frame.setIconImage(new ImageIcon(imagePath).getImage());
		setTitle("About ICSGenerator");
		setResizable(false);
		initComponents();
		pack();
		setLocationRelativeTo(parent);
		
	}
	private void initComponents() {
		JPanel p = new JPanel();
		p.setLayout(new BorderLayout());
		
		JPanel p1 = new JPanel();
		p1.setLayout(new BorderLayout());
		lblTxt = new JLabel();
		lblTxt.setOpaque(true);
		lblTxt.setBackground(Color.white);
		lblTxt.setVerticalAlignment(SwingConstants.TOP);
		lblTxt.setText("<html>  ICSGenerator <br/<br>  Version 2.1</br><br/<br/Developed by <br/ <B color=\"blue\">National Intitute of Standards and Technology</b> <br/<br/ Contacts : <br/richard.rivello@nist.gov, <br/sandra.martinez@nist.gov <br/<br/</html>");
		lblTxt.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		
		lblImage = new JLabel(new ImageIcon(imagePath));
		lblImage.setPreferredSize(new Dimension(50,80));
		p1.add(lblImage, BorderLayout.WEST);
		p1.add(lblTxt, BorderLayout.CENTER);
		
		JPanel p2 = new JPanel();
		p2.setBorder(BorderFactory.createEtchedBorder());
		
		btnOK = new JButton("OK");
		btnOK.addActionListener(this);
		p2.add(btnOK);
		
		p.add(p1, BorderLayout.CENTER);
		p.add(p2, BorderLayout.PAGE_END);
		
		setLayout(new GridLayout());
		add(p);
	}
	public void actionPerformed(ActionEvent arg0) {
		if(arg0.getSource().equals(btnOK)){
			dispose();
		}		
	}

}
