
package icsTables;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

/**
 * This the Panel displaying an ICS Table
 * @author  MC
 */
public class ICSTablePanel extends javax.swing.JPanel {
    
    private static final long serialVersionUID = 1L;
    /** Creates new form NewJPanel */
    public ICSTablePanel() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * 
     */
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanDescription = new javax.swing.JPanel();
        jLabelDescription = new javax.swing.JLabel();
        jBtnSave = new javax.swing.JButton();
        jScrollPanTable = new javax.swing.JScrollPane();
        jLabelTable = new javax.swing.JLabel();
        jLabelNotice = new JLabel("(Private and external objects are highlighted in purple)");
        jLabelNotice.setFont(new Font("Times New Roman", Font.ITALIC, 10));

        setLayout(new java.awt.GridBagLayout());

        jPanDescription.setLayout(new java.awt.GridBagLayout());

        jLabelDescription.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabelDescription.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanDescription.add(jLabelDescription, gridBagConstraints);
        

        jBtnSave.setText("Export HTML File...");
        jBtnSave.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jBtnSaveMouseClicked(evt);
            }
        });
        
        jBtnSave.setBackground(new Color(204, 204, 255));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        jPanDescription.add(jBtnSave, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        add(jPanDescription, gridBagConstraints);

        jLabelTable.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jScrollPanTable.setViewportView(jLabelTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jScrollPanTable, gridBagConstraints);

    }

    /**
     * jBtnSaveMouseClicked
     * @param evt
     */
    private void jBtnSaveMouseClicked(java.awt.event.MouseEvent evt) {
        JFileChooser chooser = new javax.swing.JFileChooser();
        //chooser.setApproveButtonText("Save");
        chooser.setDialogType(JFileChooser.SAVE_DIALOG);
        chooser.setCurrentDirectory(new File(".."));
        chooser.setFileFilter(new HTMLFileFilter());
        int returnVal = chooser.showSaveDialog(this);
        if( returnVal == JFileChooser.APPROVE_OPTION)
        {
        try{
                boolean save = true;
                File selFile = chooser.getSelectedFile();
                if(!selFile.getPath().endsWith(".html"))
                    selFile = new File(selFile.getPath() + ".html");
                if(selFile.exists())
                {
                   save = false;     
                   returnVal = JOptionPane.showConfirmDialog(chooser, selFile.getAbsolutePath()+" already exists. Do you want to replace it?","Warning",JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
                   if(returnVal == JOptionPane.OK_OPTION)
                       save = true;
                }
                if(save)
                {
                    FileWriter writer = new FileWriter(selFile);
                    writer.write(jLabelTable.getText());
                    writer.close();
                }
            }
            catch(Exception e)
            {
                e.printStackTrace();
            }
        }        
    }
    
    
    // Variables declaration 
    private javax.swing.JButton jBtnSave;
    private javax.swing.JLabel jLabelDescription;
    private javax.swing.JLabel jLabelTable;
    private javax.swing.JPanel jPanDescription;
    private javax.swing.JScrollPane jScrollPanTable;
    private JLabel jLabelNotice;
    // End of variables declaration

    /**
	 * @uml.property  name="strTitle"
	 */
    protected String strTitle;
    
    /**
     * Creates a new instance of JICSPanel
     * @param objICSIn
     */
    public ICSTablePanel(ICSTableModel objICSIn)
    {
        initComponents();
        setDescription(objICSIn.strDescription);
        setTableName(objICSIn.strTableName);
        strTitle = objICSIn.strTitle;
        setTableTexte(objICSIn.getResultTransformation());
    }
    
    /**
     * Creates a new instance of JICSPanel
     * @param strTitleIn
     */
    public ICSTablePanel(String strTitleIn)
    {
        initComponents();
        strTitle = strTitleIn;
    }
    
    /**
     * setDescription
     * @param strDescription
     */
    void setDescription(String strDescription)
    {
        String str = "<HTML>";
        str = str.concat(strDescription);
        str += "<br><i><font size = 2> (Private and external objects are described in purple)</font></i></br>";
        str = str.concat("</HTML>   ");
        jLabelDescription.setText(str);
        
    }
    /**
     * setTableName
     * @param strTableName
     */
    void setTableName(String strTableName)
    {
        jPanDescription.setBorder(javax.swing.BorderFactory.createTitledBorder(strTableName));
    }
    /**
     * setTableTexte
     * @param strTableTexte
     */
    void setTableTexte(String strTableTexte)
    {
        jLabelTable.setText(strTableTexte);
    }
    /**
	 * getStrTitle
	 * @return  strTitle
	 * 
	 */
    public String getStrTitle()
    {
        return strTitle;
    }
}
