
package icsTables;

import java.io.File;
import org.w3c.dom.*;


/**
 * Implements an ICSTable
 * @author MC
 */
public  abstract class ICSTableModel {
	/**
	 * the table reference
	 * @uml.property  name="strTitle"
	 */
    protected String strTitle;
    /**
	 * the ICS Table name
	 * @uml.property  name="strTableName"
	 */
    protected String strTableName;
    /**
	 * the description of the ICSTable
	 * @uml.property  name="strDescription"
	 */
    protected String strDescription;
    /**
     * the xslt file path name
     */
    protected String strXsltFileName;
    /**
     * the default xml file containing the data for the table
     */
    protected String strDefaultXmlFile;
    /**
     * the DOM document containing the data 
     */
    protected Document docSrc = null;
    
    /** Creates a new instance of ICSTable 
     * @param strXMLFile xml file containing the data for ICS tables
     * */
    public ICSTableModel(String strXMLFile) {
        init();
        XMlXSLTClass obj = new XMlXSLTClass();
        docSrc = obj.readXMLFile(strXMLFile);
    }
    /**
     * init(), initialize the table attributes
     *
     */
    protected abstract void init();
    /**
     * Createa a new instance of ICSTable
     *
     */
    public ICSTableModel()
    {
        init();
    }
    /**
     * Creates a new instance of ICSTable
     * @param doc a dom document containing the data
     */
    public ICSTableModel(Document doc) {
        init();
        docSrc = doc;
    }
    
    /**
     * Class constructor 
     * 
     */
    public ICSTableModel(String strTitleIn, String strTableNameIn, String strDescriptionIn, String strXmlFileNameIn, String strXsltFileNameIn)
    {
        strTitle = strTitleIn;
        strTableName = strTableNameIn;
        strDescription = strDescriptionIn;
        strXsltFileName = strXsltFileNameIn;
        XMlXSLTClass obj = new XMlXSLTClass();
        docSrc = obj.readXMLFile(strXmlFileNameIn);
    }    
   
    
    /**
     * getResultTransformation
     * @return the html code for the ICS Table
     *
     */
    public String getResultTransformation()
    {
        XMlXSLTClass xsl = new XMlXSLTClass();
        String result = "";
        if(docSrc != null)
        {
        	Element racine = docSrc.getDocumentElement();
            racine.removeAttribute("xmlns");
        	//result  = xsl.getStringDocumentTransformedFromDoc(docSrc, strXsltFileName);
            result  = xsl.getStringDocumentDoubleTransformedFromDom(docSrc, strXsltFileName, "..\\XSLT\\genTable.xsl");
        }
        
        return result;
    }
    
    /**
	 * getStrTitle()
	 * @return  the table reference
	 * @uml.property  name="strTitle"
	 */
    public String getStrTitle()
    {
        return strTitle;
    }
    /**
	 * getStrTableName()
	 * @return  	the table name
	 * @uml.property  name="strTableName"
	 */
    public String getStrTableName()
    {
        return strTableName;
    }
    /**
	 * getStrDescription
	 * @return  	the table description
	 * 
	 */
    public String getStrDescription()
    {
        return strDescription;
    }
    /**
     * getDocument
     * @return	the source data DOM document
     */
    public Document getDocument()
    {
        return docSrc;
    }
    /**
     * setDocument
     * @param docIn	DOM document
     */
    public void setDocument(Document docIn)
    {
        docSrc = docIn;
    }
    /**
     * setDocumentFromXML
     * @param fileName	the xml file name
     */
    public void setDocumentFromXML(String fileName)
    {
        XMlXSLTClass obj = new XMlXSLTClass();
        docSrc = obj.readXMLFile(fileName);
    }
    /**
     * SaveXmlFile, save the dom document 
     * @param file	the destination file
     */
    public void SaveXmlFile(File file)
    {
        XMlXSLTClass obj = new XMlXSLTClass();
        obj.DomToFile(docSrc, file);
    }
    /**
     * getDefaultXmlFile
     * @return	the default xml file containing the data
     */
    public String getDefaultXmlFile()
    {
        return strDefaultXmlFile;
    }
  }
