package icsDyn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 * This class is the panel containing a selected object properties
 * @author Rick Rivello  
 */
public class RightValuePanel extends JPanel implements Observer, ActionListener, ListSelectionListener, ItemListener {

    private static final long serialVersionUID = 1L;

    private JTextField txtIndex;
    private JComboBox cbAttribute;
    private JComboBox cbBehaviour;
    private JComboBox cbNotification;
    private JTextField txtFeature;
    private JTextField txtLabel;
    private JTextField txtReference;
    private JTextField txtRestrictions;
    private JTextField txtMocApplicationGuidance;
    private JTextArea textComments;
    private JTextField txtTypeID;
    private JTextField txtTermCode;
    private JPanel pMultipleValue;
    private JButton btnAdd;
    private JButton btnRemove;
    private JCheckBox createbox;
    private JCheckBox deletebox;
    private Vector<String> vComboAttrModel;
    private Vector<String> vComboNotificationModel;
    private Vector<String> vComboBehaviourModel;
    private Vector vAttribute;
    private Vector vBehaviour;
    private Vector vNotification;   
    public MOCNode pn;
    private int mocIdNumber;
    private int tempmocIdNumber;  
    private AddAttrDialog dlgAddAttr;
    private AddNotificationDialog dlgAddNotification;
    private AddBehaviourDialog dlgAddBehaviour;
    String[] sUsage;
    
    private ICSModel icsModel;

    /**
     * Constructor
     */
    public RightValuePanel() {
	setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	JLabel lblIndex = new JLabel("Object Class(OID-TYPE): ");
	p0.add(Box.createRigidArea(new Dimension(20, 0)));
	lblIndex.setPreferredSize(new Dimension(150,0));
	p0.add(lblIndex);
	txtIndex = new JTextField();
	txtIndex.setEditable(false);
	txtIndex.setBackground(Color.WHITE);
	p0.add(txtIndex);
	p0.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p1 = new JPanel();
	p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
	JLabel lblFeatureName = new JLabel("Object Name: ");
	p1.add(Box.createRigidArea(new Dimension(20, 0)));
	lblFeatureName.setPreferredSize(new Dimension(150,0));
	p1.add(lblFeatureName);
	txtFeature = new JTextField();
	txtFeature.setEditable(false);
	txtFeature.setBackground(Color.WHITE);
	p1.add(txtFeature);
	p1.add(Box.createRigidArea(new Dimension(20, 0)));
	
	
	JPanel p9 = new JPanel();
	p9.setLayout(new BoxLayout(p9, BoxLayout.LINE_AXIS));
	JLabel lblFeatureTypeId = new JLabel("Object Type ID(TYPE): ");
	p9.add(Box.createRigidArea(new Dimension(20, 0)));
	lblFeatureTypeId.setPreferredSize(new Dimension(150,0));
	p9.add(lblFeatureTypeId);
	txtTypeID = new JTextField();
	txtTypeID.setEditable(true);
	txtTypeID.setBackground(Color.WHITE);
	txtTypeID.setPreferredSize(new Dimension(150, -1));
	p9.add(txtTypeID);
	JLabel lblFeatureTermeCode = new JLabel("Term Code: ");
	p9.add(lblFeatureTermeCode);
	//p9.add(Box.createRigidArea(new Dimension(100, 0)));
	txtTermCode = new JTextField();
	txtTermCode.setEditable(true);
	txtTermCode.setPreferredSize(new Dimension(20,0));
	txtTermCode.setBackground(Color.WHITE);
	p9.add(txtTermCode);
	p9.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p3 = new JPanel();
	p3.setLayout(new BoxLayout(p3, BoxLayout.LINE_AXIS));
	JLabel lblName = new JLabel("Label: ");
	p3.add(Box.createRigidArea(new Dimension(20, 0)));
	lblName.setPreferredSize(new Dimension(150,0));
	p3.add(lblName);
	txtLabel = new JTextField();
	txtLabel.setEditable(true);
	txtLabel.setBackground(Color.WHITE);
	p3.add(txtLabel);
	p3.add(Box.createRigidArea(new Dimension(20, 0))); 

	JPanel p2 = new JPanel();
	p2.setLayout(new BoxLayout(p2, BoxLayout.LINE_AXIS));
	JLabel lblReference = new JLabel("Reference: ");
	lblReference.setPreferredSize(new Dimension(150,0));
	p2.add(Box.createRigidArea(new Dimension(20, 0)));
	p2.add(lblReference);
	txtReference = new JTextField();
	txtReference.setEditable(false);
	//txtReference.setText("7.3.1.1");
	txtReference.setBackground(Color.WHITE);
	p2.add(txtReference);
	p2.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p4 = new JPanel();
	p4.setLayout(new BoxLayout(p4, BoxLayout.LINE_AXIS));
	JLabel lblAttrName = new JLabel("Attribute Name: ");
	p4.add(Box.createRigidArea(new Dimension(20, 0)));
	lblAttrName.setPreferredSize(new Dimension(150,0));
	p4.add(lblAttrName);
	cbAttribute = new JComboBox();
	cbAttribute.addActionListener( this ); // Watch for changes
        cbAttribute.setBackground(Color.WHITE);
	p4.add(cbAttribute);
	p4.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p41 = new JPanel();
	p41.setLayout(new BoxLayout(p41, BoxLayout.LINE_AXIS));
	JLabel lblNotice = new JLabel("(Private attributes are highlighted in purple)");
	lblNotice.setFont(new Font("Times New Roman", Font.ITALIC, 10));
	p41.add(Box.createRigidArea(new Dimension(170, 0)));
	p41.add(lblNotice);
	

	JPanel p11 = new JPanel();
	p11.setLayout(new BoxLayout(p11, BoxLayout.LINE_AXIS));
	JLabel lblBehaviourName = new JLabel("Behaviour Name: ");
	lblBehaviourName.setPreferredSize(new Dimension(150,0));
	p11.add(Box.createRigidArea(new Dimension(20, 0)));
	p11.add(lblBehaviourName);
	cbBehaviour = new JComboBox();
	cbBehaviour.addActionListener( this ); //	 Watch for changes
    cbBehaviour.setBackground(Color.WHITE);
	p11.add(cbBehaviour);
	p11.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p12 = new JPanel();
	p12.setLayout(new BoxLayout(p12, BoxLayout.LINE_AXIS));
	JLabel lblNotificationName = new JLabel("Notification Name: ");
	lblNotificationName.setPreferredSize(new Dimension(150,0));
	p12.add(Box.createRigidArea(new Dimension(20, 0)));
	p12.add(lblNotificationName);
	cbNotification = new JComboBox();
	cbNotification.addActionListener( this ); //	 Watch for changes
    cbNotification.setBackground(Color.WHITE);
	p12.add(cbNotification);
	p12.add(Box.createRigidArea(new Dimension(20, 0)));

	JPanel p6 = new JPanel();
	p6.setLayout(new BoxLayout(p6, BoxLayout.LINE_AXIS));
	JLabel lblRestrictions = new JLabel("Restrictions: ");
	lblRestrictions.setPreferredSize(new Dimension(150,0));
	p6.add(Box.createRigidArea(new Dimension(20, 0)));
	p6.add(lblRestrictions);
	txtRestrictions = new JTextField();
	txtRestrictions.setEditable(true);
	txtRestrictions.setBackground(Color.WHITE);
	p6.add(txtRestrictions);
	p6.add(Box.createRigidArea(new Dimension(20, 0)));

	JPanel p60 = new JPanel();
	p60.setLayout(new BoxLayout(p60, BoxLayout.LINE_AXIS));
	JLabel lblMocApplcicationGuidance = new JLabel("Application Guidance: ");
	lblMocApplcicationGuidance.setPreferredSize(new Dimension(150,0));
	p60.add(Box.createRigidArea(new Dimension(20, 0)));
	p60.add(lblMocApplcicationGuidance);
	txtMocApplicationGuidance = new JTextField();
	txtMocApplicationGuidance.setEditable(true);
	txtMocApplicationGuidance.setBackground(Color.WHITE);
	p60.add(txtMocApplicationGuidance);
	p60.add(Box.createRigidArea(new Dimension(20, 0)));

	JPanel p61 = new JPanel();
	p61.setLayout(new BoxLayout(p61, BoxLayout.LINE_AXIS));
	JLabel lblServiceSupport = new JLabel("SUPPORT:");
	lblServiceSupport.setPreferredSize(new Dimension(150, 0));
	p61.add(Box.createRigidArea(new Dimension(20, 0)));
	p61.add(lblServiceSupport);
    createbox = new JCheckBox("<html>CREATE Service Support</html>");
    createbox.setSelected(false);
    deletebox = new JCheckBox("<html>DELETE Service Support</html>");
    deletebox.setSelected(false);
    createbox.addItemListener(this);
    deletebox.addItemListener(this);
    p61.add(createbox);
    p61.add(deletebox);
	p61.add(Box.createRigidArea(new Dimension(20, 0)));
		
	JPanel p5 = new JPanel();
	p5.setLayout(new BoxLayout(p5, BoxLayout.LINE_AXIS));
	p5.add(Box.createRigidArea(new Dimension(20, 0)));
	textComments = new JTextArea();
	textComments.setEditable(true);
	textComments.setFont(new Font("Serif", Font.ITALIC, 16));
	textComments.setLineWrap(true);
	textComments.setWrapStyleWord(true);
	JScrollPane areaScrollPane = new JScrollPane(textComments);
	areaScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
	areaScrollPane.setPreferredSize(new Dimension(150, 150));
	areaScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Comments"),
	BorderFactory.createEmptyBorder(5,5,5,5)),areaScrollPane.getBorder()));
	p5.add(areaScrollPane);
	p5.add(Box.createRigidArea(new Dimension(20, 0)));
	textComments.setText("testing");
	
	add(p0);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p1);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p9);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p3);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p2);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p4);
	add(p41);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p11);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p12);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p6);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p60);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p61);
	add(Box.createRigidArea(new Dimension(0, 5)));
	add(p5);
	add(Box.createRigidArea(new Dimension(0, 5)));	

	setBorder(BorderFactory.createEmptyBorder(10,5,5,5));  // spaces top,botton,right,left

	pMultipleValue = new JPanel();
	pMultipleValue.setLayout(new BoxLayout(pMultipleValue, BoxLayout.LINE_AXIS));

	JPanel p8 = new JPanel();
	p8.setLayout(new BoxLayout(p8, BoxLayout.PAGE_AXIS));
	btnAdd = new JButton("Add changes");
	btnAdd.addActionListener(this);
	btnAdd.setBackground(new Color(204, 204, 255));
	p8.add(btnAdd);
	p8.add(Box.createRigidArea(new Dimension(0, 5)));
	
	pMultipleValue.add(Box.createRigidArea(new Dimension(10, 0)));
	pMultipleValue.add(p8);
	pMultipleValue.add(Box.createRigidArea(new Dimension(20, 0)));
	add(pMultipleValue);	
	
	init();
    }

    
    /**
     * Set the model
     * @param model The model
     */
    public void setICSModel(ICSModel model) {
    	icsModel = model;
    }
    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
    	Object empty ="";
	if(evt.getSource() == btnAdd) {
	    icsModel.setGenerateEnable(true);
        String label = txtLabel.getText();
	    String restrictions = txtRestrictions.getText();
        String mocapplicationguidance = txtMocApplicationGuidance.getText();
	    String comments = textComments.getText();
	    String typeId = txtTypeID.getText();
	    String typeIdTermCode = txtTermCode.getText();

        int mocIdNumber = pn.getMocIdNumber();
        int inx = icsModel.getcurVMoc().indexOf(pn);    		     
        MOCNode vmocNode = (MOCNode)icsModel.getcurVMoc().get(inx);
        int tempmocIdNumber = vmocNode.getMocIdNumber();

        while (tempmocIdNumber != mocIdNumber) {
           inx = icsModel.getcurVMoc().indexOf(pn,inx+1);
           vmocNode = (MOCNode)icsModel.getcurVMoc().get(inx);
           tempmocIdNumber = vmocNode.getMocIdNumber();
        }   
   
	    vmocNode.setObjectNameLabel(label);
	    vmocNode.setMocComment(comments); 
        vmocNode.setMocRestrictions(restrictions);
        vmocNode.setMocApplicationGuidance(mocapplicationguidance);
        vmocNode.setTypeID(typeId);
        vmocNode.setTypeIDTermCode(typeIdTermCode);

        String crdel1 = "";
        boolean blank_flag = false;

        if (createbox.isSelected()) {
           blank_flag = true;
           crdel1 = "CREATE";
        }
        if (deletebox.isSelected()) {
           if (blank_flag) {
              crdel1 = crdel1+" "+"DELETE";
           }
           else {
              crdel1 = "DELETE";
              blank_flag = true;
           }
        }
	    vmocNode.setMocServicesSupported(crdel1);
            	    
	    icsModel.getcurVMoc().set(inx,vmocNode);		    
	    icsModel.fireEvent(new MVCArg("tree status","tree changed"));		    
	}
	if(evt.getSource() == btnRemove) {	  
	    btnRemove.setEnabled(false);	 ;		  
	    txtReference.setText("");	
	    textComments.setText("");
	    pn.setMocComment(""); 
	    txtRestrictions.setText("");
            txtMocApplicationGuidance.setText("");
	    textComments.setText("");
	}
	if( evt.getSource() == cbAttribute)
	{		
	   if((cbAttribute.getSelectedItem() != null) && ((String)cbAttribute.getSelectedItem() != "") && !(cbAttribute.getSelectedItem().equals(empty))){	   	
		dlgAddAttr = new AddAttrDialog(null,cbAttribute.getSelectedItem(), pn, icsModel);
		dlgAddAttr.pack();
		
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension windowSize = dlgAddAttr.getSize();
		dlgAddAttr.setLocation(Math.max(0,(screenSize.width -windowSize.width)/2),Math.max(0,(screenSize.height-windowSize.height)/2));
		dlgAddAttr.setVisible(true);
	   }	
	}
	
	if( evt.getSource() == cbBehaviour)
	{
		if(cbBehaviour.getSelectedItem() != null && ((String)cbBehaviour.getSelectedItem() != "") && !(cbBehaviour.getSelectedItem().equals(empty))){
		dlgAddBehaviour = new AddBehaviourDialog(null,cbBehaviour.getSelectedItem(), pn, icsModel);
		dlgAddBehaviour.pack();
		
		//Position the window in the screen
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension windowSize = dlgAddBehaviour.getSize();
		dlgAddBehaviour.setLocation(Math.max(0,(screenSize.width -windowSize.width)/2),Math.max(0,(screenSize.height-windowSize.height)/2));
		dlgAddBehaviour.setVisible(true);
		}
	}
	
	if( evt.getSource() == cbNotification)
	{
		if(cbNotification.getSelectedItem() != null && ((String)cbNotification.getSelectedItem() != "") && !(cbNotification.getSelectedItem().equals(empty))){
		dlgAddNotification = new AddNotificationDialog(null,cbNotification.getSelectedItem(), pn, icsModel);
		dlgAddNotification.pack();
		
		//Position the window in the screen
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension windowSize = dlgAddNotification.getSize();
		dlgAddNotification.setLocation(Math.max(0,(screenSize.width -windowSize.width)/2),Math.max(0,(screenSize.height-windowSize.height)/2));
		dlgAddNotification.setVisible(true);
		}
	}
	
    }

   
    public void update(Observable o, Object arg) {
    	if(o instanceof ICSModel)
    		if("node".equals(((MVCArg)arg).getName())) {
    		   cbAttribute.removeAllItems();
    		   cbBehaviour.removeAllItems();
    		   cbNotification.removeAllItems();    			
    		   btnAdd.setEnabled(true);
    		   Object obj = ((MVCArg)arg).getOValue();
    		   if(obj instanceof MOCNode) {  			
    		      pn = (MOCNode) obj;     //pn is a class object MOCNode
                      icsModel.setMOCNode(pn);
                      mocIdNumber = pn.getMocIdNumber();
 		    			
    		      int index = icsModel.getcurVMoc().indexOf(pn);
    		      MOCNode mocNode = (MOCNode)icsModel.getcurVMoc().get(index);
                      tempmocIdNumber = mocNode.getMocIdNumber();

                      while (tempmocIdNumber != mocIdNumber) {
                           index = icsModel.getcurVMoc().indexOf(pn,index+1);
                           mocNode = (MOCNode)icsModel.getcurVMoc().get(index);
                           tempmocIdNumber = mocNode.getMocIdNumber();
                      }
    			
    		      txtFeature.setText(mocNode.getObjectName());
                      txtLabel.setText(mocNode.getObjectNameLabel());
    		      txtReference.setText(mocNode.getReference());
    		      txtIndex.setText(mocNode.getObjectId());
    		      textComments.setText(mocNode.getMocComment());
                      txtRestrictions.setText(mocNode.getMocRestrictions());
                      txtMocApplicationGuidance.setText(mocNode.getMocApplicationGuidance());
                      txtTypeID.setText(mocNode.getTypeID());
                      txtTermCode.setText(mocNode.getTypeIDTermCode());

                      String crdel = mocNode.getMocServicesSupported();

                      createbox.setSelected(false);
                      deletebox.setSelected(false);

                      if (crdel != null) {
                         Vector<String> vcrdel = new Vector<String>();
                         StringTokenizer stringtoken = new StringTokenizer(crdel," ");
                         String token = null;
                         while (stringtoken.hasMoreTokens()) {
                            token = stringtoken.nextToken();
                            vcrdel.add(token);
                         }

                         for (int i = 0; i < vcrdel.size(); i++) {
                            if (vcrdel.get(i).equals("CREATE")) {
                               createbox.setSelected(true);
                            }
                            else if (vcrdel.get(i).equals("DELETE")) {
                               deletebox.setSelected(true);
                            }
                         }
                      }

    		      vAttribute = mocNode.getAttribute();
    		      vBehaviour = mocNode.getBehaviour();
    		      vNotification = mocNode.getNotification();
    		      boolean[] isPrivateAttr = new boolean[vAttribute.size()];
    		      boolean[] isPrivateBehav = new boolean[vBehaviour.size()];
    		      boolean[] isPrivateNoti = new boolean[vNotification.size()];
    		      
    		      for (int ac = 0; ac < vAttribute.size(); ac++) {
    	                 vComboAttrModel.add(((AttributeNode)vAttribute.get(ac)).getAttributeName());
    	                 if(((AttributeNode)vAttribute.get(ac)).isPrivate)
    	                	 isPrivateAttr[ac] = true;
    	                 else
    	                	 isPrivateAttr[ac] = false;
    	              }
    			
    		      ComboBoxModel model = new DefaultComboBoxModel(vComboAttrModel); //The vector should contain all the attributes for a particular object.
    		      cbAttribute.setModel(model);
    		      cbAttribute.setRenderer(new MyComboBoxRenderer(isPrivateAttr));
   
    			    			
    		      for (int ac = 0; ac < vBehaviour.size(); ac++) {    			
    		    	  vComboBehaviourModel.add(((BehaviourNode)vBehaviour.get(ac)).getMethodName());
    		    	  if(((BehaviourNode)vBehaviour.get(ac)).isPrivate)
 	                	 isPrivateBehav[ac] = true;
 	                 else
 	                	 isPrivateBehav[ac] = false;
    	              }
    		      ComboBoxModel bModel = new DefaultComboBoxModel(vComboBehaviourModel); //The vector should contain all the attributes for a particular object.
    		      cbBehaviour.setModel(bModel);
    		      cbBehaviour.setRenderer(new MyComboBoxRenderer(isPrivateBehav));
    		
    		      for (int ac = 0; ac < vNotification.size(); ac++) {        			
    		    	  vComboNotificationModel.add(((NotificationNode)vNotification.get(ac)).getNotificationName());
    		    	  if(((NotificationNode)vNotification.get(ac)).isPrivate)
 	                	 isPrivateNoti[ac] = true;
 	                 else
 	                	 isPrivateNoti[ac] = false;
        	      }
    			
    		      ComboBoxModel nModel = new DefaultComboBoxModel(vComboNotificationModel); //The vector should contain all the attributes for a particular object.
    		      cbNotification.setModel(nModel);
    		      cbNotification.setRenderer(new MyComboBoxRenderer(isPrivateNoti));
    		
    		      updateUI();
    		   }
    		}
    	}
        
    /**
     * Handles a list click event
     * @param evt The event
     */
    public void valueChanged(ListSelectionEvent evt) {
	btnRemove.setEnabled(true);

    }

    public void init() {
    	btnAdd.setEnabled(true);
    	vComboAttrModel = new Vector<String>();
    	vComboBehaviourModel = new Vector<String>();
    	vComboNotificationModel = new Vector<String>();    
   }
   public void itemStateChanged(ItemEvent e) {
   }	
}    

class MyComboBoxRenderer extends DefaultListCellRenderer implements ListCellRenderer{

        private static final long serialVersionUID = 1L;

	private boolean[] privateObj = null;
	public MyComboBoxRenderer(boolean[] privateObjIn){
		super();
		privateObj = privateObjIn;
	}

	public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean arg4) {	
		Component c =  super.getListCellRendererComponent(list, value, index, isSelected, arg4);
		try{
			if(privateObj[index])
				c.setForeground(new Color(138,43,226));
		}
		catch(Exception e){
	
		}
		return c;
	}
}
