package icsDyn;

import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

import modifyIcs.GeneralICSManagementView;
import modifyIcs.ICSDocuments;
import modifyIcs.ServiceICSManagementView;

import org.xml.sax.SAXException;

import transport.transportManagementViewPanel;

import comparingDevices.comparaisonManagementView;
import dataTypeInterface.Configuration;
import drawing.DrawingView;

/**
 * Thic class initializes the graphical interface and contains the main method
 * @author MC
 *
 */
public class ManagementView extends JFrame{

         private static final long serialVersionUID = 1L;  

	 	 
	 public ICSManagementView newContentPane;
	 public GeneralICSManagementView viewGeneral;
	 public ServiceICSManagementView viewService;
	 public transportManagementViewPanel viewTransport;
	 public DrawingView viewDrawing;
	 private comparaisonManagementView viewComp;
	 public ICSDocuments icsDocs;
	 public static final String logoPath = "../img/logo-ICSGenerator.png";
	 
	 
	 
	 private void initializeComponents() throws TransformerConfigurationException, SAXException, IOException, ParserConfigurationException, TransformerException{
		 //Create and set up the window.
	        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); 
	        
	        
	        
	        setJMenuBar((new MenuBarManager(this)).getMenuBar());

	        //Create and set up the content pane.
	        newContentPane = new ICSManagementView();    
	        //newContentPane.setOpaque(true); //content panes must be opaque
	        
	        
	        JTabbedPane jTabbedPane1 = new javax.swing.JTabbedPane();   
	        getContentPane().add(jTabbedPane1);
	        jTabbedPane1.add("DIM ICS", newContentPane); 
	        
	        
	        viewGeneral = new GeneralICSManagementView();
	        jTabbedPane1.add("General ICS",viewGeneral);
	        
	        viewService = new ServiceICSManagementView();
	        jTabbedPane1.add("Service Support ICS",viewService);
	        
	        viewTransport = new transportManagementViewPanel(null);
	        jTabbedPane1.add("Transport ICS",viewTransport);
	        
	        viewDrawing = new DrawingView(this);
	        jTabbedPane1.add("UML Diagram", viewDrawing);
	        
	        
	        viewComp = new comparaisonManagementView();
	        jTabbedPane1.add("Compare devices",viewComp);
	        
	        
	        icsDocs = new ICSDocuments();
	        icsDocs.addObserver(newContentPane.icsTablepanel);
	        newContentPane.icsTablepanel.setICSDocs(icsDocs);
	        viewGeneral.setICSDocs(icsDocs);
	        viewService.setICSDocs(icsDocs);
	        viewTransport.setICSDocs(icsDocs);
	        icsDocs.addObserver(viewDrawing);
	        
//	        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
//	        setLocation((int)(screensize.getWidth()/2 - getWidth()/2), (int)((screensize.getHeight()/2 - getHeight()/2)));

	       
	 }
     
	 public ManagementView() throws TransformerConfigurationException, SAXException, IOException, ParserConfigurationException, TransformerException{
		 super("ICSGENERATOR");
		 initializeComponents();
		 
		 Configuration l_Configuration = new Configuration("../ConfigurationFiles/Test07.xml");
//		Load Asn1Modules
	        String[] l_StringArray_Asn1ModulePaths = l_Configuration.getAsn1ModulePaths();
	        String[] l_StringArray_Asn1ModuleArgumentsPaths = l_Configuration.getAsn1ModuleArgumentsPaths();
	        Asn1ModuleServer.initialize(System.out,l_StringArray_Asn1ModulePaths,l_StringArray_Asn1ModuleArgumentsPaths);
	 }
	

    public static void main(String[] args) throws SAXException, IOException, ParserConfigurationException, TransformerConfigurationException, TransformerException{
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                try {
                	ManagementView frame = new ManagementView();
                    //Display the window.
        	        frame.setSize(800, 800);
        	        frame.setIconImage(new ImageIcon(logoPath).getImage());
        	        
        	        //to center the window in the screen
        	        frame.setLocationRelativeTo(null);
        	        //frame.pack();
        	        frame.setVisible(true);
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
            }
        });
    }
	
	public void init(){
		newContentPane.init();
		viewTransport.init();
		viewGeneral.init();
		viewService.init();			
		viewDrawing.init();
		
		icsDocs = new ICSDocuments();
        icsDocs.addObserver(newContentPane.icsTablepanel);
        newContentPane.icsTablepanel.setICSDocs(icsDocs);
        viewGeneral.setICSDocs(icsDocs);
        viewService.setICSDocs(icsDocs);
        viewTransport.setICSDocs(icsDocs);
        icsDocs.addObserver(viewDrawing);
	}

}
