
// JDK
package icsDyn;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

// AWT
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

// Swing
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.BoxLayout;
import javax.swing.Box;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/**
 * This dialog allows the user to Add Notification Info
 * @author Rick Rivello
 *
 */
public class AddNotificationDialog extends JDialog implements Observer, ActionListener {

    private static final long serialVersionUID = 1L;

    private JTextField txtIndex;
    private JTextField txtReference;
    private JTextField txtNotificationName;
    private JTextField txtRestrictions;
    private JTextField txtQual;
    private JTextArea textComments;

    private JPanel pMultipleValue;

    private JList lstValue;
    private JScrollPane lstValueScrollPane;
    private JButton btnAdd;
    private JButton btnClose;

    private MOCNode mocNode;
    private Object attrSelected;
    
    private ICSModel icsModel;
    
    private final int minWidth = 400;
    private final int minHeight = 400;

     /**
     * Constructor
     * @param frame A frame
     */
    public AddNotificationDialog(JFrame frame, Object selection, MOCNode selectedMoc, ICSModel model) {
	super(frame, "Add a Notification", true);
	
	addComponentListener(new ComponentAdapter(){

		public void componentResized(ComponentEvent arg0) {
			if( getWidth() < minWidth)
				setSize(minWidth, getHeight());
			if(getHeight() < minHeight)
				setSize(getWidth(), minHeight);			
		}
		
	});
	
	
	setPreferredSize(new Dimension(400, 400));
	attrSelected = selection;
	setICSModel(model);
	
	BoxLayout layout = new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS);
	getContentPane().setLayout(layout);
	
	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	JLabel lblIndex = new JLabel("Index: ");
	p0.add(Box.createRigidArea(new Dimension(20, 0)));
	lblIndex.setPreferredSize(new Dimension(150,0));
	p0.add(lblIndex);
	txtIndex = new JTextField();
	txtIndex.setEditable(false);
	txtIndex.setBackground(Color.WHITE);
	p0.add(txtIndex);
	p0.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p1 = new JPanel();
	p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
	JLabel lblNotificationName = new JLabel("Notification Name: ");
	lblNotificationName.setPreferredSize(new Dimension(150,0));
	p1.add(Box.createRigidArea(new Dimension(20, 0)));
	p1.add(lblNotificationName);
	txtNotificationName = new JTextField();
	txtNotificationName.setEditable(true);
	txtNotificationName.setBackground(Color.WHITE);
	p1.add(txtNotificationName);
	p1.add(Box.createRigidArea(new Dimension(20, 0)));	

	JPanel p2 = new JPanel();
	p2.setLayout(new BoxLayout(p2, BoxLayout.LINE_AXIS));
	JLabel lblReference = new JLabel("Reference: ");
	lblReference.setPreferredSize(new Dimension(150,0));
	p2.add(Box.createRigidArea(new Dimension(20, 0)));
	p2.add(lblReference);
	txtReference = new JTextField();
	txtReference.setEditable(false);
	txtReference.setBackground(Color.WHITE);
	p2.add(txtReference);
	p2.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p22 = new JPanel();
	p22.setLayout(new BoxLayout(p22, BoxLayout.LINE_AXIS));
	JLabel lblQual = new JLabel("Status: ");
	lblQual.setPreferredSize(new Dimension(150,0));
	p22.add(Box.createRigidArea(new Dimension(20, 0)));
	p22.add(lblQual);
	txtQual = new JTextField();
	txtQual.setEditable(false);
	txtQual.setBackground(Color.WHITE);
	p22.add(txtQual);
	p22.add(Box.createRigidArea(new Dimension(20, 0)));
	
	JPanel p6 = new JPanel();
	p6.setLayout(new BoxLayout(p6, BoxLayout.LINE_AXIS));
	JLabel lblRestrictions = new JLabel("Restrictions: ");
	lblRestrictions.setPreferredSize(new Dimension(150,0));
	p6.add(Box.createRigidArea(new Dimension(20, 0)));
	p6.add(lblRestrictions);
	txtRestrictions = new JTextField();
	txtRestrictions.setEditable(true);
	txtRestrictions.setBackground(Color.WHITE);
	p6.add(txtRestrictions);
	p6.add(Box.createRigidArea(new Dimension(20, 0)));

	JPanel p7 = new JPanel();
	p7.setLayout(new BoxLayout(p7, BoxLayout.LINE_AXIS));
	p7.add(Box.createRigidArea(new Dimension(20, 0)));
        textComments = new JTextArea();
        textComments.setEditable(true);
        textComments.setFont(new Font("Serif", Font.ITALIC, 16));
        textComments.setLineWrap(true);
        textComments.setWrapStyleWord(true);
        JScrollPane areaScrollPane = new JScrollPane(textComments);
        areaScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        areaScrollPane.setPreferredSize(new Dimension(0, 150));
        areaScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Comments"),
                            BorderFactory.createEmptyBorder(5,5,5,5)),areaScrollPane.getBorder()));
        p7.add(areaScrollPane);
        p7.add(Box.createRigidArea(new Dimension(20, 0)));
	
    getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p0);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p1);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p2);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p22);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p6);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
	getContentPane().add(p7);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
//	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
//	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
//	getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));

	pMultipleValue = new JPanel();
	pMultipleValue.setLayout(new BoxLayout(pMultipleValue, BoxLayout.LINE_AXIS));

	JPanel p10 = new JPanel();
	p10.setLayout(new BoxLayout(p10, BoxLayout.PAGE_AXIS));
	lstValue = new JList();
	lstValueScrollPane = new JScrollPane(lstValue);
	p10.add(lstValueScrollPane);
	p10.add(Box.createRigidArea(new Dimension(0, 10)));

	JPanel p8 = new JPanel();
	p8.setLayout(new BorderLayout());
	btnAdd = new JButton("Add");
	btnAdd.addActionListener(this);
	btnAdd.setBackground(new Color(204, 204, 255));
	p8.add(btnAdd, BorderLayout.WEST);
	p8.add(Box.createRigidArea(new Dimension(0, 5)));
	
	btnClose = new JButton("Close");
	btnClose.addActionListener((ActionListener) this);
	btnClose.setBackground(new Color(204, 204, 255));
	p8.add(btnClose, BorderLayout.EAST);

	pMultipleValue.add(Box.createRigidArea(new Dimension(20, 0)));
	//pMultipleValue.add(Box.createRigidArea(new Dimension(10, 0)));
	pMultipleValue.add(p8);
	pMultipleValue.add(Box.createRigidArea(new Dimension(20, 0)));
	getContentPane().add(pMultipleValue);
	getContentPane().add(Box.createRigidArea(new Dimension(0, 10)));
	init();
	
	if(icsModel != null ) {

           int mocIdNumber = selectedMoc.getMocIdNumber();
	   int index = icsModel.getcurVMoc().indexOf(selectedMoc);
	   mocNode = (MOCNode)icsModel.getcurVMoc().get(index);
           int tempmocIdNumber = mocNode.getMocIdNumber();

           while (tempmocIdNumber != mocIdNumber) {
              index = icsModel.getcurVMoc().indexOf(selectedMoc,index+1);
              mocNode = (MOCNode)icsModel.getcurVMoc().get(index);
              tempmocIdNumber = mocNode.getMocIdNumber();
           }			
	   Vector vNotification = mocNode.getNotification();
	   for (int ac = 0; ac < vNotification.size(); ac++) {
	   NotificationNode notificationNode = (NotificationNode)vNotification.get(ac);
    	   if (notificationNode.getNotificationName().equals(selection.toString())){
    	      txtReference.setText(notificationNode.getNotificationReference());
    	      txtIndex.setText(notificationNode.getNotificationId());
    	      txtNotificationName.setText(notificationNode.getNotificationName());
    	      txtQual.setText(notificationNode.getNotificationQual());
    	      txtRestrictions.setText(notificationNode.getNotificationRestrictions()); 
              textComments.setText(notificationNode.getNotificationComment());   					
           }
        }    	         
     }
  }

    /**
     * Set the model
     * @param model The model
     */
    public void setICSModel(ICSModel model) {
	icsModel = model;
    }
    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
	if(evt.getSource() == btnAdd) {
           MOCNode selMoc = icsModel.getMOCNode();

           int mocIdNumber = selMoc.getMocIdNumber();
           int inx = icsModel.getcurVMoc().indexOf(selMoc);
           mocNode = (MOCNode)icsModel.getcurVMoc().get(inx);
           int tempmocIdNumber = mocNode.getMocIdNumber();

           while (tempmocIdNumber != mocIdNumber) {
              inx = icsModel.getcurVMoc().indexOf(selMoc,inx+1);
              mocNode = (MOCNode)icsModel.getcurVMoc().get(inx);
              tempmocIdNumber = mocNode.getMocIdNumber();
           }	    
           Vector vNotification = mocNode.getNotification();
		
	   for (int ac = 0; ac < vNotification.size(); ac++) {
	      NotificationNode notificationNode = (NotificationNode)vNotification.get(ac);
	      if (notificationNode.getNotificationName().equals(attrSelected.toString())){
		 notificationNode.setNotificationRestrictions(txtRestrictions.getText());
                 notificationNode.setNotificationComment(textComments.getText());
	      }
           }
	    
	   setVisible(false);	    
	}
	else if(evt.getSource() == btnClose) {
           setVisible(false);
	}
    }
   
    public void update(Observable o, Object arg) {
    	if(o instanceof ICSModel) {
    	    if(arg instanceof MVCArg) {
    		if("node".equals(((MVCArg)arg).getName())) {
    			btnAdd.setEnabled(true);    		    
    		}
    	    }
    	}
    }
    /**
     * Handles a list click event
     * @param evt The event
     */

    private void init() {
    	btnAdd.setEnabled(true);
    }

}
