
// JDK
package icsDyn;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

// AWT
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

// Swing
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JComboBox;
import javax.swing.JButton;
import javax.swing.BoxLayout;
import javax.swing.Box;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * AddMOCDialog - Add Managed Object Class
 * @author Rick Rivello
 *
 */
public class AddMOCDialog extends JDialog implements ActionListener, Observer {

    private static final long serialVersionUID = 1L;

    private JComboBox cbSegment;

    private JButton btnAdd;
    private JButton btnClose;
    private JButton btnAddPrivate;

    private ICSModel icsModel;
    private DefaultMutableTreeNode currentNode;
    Vector<String> vMocSelectedChildren = new Vector<String>();

    /**
     * Constructor
     * @param frame A frame
     */
    public AddMOCDialog(JFrame frame) {
	super(frame, "Add a moc", true);

	BoxLayout layout = new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS);
	getContentPane().setLayout(layout);
       
	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	
	JLabel lbl1 = new JLabel("Choose MOC to add ");
	p0.add(lbl1);
	
	
	JLabel lbl2 = new JLabel(" to highlighted MOC: ");
	p0.add(lbl2);

	cbSegment = new JComboBox();
	p0.add(cbSegment);
	
	JPanel p1 = new JPanel();
	p1.setLayout(new BoxLayout(p1, BoxLayout.LINE_AXIS));
	btnAdd = new JButton("Add");
	btnAdd.addActionListener(this);
	btnAdd.setBackground(new Color(204, 204, 255));
	p1.add(btnAdd);
	p1.add(Box.createRigidArea(new Dimension(5, 0)));
	
	btnAddPrivate = new JButton("Add private MOC");
	btnAddPrivate.addActionListener(this);
	btnAddPrivate.setBackground(new Color(204, 204, 255));
	p1.add(btnAddPrivate);
	btnAddPrivate.setForeground(Color.RED);
	p1.add(Box.createRigidArea(new Dimension(5, 0)));
	
	btnClose = new JButton("Close");
	btnClose.addActionListener(this);
	btnClose.setBackground(new Color(204, 204, 255));
	p1.add(btnClose);

	JPanel p2 = new JPanel();
	p2.setLayout(new BoxLayout(p2, BoxLayout.PAGE_AXIS));
	p2.add(p0);
	p2.add(Box.createRigidArea(new Dimension(0, 10)));
	p2.add(p1);
	p2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
	getContentPane().add(p2);

	init(null);
    }
    
    
    /**
     * Handles a click event
     * @param evt The event
     */
    public void actionPerformed(ActionEvent evt) {
		if(evt.getSource() == btnAdd) {
		   icsModel.addMOC((String)cbSegment.getSelectedItem(),currentNode);	
		   setVisible(false);
		   dispose();
		}
		else if(evt.getSource() == btnClose) {
		   setVisible(false);
		   dispose();
		}
		else if(evt.getSource() == btnAddPrivate) {
			JFrame f = new JFrame("Add private MOC");
	    	 
	    	 
	    	 String[] labels = new String[3];
	    	 labels[0] = "Object Class (OID-TYPE):";
	    	 labels[1] = "Object Name:";
	    	 labels[2] = "Term Code:";
	    	 AddPrivateDialog dialog = new AddPrivateDialog(this, f,labels, AddPrivateDialog.privateMoc);
	    	 dialog.setLocationRelativeTo(this);
	    	 
	    	 dialog.pack();
	    	 
	    	 ICSModel icsM = new ICSModel();
	    	 icsM.addObserver(this);
	    	 dialog.setICSModel(icsM);
	    
	    	 dialog.setVisible(true);
		}
    }

    /**
     * Set the model
     * @param model The model
     */
    public void setICSModel(ICSModel model) {
	icsModel = model;
    }

    /**
     * Init the panel
     * @param The selected node
     */
    public void init(DefaultMutableTreeNode node) {
	cbSegment.setEnabled(true);
	cbSegment.removeAllItems();
	String noMoc = "No children";
	
	// dealing with private objects
	MOCNode moc = null;
	if(icsModel != null  && node != null)
	{
		moc = (MOCNode)node.getUserObject();
		if(moc.isPrivate){
		currentNode = node;
			vMocSelectedChildren.add(noMoc);
			ComboBoxModel model = new DefaultComboBoxModel(vMocSelectedChildren); 
			cbSegment.setModel(model);
		}
	}
	
	if(icsModel != null && node != null && !moc.isPrivate) {
            int VMD_Flag = 0;
            int Clock_Flag = 0;
            int Alert_Flag = 0;
            int Alert_Status_Flag = 0;
            int Alert_Monitor_Flag = 0;
            int Simple_MDS_Flag = 0;
            int Hydra_MDS_Flag = 0;
            int Composite_Single_Bed_MDS_Flag = 0;
            int Multipatient_Archive_Flag = 0;
	    currentNode = node;	

            Enumeration treeEnum = node.preorderEnumeration();
            while (treeEnum.hasMoreElements()) {
              
               String treeChild = treeEnum.nextElement().toString();
               if (treeChild.equals("VMD")) {
                  VMD_Flag = 1;
               }
               else if (treeChild.equals("Alert")) {
                  Alert_Flag = 1;
               }
               else if (treeChild.equals("Alert_Status")) {
                  Alert_Status_Flag = 1;
               }
               else if (treeChild.equals("Alert_Monitor")) {
                  Alert_Monitor_Flag = 1;
               }
               else if (treeChild.equals("Clock")) {
                  Clock_Flag = 1;
               }
               else if (treeChild.equals("Simple_MDS")) {
                  Simple_MDS_Flag = 1;
               }
               else if (treeChild.equals("Hydra_MDS")) {
                  Hydra_MDS_Flag = 1;
               }
               else if (treeChild.equals("Multipatient_Archive")) {
                  Multipatient_Archive_Flag = 1;
               }
               else if (treeChild.equals("Composite_Single_Bed_MDS")) {
                  Composite_Single_Bed_MDS_Flag = 1;
               }
            }
            
            DefaultMutableTreeNode dvecTree = icsModel.getDefaultTree();

            DefaultMutableTreeNode defRootNode = (DefaultMutableTreeNode) dvecTree.getRoot();
            if (defRootNode.toString().equals(currentNode.toString())) {
               Enumeration defRootChildren = defRootNode.children();
               while (defRootChildren.hasMoreElements()) {
                  String nextNd = defRootChildren.nextElement().toString();
                  if ((nextNd.equals("Composite_Single_Bed_MDS")) && (Composite_Single_Bed_MDS_Flag == 0)) { 
                     vMocSelectedChildren.add(nextNd);
                  }
                  else if ((nextNd.equals("Simple_MDS")) && (Simple_MDS_Flag == 0)) { 
                     vMocSelectedChildren.add(nextNd);
                  }
                  else if ((nextNd.equals("Hyrda_MDS")) && (Hydra_MDS_Flag == 0)) { 
                     vMocSelectedChildren.add(nextNd);
                  }
                  else if ((nextNd.equals("Multipatient_Archive")) && (Multipatient_Archive_Flag == 0)) { 
                     vMocSelectedChildren.add(nextNd);
                  }
               } 
            }
            else {
               int MatchFlag = 0;
               int Comp_SingleBedMDS = 0;
               Enumeration MOCNodes = defRootNode.depthFirstEnumeration();
               while (MatchFlag == 0) {
                  DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode) MOCNodes.nextElement();
                  if (nextNode.toString().equals(currentNode.toString())) {
                     Enumeration MatchChildNodes = nextNode.children();
                     while (MatchChildNodes.hasMoreElements()) {
                        String nextNd = MatchChildNodes.nextElement().toString();
                        if ((nextNd.equals("Alert")) && ((Alert_Status_Flag == 0) && (Alert_Monitor_Flag == 0))) { 
                           vMocSelectedChildren.add(nextNd);
                        }
                        else if ((nextNd.equals("Alert_Status")) && ((Alert_Flag == 0) && (Alert_Monitor_Flag == 0))) { 
                           vMocSelectedChildren.add(nextNd);
                        }
                        else if ((nextNd.equals("Alert_Monitor")) && ((Alert_Status_Flag == 0) && (Alert_Flag == 0))) { 
                           vMocSelectedChildren.add(nextNd);
                        }
                        else if (((currentNode.toString().equals("Simple_MDS")) && (nextNd.equals("VMD"))) && (VMD_Flag == 0)) { 
                           vMocSelectedChildren.add(nextNd);
                        }
                        else if ((currentNode.toString().equals("Composite_Single_Bed_MDS")) && (Comp_SingleBedMDS == 0)) {
                           vMocSelectedChildren.add(currentNode.toString());
                           vMocSelectedChildren.add(nextNd);
                           Comp_SingleBedMDS = 1;
                        }
                        else if ((currentNode.toString().equals("Composite_Single_Bed_MDS")) && ((nextNd.equals("Simple_MDS") || nextNd.equals("Hydra_MDS")))) {
                           vMocSelectedChildren.add(nextNd);
                        }
                        else if ((currentNode.toString().equals("Hydra_MDS")) && (nextNd.equals("VMD"))) {
                           vMocSelectedChildren.add(nextNd);
                        }
                        else if ((nextNd.equals("Clock")) && (Clock_Flag == 0)) { 
                           vMocSelectedChildren.add(nextNd);
                        }
                        else if (!(nextNd.equals("Alert")) && !(nextNd.equals("Alert_Status")) && !(nextNd.equals("Alert_Monitor")) &&
                                 !(nextNd.equals("Clock")) && !(nextNd.equals("VMD"))) {
                           vMocSelectedChildren.add(nextNd);
                        }
                     }
                     MatchFlag = 1;
                  }
               }
            }

	    if (vMocSelectedChildren.size() == 0){
	    	vMocSelectedChildren.add(noMoc);
	    }
	    
	    ComboBoxModel model = new DefaultComboBoxModel(vMocSelectedChildren); 
		cbSegment.setModel(model);
        }
    }
    
    public void update(Observable o, Object arg) {
		if(o instanceof ICSModel) {
			if(("private/"+AddPrivateDialog.privateMoc).equals(((MVCArg)arg).getName()) && icsModel != null) {
				String[] result = (String[]) ((MVCArg)arg).getOValue();
				MOCNode moc = new MOCNode();
				moc.object_id = result[1];
				moc.object_name = result[0];
				moc.moc_termcode = result[2];
				moc.isPrivate = true;
				icsModel.addPrivateMOC(moc,currentNode);
				dispose();
			}	
	}
}
}
