package drawing;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

/**
 * This class represents a class of the uml diagram
 * @author  MC
 */
public class UnitClass {
	/**
	 * the name of the class
	 */
	public String className;
	/**
	 * the x coordinate of the rectangle
	 */
	public int x;
	/**
	 * the y coordinate of the rectangle
	 */
	public int y;
	/**
	 * the rectangle height
	 */
	static final int height = 20;
	static private Graphics2D g2d;
	/**
	 * the relative x coordinate of the string
	 */
	static final int xName = 20;
	/**
	 * the relative y coordinate of the string
	 */
	
	private int width;
	/**
	 * constructor
	 * @param xin
	 * @param yin
	 * @param name
	 */
	public UnitClass(int xin, int yin, String name){
		x = xin;
		y = yin;
		className = name;
		FontMetrics fontMetrics = g2d.getFontMetrics();
		width = fontMetrics.stringWidth(name)+2*xName;		
	}
	/**
	 * constructor
	 * @param name
	 */
	public UnitClass(String name){
		x = 0;
		y = 0;
		className = name;
		FontMetrics fontMetrics = g2d.getFontMetrics();
		width = fontMetrics.stringWidth(name)+2*xName;
	}
	/**
	 * whether the class equals u -> compares the class names
	 * @param u
	 * @return
	 */
	public boolean isEqual(UnitClass u){
		if(u.className.equals(className))
			return true;
		else
			return false;
	}
	/**
	 * @param g2d  The g2d to set.
	 * 
	 */
	static public void setG2d(Graphics2D g2dIn){
		g2d = g2dIn;
	}
	/**
	 * @return  Returns the x.
	 * @uml.property  name="x"
	 */
	public int getX()
	{
		return x;
	}
	/**
	 * @return  Returns the y.
	 * @uml.property  name="y"
	 */
	public int getY()
	{
		return y;
	}
	/**
	 * @return  Returns the height.
	 *
	 */
	public int getHeight(){
		return height;
	}
	/**
	 * @return  Returns the width.
	 * 
	 */
	public int getWidth(){
		return width;
	}
	/**
	 * @return  Returns the xName.
	 * 
	 */
	public int getXName(){
		return xName + x;
	}
	/**
	 * @return  Returns the yName.
	 * 
	 */
	public int getYName(){
		FontMetrics fontMetrics = g2d.getFontMetrics();
		return y + Math.round((float)((fontMetrics.getHeight()/2 + height)/2));
	}
	public Rectangle getRectangle(){
		return new Rectangle(x, y, width, height);
	}
	/**
	 * @return  Returns the className.
	 *
	 */
	public String getClassName(){
		return className;
	}
	public boolean isOn(UnitClass u){
		double x0, y0;
		y0 = u.y + u.getHeight()/2;
		x0 = u.x + u.getWidth()/2;
		double a = (double)u.getHeight()/u.getWidth();
		boolean res = false;
		if(y + height/2 > a*(x + width/2) + y0 - a*x0 && y + height/2> a*(-x - width/2) + y0 + a*x0)
			res = true;
		return res;
	}
	public boolean isUnder(UnitClass u){
		double x0, y0;
		y0 = u.y + u.getHeight()/2;
		x0 = u.x + u.getWidth()/2;
		double a = (double)u.getHeight()/u.getWidth();
		boolean res = false;
		if(y + height/2 <= a*(x + width/2) + y0 - a*x0 && y + height/2 <= a*(-x - width/2) + y0 + a*x0)
			res = true;
		return res;
	}
	public boolean isRight(UnitClass u){
		double x0, y0;
		y0 = u.y + u.getHeight()/2;
		x0 = u.x + u.getWidth()/2;
		double a = (double)u.getHeight()/u.getWidth();
		boolean res = false;
		if(y + height/2 < a*(x + width/2) + y0 - a*x0 && y + height/2 > a*(-x - width/2) + y0 + a*x0)
			res = true;
		return res;
	}
	public boolean isLeft(UnitClass u){
		double x0, y0;
		y0 = u.y + u.getHeight()/2;
		x0 = u.x + u.getWidth()/2;
		double a = (double)u.getHeight()/u.getWidth();
		boolean res = false;
		if(y + height/2 > a*(x + width/2) + y0 - a*x0 && y + height/2 < a*(-x - width/2) + y0 + a*x0)
			res = true;
		return res;
	}
	/**
	 * determines the position of a class in comparison with u position
	 * @param u
	 * @return 1 if top, 2 if bottom, 3 if left and 4 if right
	 */
	public int position(UnitClass u){
		int pos = -1;
		double x0, y0;
		y0 = u.y + u.getHeight()/2;
		x0 = u.x + u.getWidth()/2;
		double a = (double)u.getHeight()/u.getWidth();
		double y1 = y + height/2;
		double yth1 = a*(x + width/2) + y0 - a*x0;
		double yth2 = a*(-x - width/2) + y0 + a*x0;
		if(y1 > yth1 && y1 > yth2)
			pos = 1;
		else if(y1 <= yth1 && y1 <= yth2)
			pos = 2;
		else if(y1 > yth1 && y1 < yth2)
			pos = 4;
		else if(y1 < yth1 && y1 > yth2)
			pos = 3;
		
		return pos;
	}
}
