package comparingDevices;

import java.util.Vector;

import javax.swing.table.AbstractTableModel;

/**
 * This class represents a table model for presenting the comparison results
 * @author MC
 *
 */
public class MyModel extends AbstractTableModel{
    private static final long serialVersionUID = 1L;
	public Vector vectMOC;
	public Vector vectCompareMoc;
	public Vector vectFileName;
	public MyModel(Vector vectMOCIn, Vector vectCompareIn, Vector vectFileNameIn){
		super();
		vectMOC = vectMOCIn;
		vectCompareMoc = vectCompareIn;
		vectFileName = vectFileNameIn;
	}
	public int getColumnCount() {
		// it is the number of devices + 1
		int count = 0;
		if(vectFileName.size() != 0)
		{
			count = vectFileName.size()+1;
		}
		return count;
	}
	/**
     * @see javax.swing.table.TableModel#getColumnName(int)
     */
    public String getColumnName(int column) {
    	if(column != 0 && column < vectFileName.size() + 1)
    		return (String)vectFileName.get(column - 1);
    	else
    		return "";
    }
	public int getRowCount() {
		// it is the number of MOC objects
		return vectMOC.size();
	}

	public Object getValueAt(int row, int col) {
		if(col == 0)
		{
			Base obj = (Base)vectMOC.get(row);
			return obj.name;
		}
		else
		{
			return ((Boolean[])vectCompareMoc.get(row))[col - 1];
		}
	}
	public Class<?> getColumnClass(int columnIndex) {
		if (columnIndex == 0)
			return String.class;
		else
			return Boolean.class;
    }
	
	
	/**
     * @see javax.swing.table.TableModel#isCellEditable(int, int)
     */
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;	        
    }
	
} 
