package addingsToAsnLib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1ILib.Range;
import gov.nist.div897.Asn1ILib.RangeArrayList;
import gov.nist.div897.Asn1Lib.BITSTRING;
import gov.nist.div897.Asn1Lib.INTEGER;
import gov.nist.div897.Asn1Lib.OCTETSTRING;
import gov.nist.div897.DimLib.FLOATType;

public class ValidateAsnObject {
	static protected String ErrorMessage = "";
	static public void setErrorMessage(String mess){
		ErrorMessage = mess;
	}
	static public String getErrorMessage(){
		return ErrorMessage;
	}
	static public boolean isValid(FLOATType floatType, String value){
		boolean ret = true;
		String errorMessage = "";
		if(value != null && value != ""){
			try{
				BigDecimal bigDec = new BigDecimal(value);
				//we need to test  the range of the integer
			}
			catch(Exception e){
				errorMessage = errorMessage.concat("-").concat(floatType.getNameInstance()).concat(" : not valid float value!\n");
				ret = false;
			}			
		}
		else if(value == ""){
			ret = false;
			errorMessage = errorMessage.concat("-").concat(floatType.getNameInstance()).concat(" : no value is specified!\n");
		}
		ErrorMessage = errorMessage;
		return ret;
	}
	static public boolean isValid(INTEGER integer, String value){
		boolean ret = true;
		String errorMessage = "";
		if (integer instanceof FLOATType) {
			FLOATType floatType = (FLOATType) integer;
			ret = isValid(floatType, value);
			errorMessage = errorMessage.concat(ErrorMessage);
		}
		else if(value != null && value != ""){
			try{
				BigInteger bigInt = new BigInteger(value);
				//we need to test  the range of the integer
				RangeArrayList rangeList = integer.getRangeArrayList();
				if(rangeList != null){
					boolean isInRange = false;
					BigInteger lowerBound = null;
					BigInteger upperBound = null;
					for(Range range:rangeList){
						lowerBound = range.getLowerBound().getDataAsBigInteger();
						if(range.getLowerBoundIncluded()){
							if(bigInt.compareTo(lowerBound) >=0)
								isInRange = true;
						}
						else{
							if(bigInt.compareTo(lowerBound) > 0)
								isInRange = true;
							
						}
						if(isInRange){
							upperBound = range.getUpperBound().getDataAsBigInteger();
							if(range.getUpperBoundIncluded()){
								if(bigInt.compareTo(upperBound) > 0)
									isInRange = false;
							}
							else{
								if(bigInt.compareTo(upperBound) >= 0)
									isInRange = false;
							}
						}
						if(isInRange){
							range = rangeList.get(rangeList.size() - 1);
						}
					}
					if(!isInRange){
						errorMessage = errorMessage.concat("-").concat(integer.getNameInstance()).concat(" : should be included between "+ lowerBound.toString()+ " and "+upperBound.toString()+ " !\n");
						ret = false;
					}
				}
			}
			catch(Exception e){
				errorMessage = errorMessage.concat("-").concat(integer.getNameInstance()).concat(" : not valid integer value!\n");
				ret = false;
			}			
		}
		else if(value == null || value == ""){
			ret = false;
			errorMessage = errorMessage.concat("-").concat(integer.getNameInstance()).concat(" : no value is specified!\n");
		}
		ErrorMessage = errorMessage;
		return ret;
	}
	
	static public boolean isValid(BITSTRING bitstring, String value){
		boolean ret = true;
		String errorMessage = "";
		if(value == null || value == ""){
			ret = false;
			errorMessage.concat("-").concat(bitstring.getNameInstance()).concat(" : no value is specified!\n");
		}
		else{
			Pattern p = Pattern.compile("[0-1]{0,}");
			Matcher m = p.matcher(value);
			boolean b = m.matches();
			if(b == false){
				ret = false;
				errorMessage = errorMessage.concat("-").concat(bitstring.getNameInstance()).concat(" : not valid bitString value!\n");
			}
		}
		ErrorMessage = errorMessage;
		return ret;
	}
	
	static public boolean isValid(OCTETSTRING octet, String value){
		boolean ret = true;
		String errorMessage = "";
		ErrorMessage = errorMessage;
		return ret;
	}
	
	
	
	static public boolean isValid(Asn1Object asnObj, String value){
		boolean ret = true;
		//String errorMessage = "";	
		
		if (asnObj instanceof INTEGER) {
			INTEGER integer = (INTEGER) asnObj;
			ret = isValid(integer, value);
		}
		else if (asnObj instanceof BITSTRING) {
			BITSTRING bitString = (BITSTRING) asnObj;
			ret = isValid(bitString, value);
		}
		else if (asnObj instanceof OCTETSTRING) {
			OCTETSTRING octetString = (OCTETSTRING) asnObj;
			ret = isValid(octetString, value);
		}
		
		return ret;
	}
}
