/*
 * Services.java
 *
 * Created on November 21, 2006, 12:11 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.Services;
import java.io.*;
import java.util.*;
import java.util.jar.*;
import java.net.URL;
import java.util.regex.*;
import java.net.URLClassLoader;
import java.math.*;
import java.nio.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.lang.reflect.*;

/**
 *
 * @author rtheimer
 */
public class Services {
    static final int m_int_MaxBytesOnLine=16;
    static private PrintStream m_PrintStream = System.out;
    
    /** Creates a new instance of Services */
    public Services() {
    }
    static public void setPrintStream(PrintStream a_PrintStream){
        m_PrintStream = a_PrintStream;
    }
    static public URL createURL(String a_String){
        URL l_URL_Return = null;
        try{
        	//l_URL_Return = new URL(new File(a_String).getCanonicalPath());
            l_URL_Return = new URL(a_String);
        } catch (Exception l_Exception){
        	l_Exception.printStackTrace();
            outputMessage_Exception(l_Exception);
        }
        return l_URL_Return;
    }
    static public JarFile createJarFile(URL a_URL){
        JarFile l_JarFile_Return = null;
        File l_File = new File(a_URL.getPath());
        try{
            l_JarFile_Return = new JarFile(l_File);
        } catch (Exception l_Exception){
            outputMessage_Exception(l_Exception);
        }
        return l_JarFile_Return;
    }
    static public URLClassLoader createURLClassLoader(ArrayList<URL> a_ArrayListURL){
        URLClassLoader l_URLClassLoader_Return = null;
        try{
            l_URLClassLoader_Return =
                    new URLClassLoader(a_ArrayListURL.toArray(new URL[a_ArrayListURL.size()]));
        } catch (Exception l_Exception){
            outputMessage_Exception(l_Exception);
        }
        return l_URLClassLoader_Return;
    }
    static public Class loadClass(URLClassLoader a_URLClassLoader, String a_String){
        Class l_Class_Return = null;
        try{
            l_Class_Return = a_URLClassLoader.loadClass(a_String);
        } catch (Exception l_Exception){
            outputMessage_Exception(l_Exception);
        }
        return l_Class_Return;
    }
    static public void outputMessage_Exception(Exception a_Exception){
        m_PrintStream.println(a_Exception.toString());
    	  
    }
    static public ArrayList<String> getJarClassNames(URL a_URL){
        ArrayList<String> l_ArrayListString_Return = new ArrayList<String>();
        String l_String_RegexFind = ".+\\.class$";
        String l_String_RegexReplace = "\\.class$";
        //ArrayList<String> l_ArrayListString = new ArrayList<String>();
        JarFile l_JarFile = createJarFile(a_URL);
        Enumeration<JarEntry> l_EnumerationJarEntry = l_JarFile.entries();
        for (Enumeration l_Enumeration=l_EnumerationJarEntry;l_Enumeration.hasMoreElements();){
            JarEntry l_JarEntry = (JarEntry)l_Enumeration.nextElement();
            String l_String_Name = l_JarEntry.getName();
            l_String_Name = l_String_Name.replace("/",".");
            Pattern l_Pattern = Pattern.compile(l_String_RegexFind);
            Matcher l_Matcher = l_Pattern.matcher(l_String_Name);
            if(l_Matcher.matches()){
                String l_String = l_String_Name.replaceAll(l_String_RegexReplace,"");
                l_ArrayListString_Return.add(l_String);
            }
        }
        return l_ArrayListString_Return;
    }
    static public ArrayList<String> getJarClassNames(ArrayList<URL> a_ArrayListURL){
        ArrayList<String> l_ArrayListString_Return = new ArrayList<String>();
        URL[] l_URLArray = a_ArrayListURL.toArray(new URL[a_ArrayListURL.size()]);
        for(URL l_URL : l_URLArray){
            l_ArrayListString_Return.addAll(getJarClassNames(l_URL));
        }
        return l_ArrayListString_Return;
    }
    static public ArrayList<Class> getClassInterfaces(Class a_Class){
        ArrayList<Class> l_ArrayListClass_Return = new ArrayList<Class>();
        Class l_Class = a_Class;
        while(l_Class != null){
            Class[] l_ClassArray_Interfaces = l_Class.getInterfaces();
            for(Class l_Class_Interface : l_ClassArray_Interfaces) {
                l_ArrayListClass_Return.add(l_Class_Interface);
            }
            l_Class = l_Class.getSuperclass();
        }
        return l_ArrayListClass_Return;
    }
    static public boolean hasName(
            ArrayList<Class> a_ArrayListClass,
            String a_String){
        boolean l_boolean_Return = false;
        Class[] l_ClassArray = a_ArrayListClass.toArray(new Class[a_ArrayListClass.size()]);
        for(Class l_Class : l_ClassArray){
            if(l_Class.getName().equals(a_String)){
                l_boolean_Return = true;
                break;
            }
        }
        return l_boolean_Return;
    }
    static public ArrayList<Class> hasInterface(ArrayList<URL> a_ArrayListURL, String a_String){
        ArrayList<Class> l_ArrayListClass_Return = new ArrayList<Class>();
        URLClassLoader l_URLClassLoader = createURLClassLoader(a_ArrayListURL);
        if(l_URLClassLoader == null) outputMessage_CouldNotCreateURLClassLoader();
        else{
            ArrayList<String> l_ArrayListString = getJarClassNames(a_ArrayListURL);
            String[] l_StringArray = l_ArrayListString.toArray(new String[l_ArrayListString.size()]);
            for(String l_String : l_StringArray){
                Class l_Class = loadClass(l_URLClassLoader, l_String);
                if(l_Class == null) outputMessage_CouldNotLoadClass(l_String);
                else{
                    if(hasName(getClassInterfaces(l_Class),a_String)) l_ArrayListClass_Return.add(l_Class);
                }
            }
        }
        return l_ArrayListClass_Return;
    }
    static public void outputMessage_CouldNotCreateURLClassLoader(){
        String l_String_Line = String.format("Could not create URLClassLoader for specified URLs.");
        m_PrintStream.println(l_String_Line);
    }
    static private void outputMessage_CouldNotLoadClass(String a_String){
        String l_String_Line = String.format("Could not load class: %1$s",a_String);
        m_PrintStream.println(l_String_Line);
    }
    static public void Hex(byte[] a_byteArray, PrintStream a_PrintStream) {
        a_PrintStream.println("Dump::Hex");
        int l_int_Count = 0;
        int l_int_NumBytesOnLine=m_int_MaxBytesOnLine;
        int l_int_BytePosition = 0;
        int l_int_BytesRemaining = a_byteArray.length - l_int_BytePosition;
        StringBuffer l_StringBuffer_DumpLine;
        String l_String_Line;
        byte[] l_byteArray_Line;
        while(l_int_BytesRemaining>0){
            l_StringBuffer_DumpLine = new StringBuffer();
            if(l_int_BytesRemaining<m_int_MaxBytesOnLine){
                l_int_NumBytesOnLine = l_int_BytesRemaining;
            }
            l_byteArray_Line = new  byte[l_int_NumBytesOnLine];
            l_StringBuffer_DumpLine.append(
                    String.format("%1$08x  ",l_int_BytePosition));
            for(int l_int=0;l_int<l_int_NumBytesOnLine;l_int++){
                l_byteArray_Line[l_int] = a_byteArray[l_int_BytePosition+l_int];
            }
            for(int l_int=0;l_int<l_byteArray_Line.length;l_int++){
                l_StringBuffer_DumpLine.append(
                        String.format("%1$02x ",
                        (int)l_byteArray_Line[l_int] & 0x000000ff));
            }
            for(int l_int=0;l_int<l_byteArray_Line.length;l_int++){
                if(l_byteArray_Line[l_int]<0x20 ||
                        l_byteArray_Line[l_int]>0x80) {
                    l_byteArray_Line[l_int] = 0x2e;
                }
            }
            for(int l_int=0;
            l_int<(m_int_MaxBytesOnLine - l_byteArray_Line.length);
            l_int++){
                l_StringBuffer_DumpLine.append("   ");
            }
            l_StringBuffer_DumpLine.append("  ");
            l_String_Line = new String(l_byteArray_Line);
            l_StringBuffer_DumpLine.append(l_String_Line);
            a_PrintStream.println(l_StringBuffer_DumpLine.toString());
            l_int_BytePosition+=l_int_NumBytesOnLine;
            l_int_BytesRemaining = a_byteArray.length - l_int_BytePosition;
        }
    }
    static public String MACAddress(byte[] a_byteArray){
        String l_String_Return = "";
        StringBuffer l_StringBuffer = new StringBuffer();
        for(byte l_byte : a_byteArray){
            l_StringBuffer.append(
                    String.format("%1$02x:",(int)l_byte & 0x000000ff));
        }
        if(l_StringBuffer.length()>0) {
            l_String_Return =
                    l_StringBuffer.substring(0,l_StringBuffer.length()-1);
        }
        return l_String_Return;
    }
    static public String IPAddress(byte[] a_byteArray){
        String l_String_Return = "";
        StringBuffer l_StringBuffer = new StringBuffer();
        for(byte l_byte : a_byteArray){
            l_StringBuffer.append(
                    String.format("%1$d.",(int)l_byte & 0x000000ff));
        }
        if(l_StringBuffer.length()>0) {
            l_String_Return =
                    l_StringBuffer.substring(0,l_StringBuffer.length()-1);
        }
        return l_String_Return;
    }
    static public String Bytes(byte[] a_byteArray){
        String l_String_Return = "";
        StringBuffer l_StringBuffer = new StringBuffer();
        for(byte l_byte : a_byteArray){
            l_StringBuffer.append(
                    String.format("0x%1$02x ",(int)l_byte & 0x000000ff));
        }
        if(l_StringBuffer.length()>0) {
            l_String_Return =
                    l_StringBuffer.substring(0,l_StringBuffer.length()-1);
        }
        return l_String_Return;
    }
    static public String HexString(byte[] a_byteArray){
        String l_String_Return = "";
        StringBuffer l_StringBuffer = new StringBuffer();
        for(byte l_byte : a_byteArray){
            l_StringBuffer.append(
                    String.format("%1$02x",(int)l_byte & 0x000000ff));
        }
        if(l_StringBuffer.length()>0) {
            l_String_Return =
                    l_StringBuffer.substring(0,l_StringBuffer.length());
        }
        return l_String_Return;
    }
    static public String BinString(byte[] a_byteArray){
        String l_String_Return = "";
        StringBuffer l_StringBuffer = new StringBuffer();
        for(byte l_byte : a_byteArray){
            int l_int_Mask = 0x00000080;
            for(int l_int = 0;l_int < 8;l_int++){
                int l_int_Bit = (int)l_byte & l_int_Mask;
                String l_String_Bit = "1";
                if(l_int_Bit == 0) l_String_Bit = "0";
                l_StringBuffer.append(
                        String.format("%1$s",l_String_Bit));
                l_int_Mask >>>= 1;
            }
        }
        if(l_StringBuffer.length()>0) {
            l_String_Return =
                    l_StringBuffer.substring(0,l_StringBuffer.length());
        }
        return l_String_Return;
    }
    static public Long GetLong(byte[] a_byteArray){
        Long l_Long_Return = null;
        long l_long_Return = 0;
        boolean l_boolean_Continue = true;
        boolean l_boolean_Positive = true;
        int l_int_FirstByteIndex = 0;
        int l_int_RemainingLength = 0;
        byte l_byte_Compare = 0;
        if(a_byteArray == null) l_boolean_Continue=false;
        if(l_boolean_Continue){
            if(a_byteArray[l_int_FirstByteIndex]<0) l_boolean_Positive = false;
            if(!l_boolean_Positive) l_byte_Compare = (byte)-1;
            for(byte l_byte : a_byteArray){
                if(l_byte != l_byte_Compare) break;
                l_int_FirstByteIndex++;
            }
            l_int_RemainingLength = a_byteArray.length - l_int_FirstByteIndex;
            if(l_int_RemainingLength > 8) l_boolean_Continue = false;
        }
        if (l_boolean_Continue){
            if(l_int_RemainingLength == 8){
                if((a_byteArray[l_int_FirstByteIndex]<0) && l_boolean_Positive) l_boolean_Continue = false;
                else if((a_byteArray[l_int_FirstByteIndex]>=0) && !l_boolean_Positive) l_boolean_Continue = false;
            }
        }
        if (l_boolean_Continue){
            if(!l_boolean_Positive) l_long_Return=-1;
            for(int l_int_Index = l_int_FirstByteIndex; l_int_Index < a_byteArray.length; l_int_Index++){
                l_long_Return <<= 8;
                l_long_Return += ((long)a_byteArray[l_int_Index]) & 0x00000000000000ffL;
            }
            l_Long_Return = new Long(l_long_Return);
        }
        
        return l_Long_Return;
    }
    static public Integer GetInteger(byte[] a_byteArray){
        Integer l_Integer_Return = null;
        int l_int_Return = 0;
        boolean l_boolean_Continue = true;
        boolean l_boolean_Positive = true;
        int l_int_FirstByteIndex = 0;
        int l_int_RemainingLength = 0;
        byte l_byte_Compare = 0;
        if(a_byteArray == null) l_boolean_Continue=false;
        if(l_boolean_Continue){
            if(a_byteArray[l_int_FirstByteIndex]<0) l_boolean_Positive = false;
            if(!l_boolean_Positive) l_byte_Compare = (byte)-1;
            for(byte l_byte : a_byteArray){
                if(l_byte != l_byte_Compare) break;
                l_int_FirstByteIndex++;
            }
            l_int_RemainingLength = a_byteArray.length - l_int_FirstByteIndex;
            if(l_int_RemainingLength > 4) l_boolean_Continue = false;
        }
        if (l_boolean_Continue){
            if(l_int_RemainingLength == 4){
                if((a_byteArray[l_int_FirstByteIndex]<0) && l_boolean_Positive) l_boolean_Continue = false;
                else if((a_byteArray[l_int_FirstByteIndex]>=0) && !l_boolean_Positive) l_boolean_Continue = false;
            }
        }
        if (l_boolean_Continue){
            if(!l_boolean_Positive) l_int_Return=-1;
            for(int l_int_Index = l_int_FirstByteIndex; l_int_Index < a_byteArray.length; l_int_Index++){
                l_int_Return <<= 8;
                l_int_Return += ((int)a_byteArray[l_int_Index]) & 0x000000ff;
            }
            l_Integer_Return = new Integer(l_int_Return);
        }
        
        return l_Integer_Return;
    }
    static public Integer GetInteger(ByteBuffer a_ByteBuffer){
        Integer l_Integer_Return = null;
        int l_int_Return = 0;
        boolean l_boolean_Continue = true;
        boolean l_boolean_Positive = true;
        int l_int_FirstByteIndex = 0;
        int l_int_RemainingLength = 0;
        if(a_ByteBuffer == null) l_boolean_Continue=false;
        if(l_boolean_Continue){
            if(a_ByteBuffer.get(l_int_FirstByteIndex)<0) l_boolean_Positive = false;
            if(l_boolean_Positive){
                while01: while(true){
                    if(l_int_FirstByteIndex>=a_ByteBuffer.capacity()) break while01;
                    if(a_ByteBuffer.get(l_int_FirstByteIndex) != 0) break while01;
                    l_int_FirstByteIndex++;
                }
            } else {
                while02: while(true){
                    if(l_int_FirstByteIndex>=a_ByteBuffer.capacity()) break while02;
                    if(a_ByteBuffer.get(l_int_FirstByteIndex) != -1) break while02;
                    l_int_FirstByteIndex++;
                }
            }
            l_int_RemainingLength = a_ByteBuffer.capacity() - l_int_FirstByteIndex;
            if(l_int_RemainingLength > 4) l_boolean_Continue = false;
        }
        if (l_boolean_Continue){
            if(l_int_RemainingLength == 4){
                if ((a_ByteBuffer.get(l_int_FirstByteIndex)<0) && l_boolean_Positive) l_boolean_Continue = false;
                else if ((a_ByteBuffer.get(l_int_FirstByteIndex)>=0) && !l_boolean_Positive) l_boolean_Continue = false;
            }
        }
        if (l_boolean_Continue){
            if(l_boolean_Positive) l_int_Return=0;
            else l_int_Return=-1;
            for(int l_int_Index = l_int_FirstByteIndex; l_int_Index < a_ByteBuffer.capacity(); l_int_Index++){
                l_int_Return <<= 8;
                l_int_Return += ((int)a_ByteBuffer.get(l_int_Index)) & 0x000000ff;
            }
            l_Integer_Return = new Integer(l_int_Return);
        }
        return l_Integer_Return;
    }
    static public byte[] toByteArray(int a_int_Size, String a_String_Format, String a_String_Data){
        byte[] l_byteArray_Return = null;
        try{
            l_byteArray_Return = new byte[a_int_Size];
            if(a_String_Format.equals("decimal")){
                BigInteger l_BigInteger = new BigInteger(a_String_Data);
                if(l_BigInteger.compareTo(BigInteger.ZERO)<0) 
                	for(int i = 0; i<l_byteArray_Return.length; i++) l_byteArray_Return[i] = (byte)0xff;
                else for(int i = 0; i<l_byteArray_Return.length; i++) l_byteArray_Return[i] = (byte)0x00;
                byte[] l_byteArray_Data = l_BigInteger.toByteArray();
                for(int l_int_Index = 0; l_int_Index < l_byteArray_Return.length; l_int_Index++){
                    if(l_int_Index>=l_byteArray_Data.length) break;
                    l_byteArray_Return[l_byteArray_Return.length-1-l_int_Index] = l_byteArray_Data[l_byteArray_Data.length-1-l_int_Index];
                }
            }
        } catch (Exception l_Exception){
            outputMessage_Exception(l_Exception);
            l_byteArray_Return = null;
        }
        return l_byteArray_Return;
    }
    static public DocumentBuilder getDocumentBuilder(){
        DocumentBuilder l_DocumentBuilder_Return = null;
        DocumentBuilderFactory l_DocumentBuilderFactory = DocumentBuilderFactory.newInstance();
        try{
            l_DocumentBuilder_Return = l_DocumentBuilderFactory.newDocumentBuilder();
        } catch (Exception l_Exception){
            outputMessage_Exception(l_Exception);
        }
        return l_DocumentBuilder_Return;
    }
    static public FileInputStream getFileInputStream(String a_String){
        FileInputStream l_FileInputStream_Return = null;
        try{
            l_FileInputStream_Return = new FileInputStream(a_String);
        } catch (Exception l_Exception){
            outputMessage_Exception(l_Exception);
        }
        return l_FileInputStream_Return;
    }
    static public Document parse(DocumentBuilder a_DocumentBuilder, FileInputStream a_FileInputStream){
        Document l_Document_Return = null;
        try{
            l_Document_Return = a_DocumentBuilder.parse(a_FileInputStream);
        } catch (Exception l_Exception){
            outputMessage_Exception(l_Exception);
        }
        return l_Document_Return;
    }
    static public Method getMethodDeep(Class a_Class, String a_String){
        Method l_Method_Return = null;
        Class l_Class = a_Class;
        while(true){
            l_Method_Return = getMethod(l_Class, a_String);
            if(l_Method_Return != null) break;
            l_Class = l_Class.getSuperclass();
            if(l_Class == null) break;
        }
        return l_Method_Return;
    }
    static public Method getMethodDeep(Class a_Class, String a_String, Class a_Class_0){
        Method l_Method_Return = null;
        Class l_Class = a_Class;
        while(true){
            l_Method_Return = getMethod(l_Class, a_String, a_Class_0);
            if(l_Method_Return != null) break;
            l_Class = l_Class.getSuperclass();
            if(l_Class == null) break;
        }
        return l_Method_Return;
    }
    static public Method getMethod(Class a_Class, String a_String){
        Method l_Method_Return = null;
        try{
            l_Method_Return = a_Class.getMethod(a_String);
        } catch (Exception l_Exception){
            outputMessage_Exception(l_Exception);
        }
        return l_Method_Return;
    }
    static public Method getMethod(Class a_Class, String a_String, Class a_Class_0){
        Method l_Method_Return = null;
        try{
            l_Method_Return = a_Class.getMethod(a_String, a_Class_0);
        } catch (Exception l_Exception){
            outputMessage_Exception(l_Exception);
        }
        return l_Method_Return;
    }
    static public Object InvokeMethod(Method a_Method, Object a_Object){
        Object l_Object_Return = null;
        try{
            l_Object_Return = a_Method.invoke(a_Object);
        } catch (Exception l_Exception){
            outputMessage_Exception(l_Exception);
        }
        return l_Object_Return;
    }
    static public Object InvokeMethod(Method a_Method, Object a_Object, Object a_Object_0){
        Object l_Object_Return = null;
        try{
            l_Object_Return = a_Method.invoke(a_Object, a_Object_0);
        } catch (Exception l_Exception){
            outputMessage_Exception(l_Exception);
        }
        return l_Object_Return;
    }
    static public void outputMessage_NodeNotRecognized(String a_String_Text, String a_String_ClassName, Node a_Node){
        String l_String_Line = String.format("%1$s - Class: %2$s", a_String_Text, a_String_ClassName);
        m_PrintStream.println(l_String_Line);
    }
}
