/*
 * RangeArrayList.java
 *
 * Created on December 5, 2006, 2:04 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.Asn1ILib;
import java.util.*;
import java.math.*;
/**
 *
 * @author rtheimer
 */
public class RangeArrayList extends ArrayList<Range> {
    
    /** Creates a new instance of RangeArrayList */
    public RangeArrayList() {
    }
    public Integer getFixedDataSize(){
        Integer l_Integer_Return = null;
        BigInteger l_BigInteger_LowerBound = getMinValue();
        BigInteger l_BigInteger_UpperBound = getMaxValue();
        if((l_BigInteger_LowerBound != null) && (l_BigInteger_UpperBound != null)){
            if((l_BigInteger_UpperBound.compareTo(new BigInteger("255")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("0")) == 0)) l_Integer_Return = 1;
            else if((l_BigInteger_UpperBound.compareTo(new BigInteger("127")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("-128")) == 0)) l_Integer_Return = 1;
            else if((l_BigInteger_UpperBound.compareTo(new BigInteger("65535")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("0")) == 0)) l_Integer_Return = 2;
            else if((l_BigInteger_UpperBound.compareTo(new BigInteger("32767")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("-32768")) == 0)) l_Integer_Return = 2;
            else if((l_BigInteger_UpperBound.compareTo(new BigInteger("4294967295")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("0")) == 0)) l_Integer_Return = 4;
            else if((l_BigInteger_UpperBound.compareTo(new BigInteger("2147483647")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("-2147483648")) == 0)) l_Integer_Return = 4;
        }
        return l_Integer_Return;
    }
    public BigInteger getMaxValue(){
        BigInteger l_BigInteger_Return = null;
        BigInteger l_BigInteger_UpperBoundNext = null;
        for(int l_int_Index = 0;l_int_Index<this.size();l_int_Index++){
            Range l_Range = this.get(l_int_Index);
            if(l_Range.getUpperBound() != null){
                l_BigInteger_UpperBoundNext = new BigInteger(l_Range.getUpperBound().getData());
                if(!l_Range.getUpperBoundIncluded()){
                    l_BigInteger_UpperBoundNext = l_BigInteger_UpperBoundNext.subtract(new BigInteger("1"));
                }
                if(l_BigInteger_Return == null) l_BigInteger_Return = l_BigInteger_UpperBoundNext;
                else if(l_BigInteger_UpperBoundNext.compareTo(l_BigInteger_Return) == 1)
                    l_BigInteger_Return = l_BigInteger_UpperBoundNext;
            } else{
                l_BigInteger_Return = null;
                break;
            }
        }
        return l_BigInteger_Return;
    }
    public BigInteger getMinValue(){
        BigInteger l_BigInteger_Return = null;
        BigInteger l_BigInteger_LowerBoundNext = null;
        for(int l_int_Index = 0;l_int_Index<this.size();l_int_Index++){
            Range l_Range = this.get(l_int_Index);
            if(l_Range.getLowerBound() != null){
                l_BigInteger_LowerBoundNext = new BigInteger(l_Range.getLowerBound().getData());
                if(!l_Range.getLowerBoundIncluded()){
                    l_BigInteger_LowerBoundNext = l_BigInteger_LowerBoundNext.add(new BigInteger("1"));
                }
                if(l_BigInteger_Return == null) l_BigInteger_Return = l_BigInteger_LowerBoundNext;
                else if(l_BigInteger_LowerBoundNext.compareTo(l_BigInteger_Return) == -1)
                    l_BigInteger_Return = l_BigInteger_LowerBoundNext;
            } else{
                l_BigInteger_Return = null;
                break;
            }
        }
        return l_BigInteger_Return;
    }
}
