/*
 * Range.java
 *
 * Created on November 3, 2006, 3:07 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.Asn1ILib;
import java.io.*;

/**
 *
 * @author rtheimer
 */
public class Range {
    private Asn1Object m_Asn1Object_LowerBound;
    boolean m_boolean_LowerBoundIncluded;
    private Asn1Object m_Asn1Object_UpperBound;
    boolean m_boolean_UpperBoundIncluded;
    /** Creates a new instance of Range */
    public Range() {
        m_Asn1Object_LowerBound = null;
        m_boolean_LowerBoundIncluded = false;
        m_Asn1Object_UpperBound = null;
        m_boolean_UpperBoundIncluded = false;
    }
    public Range(Asn1Object a_Asn1Object_LowerBound, boolean a_boolean_LowerBoundIncluded,
            Asn1Object a_Asn1Object_UpperBound, boolean a_boolean_UpperBoundIncluded){
        this();
        m_boolean_LowerBoundIncluded = a_boolean_LowerBoundIncluded;
        m_boolean_UpperBoundIncluded = a_boolean_UpperBoundIncluded;
        if(a_Asn1Object_LowerBound != null){
            m_Asn1Object_LowerBound = a_Asn1Object_LowerBound;
        }
        if(a_Asn1Object_UpperBound != null){
            m_Asn1Object_UpperBound = a_Asn1Object_UpperBound;
        }
    }
    public Asn1Object getLowerBound(){
        return m_Asn1Object_LowerBound;
    }
    public boolean getLowerBoundIncluded(){
        return m_boolean_LowerBoundIncluded;
    }
    public Asn1Object getUpperBound(){
        return m_Asn1Object_UpperBound;
    }
    public boolean getUpperBoundIncluded(){
        return m_boolean_UpperBoundIncluded;
    }
    public void printXML(PrintStream a_PrintStream){
        String l_String_Line = String.format("<LowerBound Included=\"%1$s\">",Boolean.toString(m_boolean_LowerBoundIncluded));
        a_PrintStream.println(l_String_Line);
        if(m_Asn1Object_LowerBound != null) m_Asn1Object_LowerBound.printXML(a_PrintStream);
        a_PrintStream.println("</LowerBound>");
        l_String_Line = String.format("<UpperBound Included=\"%1$s\">",Boolean.toString(m_boolean_UpperBoundIncluded));
        a_PrintStream.println(l_String_Line);
        if(m_Asn1Object_UpperBound != null) m_Asn1Object_UpperBound.printXML(a_PrintStream);
        a_PrintStream.println("</UpperBound>");
    }
}
