/*
 * OCTETSTRING.java
 *
 * Created on November 27, 2006, 4:16 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.Asn1Lib;
import gov.nist.div897.Asn1ILib.*;
import gov.nist.div897.Services.*;
import java.io.*;
import java.math.BigInteger;

import org.w3c.dom.Node;
/**
 *
 * @author rtheimer
 */
public class OCTETSTRING extends Asn1Object {
    static final private String m_String_NameAsn1Type ="OCTET STRING";
    static final private Tag m_Tag = new Tag(TagClass.UNDEFINED,new byte[]{0x04});
    private SizeRangeArrayList m_SizeRangeArrayList;
    private Identifiers m_Identifiers;
    
    static public String getNameASN1Type(){
        return m_String_NameAsn1Type;
    }
    static public Tag getTag(){
        return m_Tag;
    }
    static public Boolean IsOCTETSTRING(){
        return true;
    }
    /** Creates a new instance of OCTETSTRING */
    public OCTETSTRING() {
        super();
        m_SizeRangeArrayList = null;
        m_Identifiers = null;
    }
    public OCTETSTRING(String a_String){
        this();
        setNameInstance(a_String);
    }
    public OCTETSTRING(String a_String_NameInstance, String a_String_Data){
        this();
        setNameInstance(a_String_NameInstance);
        setData(a_String_Data);
    }
    public OCTETSTRING(String a_String, byte[] a_byteArray){
        this();
        setNameInstance(a_String);
        setData(a_byteArray);
    }
    public OCTETSTRING(byte[] a_byteArray){
        this();
        setData(a_byteArray);
    }
    public void printXML(PrintStream a_PrintStream){
        printXMLOpen(a_PrintStream);
        if(m_byteArray_Data != null){
            String l_String_Line = Services.HexString(m_byteArray_Data);
            //may need to add code to split the line into several shorter lines.
            a_PrintStream.println(l_String_Line);
        }
        printXMLClose(a_PrintStream);
    }
    public void printXML(PrintStream a_PrintStream, Attributes a_Attributes){
        printXMLOpen(a_PrintStream, a_Attributes);
        if(m_byteArray_Data != null){
            String l_String_Line = Services.HexString(m_byteArray_Data);
            //may need to add code to split the line into several shorter lines.
            a_PrintStream.println(l_String_Line);
        }
        printXMLClose(a_PrintStream);
    }
    
    @Override
    public void setData(String a_String) {
    	setData(a_String.getBytes());
    }
    
}
