/*
 * INTEGER.java
 *
 * Created on October 24, 2006, 11:44 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.Asn1Lib;
import gov.nist.div897.Asn1ILib.*;
import gov.nist.div897.Services.*;
//import gov.nist.div897.NameValuePairLib.*;
import java.io.*;
import java.math.*;
import java.lang.reflect.*;
import java.util.*;

import org.w3c.dom.Node;

/**
 *
 * @author rtheimer
 */
public class INTEGER extends Asn1Object {
    static final private String m_String_NameAsn1Type = "INTEGER";
    static final private Tag m_Tag = new Tag(TagClass.UNIVERSAL,new byte[]{0x02});
    private RangeArrayList m_RangeArrayList;
    protected Identifiers m_Identifiers;
    /** Creates a new instance of INTEGER */
    static public Boolean IsINTEGER(){
        return true;
    }
//    static public Boolean IsCHOICE(){
//        return Asn1ModuleServer.IsCHOICE(Asn1Object.class);
//    }
//    static public Boolean IsSEQUENCE(){
//        return Asn1ModuleServer.IsSEQUENCE(Asn1Object.class);
//    }
//    static public Boolean IsSEQUENCEOF(){
//        return Asn1ModuleServer.IsSEQUENCEOF(Asn1Object.class);
//    }
//    static public Boolean IsANYDEFINEDBY(){
//        return Asn1ModuleServer.IsANYDEFINEDBY(Asn1Object.class);
//    }
//    static public Boolean IsOCTETSTRING(){
//        return Asn1ModuleServer.IsOCTETSTRING(Asn1Object.class);
//    }
//    static public Boolean IsBITSTRING(){
//        return Asn1ModuleServer.IsBITSTRING(Asn1Object.class);
//    }
    static public String getNameASN1Type(){
        return m_String_NameAsn1Type;
    }
    static public Tag getTag(){
        return m_Tag;
    }
    public INTEGER() {
        super();
        m_RangeArrayList = null;
        m_Identifiers = null;
    }
    public INTEGER(String a_String){
        this();
        setNameInstance(a_String);
    }
    public INTEGER(String a_String_NameInstance, String a_String_Data){
        this();
        setNameInstance(a_String_NameInstance);
        setData(a_String_Data);
    }
    public INTEGER(String a_String, byte[] a_byteArray){
        this();
        setNameInstance(a_String);
        setData(a_byteArray);
    }
    public INTEGER(byte[] a_byteArray){
        this();
        setData(a_byteArray);
    }
    public RangeArrayList getRangeArrayList(){
        return m_RangeArrayList;
    }
    public boolean setRangeArrayList(RangeArrayList a_RangeArrayList){
        m_RangeArrayList = a_RangeArrayList;
        return true;
    }
    public boolean setIdentifiers(Identifiers a_Identifiers){
        m_Identifiers = a_Identifiers;
        return true;
    }
    public Identifiers getIdentifiers(){
        return m_Identifiers;
    }
    public Integer getFixedDataSize(){
        Integer l_Integer_Return = null;
        if(m_RangeArrayList != null) l_Integer_Return = m_RangeArrayList.getFixedDataSize();
        return l_Integer_Return;
    }
//    public Integer getDataInteger(){
//        return Dump.GetInteger(m_byteArray_Data);
//    }
//    public Long getDataLong(){
//        return Dump.GetLong(m_byteArray_Data);
//    }
    public void printXML(PrintStream a_PrintStream){
        printXMLOpen(a_PrintStream);
        if(m_byteArray_Data != null) a_PrintStream.println(getDataAsBigInteger().toString());
        printXMLClose(a_PrintStream);
    }
    public void printXML(PrintStream a_PrintStream, Attributes a_Attributes){
        printXMLOpen(a_PrintStream, a_Attributes);
        if(m_byteArray_Data != null) a_PrintStream.println(getDataAsBigInteger().toString());
        printXMLClose(a_PrintStream);
    }
//    public void SetRange(Long l_Long_LowerBound, Long l_Long_UpperBound){
//        l_IntegerRange = new IntegerRange(l_Long_LowerBound,l_Long_UpperBound);
//    }
//    public Long getIntegerRangeLowerBound(){
//        return l_IntegerRange.GetLowerBoundLong();
//    }
//    public Long getIntegerRangeUpperBound(){
//        return l_IntegerRange.GetUpperBoundLong();
//    }
    public String getIdentifierValue(String a_String){
        String l_String_Return = "";
        Identifiers l_Identifiers = getIdentifiers();
        if(l_Identifiers != null){
            Class l_Class_Super = getClass().getSuperclass();
            if(l_Class_Super != null){
                Asn1Object l_Asn1Object = Asn1ModuleServer.instantiateAsn1Object(Asn1ModuleServer.getNameASN1Type(l_Class_Super));
                if(l_Asn1Object != null){
                    if(getFixedDataSize() != null) l_Asn1Object.setData(getFixedDataSize(),a_String);
                    else l_Asn1Object.setData(a_String);
                    if(l_Identifiers.containsKey(l_Asn1Object)) l_String_Return = l_Identifiers.get(l_Asn1Object);
                }
            }
        }
        return l_String_Return;
    }
    public Asn1Object[] getIdentifierKeys(String a_String){
        ArrayList<Asn1Object> l_ArrayListAsn1Object_Return = new ArrayList<Asn1Object>();
        //Asn1Object[] l_Asn1ObjectArray_Return = new Asn1Object[0];
        Identifiers l_Identifiers = getIdentifiers();
        if(l_Identifiers != null){
            Class l_Class_Super = getClass().getSuperclass();
            if(l_Class_Super != null){
                Asn1Object l_Asn1Object = Asn1ModuleServer.instantiateAsn1Object(Asn1ModuleServer.getNameASN1Type(l_Class_Super));
                if(l_Asn1Object != null){
                    Set l_Set = l_Identifiers.entrySet();
                    Object[] l_ObjectArray = l_Set.toArray();
                    for(Object l_Object : l_ObjectArray){
                        Map.Entry l_MapEntry = (Map.Entry)l_Object;
                        String l_String_Value = (String)l_MapEntry.getValue();
                        if(l_String_Value.equals(a_String)){
                            l_ArrayListAsn1Object_Return.add((Asn1Object)l_MapEntry.getKey());
                        }
                    }
                }
            }
        }
        return l_ArrayListAsn1Object_Return.toArray(new Asn1Object[l_ArrayListAsn1Object_Return.size()]);
    }
    
}
