/*
 * BITSTRING.java
 *
 * Created on November 27, 2006, 5:03 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.Asn1Lib;
import gov.nist.div897.Asn1ILib.*;
import java.util.*;
import java.io.*;
import gov.nist.div897.Services.*;

import org.w3c.dom.Node;

/**
 *
 * @author rtheimer
 */
public class BITSTRING extends Asn1Object {
    static final private String m_String_NameAsn1Type ="BIT STRING";
    static final private Tag m_Tag = new Tag(TagClass.UNDEFINED,new byte[]{0x03});
    private SizeRangeArrayList m_SizeRangeArrayList;
    private Identifiers m_Identifiers;
    
    /** Creates a new instance of BITSTRING */
    static public String getNameASN1Type(){
        return m_String_NameAsn1Type;
    }
    static public Tag getTag(){
        return m_Tag;
    }
    static public Boolean IsBITSTRING(){
        return true;
    }
    public BITSTRING() {
        super();
        m_SizeRangeArrayList = null;
        m_Identifiers = null;
    }
    public BITSTRING(String a_String){
        this();
        setNameInstance(a_String);
    }
    public BITSTRING(String a_String_NameInstance, String a_String_Data){
        this();
        setNameInstance(a_String_NameInstance);
        setData(a_String_Data);
    }
    public BITSTRING(String a_String, byte[] a_byteArray){
        this();
        setNameInstance(a_String);
        setData(a_byteArray);
    }
    public BITSTRING(byte[] a_byteArray){
        this();
        setData(a_byteArray);
    }
    public SizeRangeArrayList getSizeRangeArrayList(){
        return m_SizeRangeArrayList;
    }
    public boolean setSizeRangeArrayList(SizeRangeArrayList a_SizeRangeArrayList){
        m_SizeRangeArrayList = a_SizeRangeArrayList;
        return true;
    }
    public Integer getFixedDataSize(){
        Integer l_Integer_Return = null;
        if(m_SizeRangeArrayList != null){
            l_Integer_Return = m_SizeRangeArrayList.getFixedDataSize() / 8;
            if((m_SizeRangeArrayList.getFixedDataSize() % 8) > 0) l_Integer_Return++;
        }
        return l_Integer_Return;
    }
    public boolean setIdentifiers(Identifiers a_Identifiers){
        m_Identifiers = a_Identifiers;
        return true;
    }
    public Identifiers getIdentifiers(){
        return m_Identifiers;
    }
    public String getIdentifierValue(String a_String){
        String l_String_Return = "";
        Identifiers l_Identifiers = getIdentifiers();
        if(l_Identifiers != null){
            Class l_Class_Super = INTEGER.class;
            if(l_Class_Super != null){
                Asn1Object l_Asn1Object = Asn1ModuleServer.instantiateAsn1Object(Asn1ModuleServer.getNameASN1Type(l_Class_Super));
                if(l_Asn1Object != null){
                    if(getFixedDataSize() != null) l_Asn1Object.setData(getFixedDataSize(),a_String);
                    else l_Asn1Object.setData(a_String);
                    if(l_Identifiers.containsKey(l_Asn1Object)) l_String_Return = l_Identifiers.get(l_Asn1Object);
                }
            }
        }
        return l_String_Return;
    }
    public Asn1Object[] getIdentifierKeys(String a_String){
        ArrayList<Asn1Object> l_ArrayListAsn1Object_Return = new ArrayList<Asn1Object>();
        //Asn1Object[] l_Asn1ObjectArray_Return = new Asn1Object[0];
        Identifiers l_Identifiers = getIdentifiers();
        if(l_Identifiers != null){
            Class l_Class_Super = INTEGER.class;
            if(l_Class_Super != null){
                Asn1Object l_Asn1Object = Asn1ModuleServer.instantiateAsn1Object(Asn1ModuleServer.getNameASN1Type(l_Class_Super));
                if(l_Asn1Object != null){
                    Set l_Set = l_Identifiers.entrySet();
                    Object[] l_ObjectArray = l_Set.toArray();
                    for(Object l_Object : l_ObjectArray){
                        Map.Entry l_MapEntry = (Map.Entry)l_Object;
                        String l_String_Value = (String)l_MapEntry.getValue();
                        if(l_String_Value.equals(a_String)){
                            l_ArrayListAsn1Object_Return.add((Asn1Object)l_MapEntry.getKey());
                        }
                    }
                }
            }
        }
        return l_ArrayListAsn1Object_Return.toArray(new Asn1Object[l_ArrayListAsn1Object_Return.size()]);
    }

    public void printXML(PrintStream a_PrintStream){
        printXMLOpen(a_PrintStream);
        if(m_byteArray_Data != null){
            String l_String_Line = Services.BinString(m_byteArray_Data);
            //may need to add code to split the line into several shorter lines.
            a_PrintStream.println(l_String_Line);
        }
        printXMLClose(a_PrintStream);
    }
    public void printXML(PrintStream a_PrintStream, Attributes a_Attributes){
        printXMLOpen(a_PrintStream, a_Attributes);
        if(m_byteArray_Data != null){
            String l_String_Line = Services.BinString(m_byteArray_Data);
            //may need to add code to split the line into several shorter lines.
            a_PrintStream.println(l_String_Line);
        }
        printXMLClose(a_PrintStream);
    }

}
