package gov.nist.div897.DimLib;

import gov.nist.div897.Asn1ILib.Identifier;
import gov.nist.div897.Asn1ILib.Identifiers;
import gov.nist.div897.MderLib.INTU16;

public class PatientType extends INTU16 {
	static final private String m_String_NameAsn1Type="PatientType";
	static final private Identifier[] m_IdentifierArray = {
		new Identifier(new INTU16("","0"),"pt-unspecified"),
		new Identifier(new INTU16("","1"),"adult"),
		new Identifier(new INTU16("","2"),"pediatric"),
		new Identifier(new INTU16("","3"),"neonatal"),
	};
	public PatientType(){
		super();
		setIdentifiers(new Identifiers(m_IdentifierArray));
	}
	public PatientType(String a_name){
		this();
		setNameInstance(a_name);
	}
	public PatientType(String a_name, String a_String_Data){
		 this();
		 setNameInstance(a_name);
		setData(a_String_Data);;	}
	public PatientType(String a_name, byte[] a_byteArray){
		 this();
		setNameInstance(a_name);
		setData(a_byteArray);	}
	public PatientType(byte[] a_byteArray){
		 this();
		setData(a_byteArray);	}
	static public String getNameASN1Type(){
		return m_String_NameAsn1Type;
	}

}
