package gov.nist.div897.DimLib;

import gov.nist.div897.Asn1ILib.Identifier;
import gov.nist.div897.Asn1ILib.Identifiers;
import gov.nist.div897.MderLib.INTU16;

public class MetricCategory extends INTU16 {
	static final private String m_String_NameAsn1Type="MetricCategory";
	static final private Identifier[] m_IdentifierArray = {
		new Identifier(new INTU16("","0"),"mcat-unspec"),
		new Identifier(new INTU16("","1"),"auto-measurement"),
		new Identifier(new INTU16("","2"),"manual-measurement"),
		new Identifier(new INTU16("","3"),"auto-setting"),
		new Identifier(new INTU16("","4"),"manual-setting"),
		new Identifier(new INTU16("","5"),"auto-calculation"),
		new Identifier(new INTU16("","6"),"manual-calculation"),
	};
	public MetricCategory(){
		super();
		setIdentifiers(new Identifiers(m_IdentifierArray));
	}
	public MetricCategory(String a_name){
		this();
		setNameInstance(a_name);
	}
	public MetricCategory(String a_name, String a_String_Data){
		 this();
		 setNameInstance(a_name);
		setData(a_String_Data);;	}
	public MetricCategory(String a_name, byte[] a_byteArray){
		 this();
		setNameInstance(a_name);
		setData(a_byteArray);	}
	public MetricCategory(byte[] a_byteArray){
		 this();
		setData(a_byteArray);	}
	static public String getNameASN1Type(){
		return m_String_NameAsn1Type;
	}

}
