package gov.nist.div897.DimLib;

import gov.nist.div897.Asn1ILib.Identifier;
import gov.nist.div897.Asn1ILib.Identifiers;
import gov.nist.div897.MderLib.BITS16;
import gov.nist.div897.Asn1Lib.INTEGER;

public class AlertState extends BITS16 {
	static final private String m_String_NameAsn1Type="AlertState";
	static final private Identifier[] m_IdentifierArray = {
		new Identifier(new INTEGER("","1"),"dyn-inst-contents"),
		new Identifier(new INTEGER("","2"),"rep-all-inst"),
		new Identifier(new INTEGER("","0"),"al-inhibited"),
		new Identifier(new INTEGER("","1"),"al-suspended"),
		new Identifier(new INTEGER("","2"),"al-latched"),
		new Identifier(new INTEGER("","3"),"al-silenced-reset"),
		new Identifier(new INTEGER("","5"),"al-dev-in-test-mode"),
		new Identifier(new INTEGER("","6"),"al-dev-in-standby-mode"),
		new Identifier(new INTEGER("","7"),"al-dev-in-demo-mode"),
	};
	public AlertState(){
		super();
		setIdentifiers(new Identifiers(m_IdentifierArray));	
}
	public AlertState(String a_name){
		 this();
		 setNameInstance(a_name);
	}
	public AlertState(String a_name, String a_String_Data){
		 this();
		 setNameInstance(a_name);
		setData(a_String_Data);;	}
	public AlertState(String a_name, byte[] a_byteArray){
		 this();
		setNameInstance(a_name);
		setData(a_byteArray);	}
	public AlertState(byte[] a_byteArray){
		 this();
		setData(a_byteArray);	}
	static public String getNameASN1Type(){
		return m_String_NameAsn1Type;
	}

}
