package dataTypeInterface;

import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1Lib.CHOICE;
import gov.nist.div897.Asn1Lib.INTEGER;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import addingsToAsnLib.ValidateAsnObject;

public class ComponentAsnChoice implements IComponentAsn, ActionListener{
	
	CollapsablePanel colPanel;
	JPanel panel;
	JPanel choicePan;
	CHOICE choice;
	Vector<IComponentAsn> vectChoiceComp;
	Vector<JRadioButton> vectRadioBtn;
	int indexSelected = -1;
	Asn1Object asnObjSaved = null;
	
	public ComponentAsnChoice(CHOICE asnObj){
		choice = asnObj;
		vectChoiceComp = new Vector<IComponentAsn>();
		vectRadioBtn = new Vector<JRadioButton>();
		asnObjSaved = choice.getChosenASN1Object();
		initComponent();		
	}

	private void initComponent(){
		String toolTipText = Asn1ModuleServer.getNameASN1Type(choice.getClass());
		panel = new JPanel();
		colPanel = new CollapsablePanel();
		colPanel.setCollapsablePan(panel);
		panel.setLayout(new BorderLayout());
		//panel.setBorder(BorderFactory.createTitledBorder(choice.getNameInstance()));
		
		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.LINE_AXIS));		
				
		JLabel label = new JLabel(choice.getNameInstance());
		label.setPreferredSize(new Dimension(90,0));
		label.setToolTipText(toolTipText);
		p.add(label);
		
		choicePan = new JPanel();
		choicePan.setLayout(new BoxLayout(choicePan, BoxLayout.PAGE_AXIS));
		choicePan.add(Box.createRigidArea(new Dimension(0,10)));
		
		colPanel.setHeaderPan(p);
		
		JPanel p2 = new JPanel();
		p2.setLayout(new BoxLayout(p2, BoxLayout.PAGE_AXIS));
		ButtonGroup btnGroup = new ButtonGroup();
		
		gov.nist.div897.Asn1ILib.Choices choices = choice.getChoices();
		INTEGER element = null;
		for (Iterator iter = choices.keySet().iterator(); iter.hasNext();) {
			element = (INTEGER) iter.next();
			String val = choices.get(element);
			String name = element.getNameInstance();
			p = new JPanel();
			//p.add(Box.createRigidArea(new Dimension(20,0)));
			p.setLayout(new BorderLayout());
			p.setBorder(BorderFactory.createEmptyBorder(0,20,0,20));
			
			JRadioButton radioBtn = new JRadioButton(name);
			radioBtn.addActionListener(this);
			radioBtn.setSelected(false);
			
			radioBtn.setToolTipText(val);
			p.add(radioBtn, BorderLayout.WEST);
			p.add(Box.createRigidArea(new Dimension(10,0)));
			vectRadioBtn.add(radioBtn);
			btnGroup.add(radioBtn);
			p2.add(p);
			Asn1Object asnObj = choice.getChoiceObject(element.getData());
			
			asnObj.setNameInstance(element.getNameInstance());
			vectChoiceComp.add(ComponentAsnServer.instantiateAsnComponent(this, asnObj));
		
		}
		JPanel p4 = new JPanel();
		p4.setLayout(new BorderLayout());
		p4.add(p2, BorderLayout.PAGE_START);
		panel.add(p4, BorderLayout.WEST);
		JPanel p3 = new JPanel();
		p3.setLayout(new BorderLayout());
		p3.add(choicePan, BorderLayout.PAGE_START);
		panel.add(p3, BorderLayout.CENTER);
		
	}
	public boolean saveData() {
		boolean ret = true;
		String error = "";
		if(indexSelected != -1){
			IComponentAsn comp = vectChoiceComp.get(indexSelected); 
			if(!comp.saveData()){
				ret = false;
				error = error.concat(ValidateAsnObject.getErrorMessage());
			}
			else{
				choice.MakeChoice(getIdentifierKey(Asn1ModuleServer.getNameASN1Type(comp.getAsn1Object().getClass())).getData());
				Asn1ModuleServer.copyAsn1Object(choice.getChoice(), comp.getAsn1Object());
			}
		}
		ValidateAsnObject.setErrorMessage(error);
		return ret;
	}

	public void updateDataComp() {
		Asn1Object objAsn = choice.getChosenASN1Object();
		if(objAsn != null){
			for(int i = 0; i < vectChoiceComp.size(); i++){
				if(objAsn.getNameInstance() != null && objAsn.getNameInstance().equals(vectChoiceComp.get(i).getAsn1Object().getNameInstance())){
					vectChoiceComp.get(i).getAsn1Object().setData(objAsn.getData());
					vectChoiceComp.get(i).updateDataComp();
					vectRadioBtn.get(i).setSelected(true);
					choicePan.removeAll();
					choicePan.add(vectChoiceComp.get(i).getComponent());
					choicePan.validate();
					panel.validate();
					indexSelected = i;
				}
			}
		}		
	}

	public Component getComponent() {
		return colPanel;
	}
	
	private String getIdentifierValue(String key){
		String value = "";
		gov.nist.div897.Asn1ILib.Choices choices = choice.getChoices();
		
		for (Iterator iter = choices.keySet().iterator(); iter.hasNext();) {
			INTEGER element = (INTEGER) iter.next();
			if(element.getDataAsBigInteger().equals(new BigInteger(key)))
				value = choices.get(element);
		}
			
		return value;
	}
	
	private INTEGER getIdentifierKey(String val){
		byte[] key = null;
		gov.nist.div897.Asn1ILib.Choices choices = choice.getChoices();
		boolean end = false;
		INTEGER element = null;
		for (Iterator iter = choices.keySet().iterator(); iter.hasNext() && !end;) {
			element = (INTEGER) iter.next();
			if(choices.get(element).equals(val)){
				key = element.getData();
				end = true;
			}
		}
		return element;
	}

	public void actionPerformed(ActionEvent arg0) {
		for(int i = 0; i < vectRadioBtn.size(); i++){
			JRadioButton radioBtn = (JRadioButton) vectRadioBtn.get(i);
			if(arg0.getSource() == radioBtn && radioBtn.isSelected()){
				choicePan.removeAll();
				choicePan.add(vectChoiceComp.get(i).getComponent());
				//panel.validate();
				choicePan.updateUI();
				indexSelected = i;
			}
		}
		
	}
	
	public Asn1Object getAsn1Object() {
		return choice;
	}

}
