package pdfReport;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Vector;

import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;


/**
 * This class creates a PDFTable from an HTML table in order to export it as PDF document
 * @author MC
 *
 */
public class TableModelFromHtmlTable{
	private static final long serialVersionUID = 1L;
	public File fileHtml;
	public DefaultTableModel model;
	private Vector<Vector> data = null;
	private Vector<String> colomnNames = null;
	
	public TableModelFromHtmlTable(File strFileHtml){
		fileHtml = strFileHtml;
		parseHtmlFile();
		if(data != null && colomnNames != null)
			model = new DefaultTableModel(data, colomnNames);
		else
			model = null;
	}
	public TableModelFromHtmlTable(String stream){
		parseHtmlStream(stream);
		if(data != null && colomnNames != null)
			model = new DefaultTableModel(data, colomnNames);
		else
			model = null;
	} 
	private void parseHtmlStream(String stream){
		HtmlFileHandler handler =  new HtmlFileHandler();
		SAXParserFactory factory = SAXParserFactory.newInstance();
		
		try {
            
            // Parse the input
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new ByteArrayInputStream(stream.getBytes()), handler );

        } catch (Throwable t) {
            t.printStackTrace();
        }
	}
	private void parseHtmlFile(){
		if(fileHtml != null && fileHtml.exists()){
			
			HtmlFileHandler handler =  new HtmlFileHandler();
			SAXParserFactory factory = SAXParserFactory.newInstance();
			
			try {
	            
	            // Parse the input
	            SAXParser saxParser = factory.newSAXParser();
	            saxParser.parse(fileHtml, handler );

	        } catch (Throwable t) {
	            t.printStackTrace();
	        }
		}
	}
	
	public DefaultTableModel getTableModel(){
		return model;
	}
	
	class HtmlFileHandler extends DefaultHandler{
		private boolean isTh = false;
		private boolean isTd = false;
		private boolean isBr = false;
		private boolean isB = false;
		private boolean isFirstTr = true;
		private Vector<String> row = null;
		@Override
		public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
			super.startElement(uri, localName, qName, attributes);
			if(qName.equalsIgnoreCase("table")){
				data = new Vector<Vector>();
			}
			else if(qName.equalsIgnoreCase("th")){
				if(colomnNames == null)
					colomnNames = new Vector<String>();
				isTh = true;
			}
			else if(qName.equalsIgnoreCase("tr")){

				if(row == null && isFirstTr){
					isFirstTr = false;
				}
				else if(row == null)
					row = new Vector<String>();
			}
			else if(qName.equalsIgnoreCase("td")){
				isTd = true;
				row.add("");
			}
			else if(qName.equalsIgnoreCase("br")){
				isBr = true;
			}
			else if(qName.equalsIgnoreCase("b")){
				isB = true;
			}
		}
		@Override
		public void characters(char[] ch, int start, int length) throws SAXException {
			super.characters(ch, start, length);
			String text = new String(ch, start, length);
			if(isBr || isB){
				if(text == null) text = "";
				String temp = row.lastElement();
				if(temp != "")
					temp += " / ";
				temp += text;
				row.set(row.size() - 1, temp);
				
			}
			else if(isTh){
				colomnNames.add(text);
				
			}
			else if(isTd){
				row.set(row.size() - 1, row.lastElement()+text);
			}		
			
		}
		@Override
		public void endElement(String uri, String localName, String qName) throws SAXException {
			super.endElement(uri, localName, qName);
			if(qName.equalsIgnoreCase("tr")){
				if(row != null){
					data.add(row);
					row = new Vector<String>();
				}
			}
			else if(qName.equalsIgnoreCase("td")){
				isTd = false;
			}
			else if(qName.equalsIgnoreCase("th")){
				isTh = false;
			}
			else if(qName.equalsIgnoreCase("br")){
				isBr = false;
			}
			else if(qName.equalsIgnoreCase("b")){
				isB = false;
			}
		}
	}
}
