package pdfReport;

import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.table.TableModel;
import transport.TreeTableModel;
import com.lowagie.text.Chapter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;


/**
 * This class represents a PDF report
 * @author MC
 *
 */
public class PDFReport {
	public Document doc;
	private static final Font fontTitle = FontFactory.getFont(FontFactory.HELVETICA, 26, Font.BOLD, new Color(0, 0, 255));
	private static final Font fontTitleChapiter = FontFactory.getFont(FontFactory.HELVETICA, 14, Font.BOLD, new Color(0, 0, 255));
	private static final Font fontTitleSection = FontFactory.getFont(FontFactory.HELVETICA, 12, Font.BOLDITALIC, new Color(0, 0, 255));
	private String title = "Implementation Conformance Statements Report";
	private int nbCh;
	private PdfWriter writer;
	private Chapter currentChapiter;
	public void SetTitle(String titleIn){
		title = titleIn; 
	}
	public PDFReport(File file) throws FileNotFoundException, DocumentException{

		// step 1: creation of a document-object
		doc = new com.lowagie.text.Document(PageSize.A4, 50, 50, 50, 50);
		

		// step 2:
		// we create a writer that listens to the document
		// and directs a PDF-stream to a file
		writer = PdfWriter.getInstance(doc,	new FileOutputStream(file));
		writer.setPageEvent(new PageNumbersWatermark());
		// step 3: we open the document
		doc.open();
		
		nbCh = 1;
	}
	
	public void addTitle() throws DocumentException{
		Paragraph paragraph = new Paragraph("\n\n\n"+title+"\n\n\n",fontTitle);
        paragraph.setAlignment(Element.ALIGN_CENTER);
        doc.add(paragraph);
        Date now = new Date();
        paragraph = new Paragraph(DateFormat.getDateInstance().format(now));
        paragraph.setAlignment(Element.ALIGN_CENTER);
        doc.add(paragraph);
	}
	
	public Chapter createChapter(String chpTitle, Paragraph para) throws DocumentException{
		Paragraph paraTitle = new Paragraph(chpTitle, fontTitleChapiter);
		Chapter chapter = new Chapter(paraTitle, nbCh++);
		if(para != null)
			chapter.add(para);
		currentChapiter = chapter;
		return chapter;
	}
	
	public PdfPTable createTableFromHtmlTable(String htmlTable) throws DocumentException{
		TableModel model = (new TableModelFromHtmlTable(htmlTable)).getTableModel();
		return createTableFromTaleModel(model);
	}
	
	public PdfPTable createTableFromTaleModel(TableModel model) throws DocumentException{
		PdfPTable pdfTable = (new PDFTableFromTableModel(model)).pdfTable;
		return pdfTable;
	}
	public PdfPTable getTableFromTreeTableModel(TreeTableModel model) throws DocumentException{
		PdfPTable pdfTable = (new PdfTableFromTreeTableModel(model)).pdfTable;
		return pdfTable;
	}
	public Section addSection(String secTitle, Paragraph para){
		Paragraph paraTitle = new Paragraph(secTitle+"\n", fontTitleSection);
		currentChapiter.add(new Paragraph("\n"));
		Section section = currentChapiter.addSection(paraTitle);
		if(para != null)
			section.add(para);
		return section; 
	}
	public void addImage(Image awtIm) throws IOException, DocumentException{
		PdfContentByte cb = writer.getDirectContent();
		com.lowagie.text.Image image = com.lowagie.text.Image.getInstance(awtIm, null);
		image.setAbsolutePosition(60, 300);
		image.scaleToFit(500,500);
		cb.addImage(image);
	}
	
	public void close(){
		doc.close();
	}
}
