/*
 * XMLFileFilter.java
 *
 * Created on March 16, 2004, 12:11 PM
 */
package pdfReport;

import icsDyn.ExtUtils;

/**
 *
 * @author  
 * Extend the File Filter class so that only certain extensions are allowed with
 * use in the File Chooser. Here we limit this to PDF files only.
 */
public class PDFFileFilter extends javax.swing.filechooser.FileFilter {
  
  public boolean accept(java.io.File f) {
    
    if (f.isDirectory()) {
      return true;
    }

    String extension = ExtUtils.getExtension(f);
    if (extension != null) {
      if (extension.equals(ExtUtils.pdf)) {
        return true;
      } else {
        return false;
      }
    }
    return false;
  }
 
  public String getDescription() {
    return ("PDF files");
  }
  
}
