package modifyIcs;

import icsDyn.MVCArg;
import java.io.File;
import java.util.Observable;
import org.w3c.dom.Document;


/**
 * This class allows sharing the ICS dom documents and notifying for changes
 * @author MC
 */
public class ICSDocuments extends Observable
{
    
    
    private Document doc;
    
    private Document docGeneral;
    
    private Document docService;
    
    private Document docTransport;
    private File XMLFile;
	   
	/** Creates a new instance of ICSDocuments */
	public ICSDocuments() {
	}
	/**
	* Fire an event
	* @param arg An MVCArg object
	*/
	public void fireEvent(MVCArg arg) {
        setChanged();
        notifyObservers(arg);
    }
	/**
	 * setDoc
	 * @param  docIn
	 * 
	 */
	public void setDoc(Document docIn)
	{
       doc = docIn;
       setChanged();
       notifyObservers(new MVCArg("updateDoc", doc));
	}
	/**
	 * setXMLFile
	 * @param  file
	 *
	 */
	public void setXMLFile(String tableTitle, File file)
	{
		XMLFile = file;
		setChanged();
		notifyObservers(new MVCArg("xmlFile/"+tableTitle, XMLFile));
	}
	/**
	 * setDocGeneral
	 * @param  docGen
	 * 
	 */
	public void setDocGeneral(Document docGen)
	{
       docGeneral = docGen;
       setChanged();
       notifyObservers(new MVCArg("updateDocGeneral", docGeneral));
	}
	/**
	 * setDocService
	 * @param  docSrv
	 * 
	 */
	public void setDocService(Document docSrv)
	{
       docService = docSrv;
       setChanged();
       notifyObservers(new MVCArg("updateDocService", docService));
	}
	public void setDocTransport(Document docT)
	{
       docTransport = docT;
       setChanged();
       notifyObservers(new MVCArg("updateDocTransport", docService));
	}
	/**
	 * setDocument
	 * @param tableTitle
	 * @param document
	 */
	public void setDocument(String tableTitle, Document document)
	{
       if(tableTitle == "doc")
               setDoc(document);
       else if(tableTitle == "General ICS")
               setDocGeneral(document);
       else if(tableTitle == "Service Support ICS")
               setDocService(document);
       else if(tableTitle == "Transport ICS")
           setDocTransport(document);
   	}
	/**
	 * setSave
	 *
	 */
	public void setSave(String tableTitle)
	{
       setChanged();
       notifyObservers(new MVCArg("save/"+tableTitle, true));
  	 }
	/**
	 * getDoc
	 * @return
	 * 
	 */
	public Document getDoc()
	{
       return doc;
	}
	/**
	 * getDocGeneral
	 * @return
	 * 
	 */
	public Document getDocGeneral()
	{
       return docGeneral;
	}
	/**
	 * getDocService
	 * @return
	 * 
	 */
	public Document getDocService()
  	{
       return docService;
  	}
	/**
	 * getXMLFile
	 * @return
	 * 
	 */
	public File getXMLFile()
	{
		return XMLFile;
	}
	
	public Document getDocTransport(){
		return docTransport;
	}
	public void fireTableModelChanged(){
		setChanged();
		notifyObservers(new MVCArg("Table Model Change",""));
	}
}
