

package modifyIcs;

import java.awt.GridBagConstraints;

import javax.swing.JOptionPane;

import org.w3c.dom.Document;

import icsTables.ICSGeneralTableModel;


/**
 * This class represents the Jpanel for the general tab
 * @author MC
 */
public class GeneralICSManagementView extends ICSViewPanel{

    private static final long serialVersionUID = 1L;
	
    /** Creates a new instance of GeneralICSManagementView */
    public GeneralICSManagementView() { 
    	 schemaSource = "..\\xsd\\GeneralICS.xsd";
    	 icsTable = new ICSGeneralTableModel();
         initComponants();
         doc = null;
    }
    
    /**
     * addGenerationPanel
     *
     */
    public void addGenerationPanel()
    {
        GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        try{
            jPanelICSTable.createTableGeneral(doc);
            add(jPanelGen, gridBagConstraints);
        }
        catch(Exception e)
        {
            JOptionPane.showMessageDialog(this, "Error while building the table! the XML file may be corrupted....","Error!", JOptionPane.ERROR_MESSAGE);
            e.printStackTrace();
            jPanelLoad.init();
            doc = null;
        }
        
    }

	public void loadFile(Document docIn) {
		 icsDocs.setDocGeneral(docIn);
	}
}
