

package icsTables;


import icsDyn.ICSManagementView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

import org.w3c.dom.*;

/**
 * This class represents the window displayed wich shows the selected ICS Tables
 * @author MC
 */
public class ICSFrame extends javax.swing.JFrame implements ActionListener
{
	private static final long serialVersionUID = 1L;
	private javax.swing.JTabbedPane jTabbedPane1;
	
    private ICSManagementView parent;
    private JButton btnOK;
    /** Creates new form ICSFrame 
     * @param strXMLFile the path of the XML file containing the data
     * @param bTables ICS tables that will appear DIMMOC, MOCAttribute, MOCBehaviour, MOCNotification
     * 
     * */
    public ICSFrame(ICSManagementView parentIn, String strXMLFile, boolean [] bTables) {       
        initComponents();
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        setSize(600,600);
        ICSTablePanel obj;
        parent = parentIn;
        
        
        if(bTables[2] == true)
        {
        	obj = new ICSTablePanel(new ICSDIMMOCTableModel(strXMLFile));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[3] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCAttributeTableModel(strXMLFile));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[4] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCNotificationTableModel(strXMLFile));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[5] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCBehaviourTableModel(strXMLFile));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
    }
    
    /**
     * Creates new form ICSFrame 
     * @param doc a dom document containing the data for the ICSTables
     * @param bTables ICS tables that will appear DIMMOC, MOCAttribute, MOCBehaviour, MOCNotification
     */
    public ICSFrame(ICSManagementView parentIn, Document doc, Document docGeneralIn, Document docServiceIn, boolean [] bTables) {       
        initComponents();
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        setSize(600,600);
        ICSTablePanel obj;
        this.parent = parentIn;
        setLocationRelativeTo(parent);
        if(bTables[0] == true)
        {
        	obj = new ICSTablePanel(new ICSGeneralTableModel(docGeneralIn));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[1] == true)
        {
        	obj = new ICSTablePanel(new ICSServiceTableModel(docServiceIn));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[2] == true)
        {
        	obj = new ICSTablePanel(new ICSDIMMOCTableModel(doc));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[3] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCAttributeTableModel(doc));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[4] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCNotificationTableModel(doc));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
        if(bTables[5] == true)
        {
        	obj = new ICSTablePanel(new ICSMOCBehaviourTableModel(doc));
        	jTabbedPane1.add(obj.getStrTitle(), obj);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * 
     */
    private void initComponents() {
        jTabbedPane1 = new javax.swing.JTabbedPane();
        btnOK = new JButton("Close");
        btnOK.addActionListener(this);
        btnOK.setBackground(new Color(204, 204, 255));
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(20,20,20,20));
        p.add(btnOK, BorderLayout.LINE_END);
        
        getContentPane().setLayout(new BorderLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("ICS Tables");
        getContentPane().add(jTabbedPane1, BorderLayout.CENTER);
        getContentPane().add(p, BorderLayout.PAGE_END);
       

        pack();
    }

	public void actionPerformed(ActionEvent arg0) {
		if(arg0.getSource() == btnOK){
			this.dispose();
		}		
	}
   
    
   
    
}
