
package icsTables;

import org.w3c.dom.*;

/**
 * ICSTableDIMMOC, represents the DIM MOC ICS Table
 * @author MC
 */
public class ICSDIMMOCTableModel extends ICSTableModel{
    
    /** Creates a new instance of ICSTableDIMMOC 
     * @param strXMLFile xml file
     * */
    public ICSDIMMOCTableModel(String strXMLFile) {
        super(strXMLFile);
        
    }
    /**
     * @see icsTables.ICSTableModel#init()
     */
    public void init()
    {
    	strTitle = "DIM MOC ICS";
        strTableName = "Table 10.3";
        strDescription = "The DIM MOC ICS defines wich managed medical objects are used by the implementation.";
        strXsltFileName = "..\\XSLT\\DimMocIcs1.xsl";
    }
    /**
     * Creates a new instance of ICSTableDIMMOC
     * @param doc
     */
    public ICSDIMMOCTableModel(Document doc) {
        super(doc);
        init();
    }
    
}
