package icsDyn;

import gov.nist.div897.Asn1ILib.Asn1Object;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

import addingsToAsnLib.ValidateAsnObject;

import dataTypeInterface.ComponentAsnServer;
import dataTypeInterface.IComponentAsn;

/**
 * This class is the dialog allowing the user input data concerning an attribute according to its data type
 * @author MC
 *
 */
public class DataTypeDialog extends JDialog implements ActionListener{
	/**
	 * 
	 */
	private static final long serialVersionUID = 4390238662096220120L;
	/**
	 * 
	 */
	JButton btnSave;
	JButton btnCancel;
	IComponentAsn compAsn;
	boolean isOkPressed = false;

	public DataTypeDialog(Dialog owner, String title, Asn1Object asnObj){
		super(owner, title,true);
		compAsn = ComponentAsnServer.instantiateAsnComponent(null, asnObj);
		compAsn.updateDataComp();
		initComponents();
		getRootPane().getInputMap().put(KeyStroke.getKeyStroke(
                KeyEvent.VK_ENTER, 0),
                "check");
		getRootPane().getActionMap().put("check", new AbstractAction() {
         
			private static final long serialVersionUID = -7558382448529798L;

			/**
			 * 
			 */
			public void actionPerformed(ActionEvent e) {
            	saveAction();
            }
        });
		pack();
		setLocationRelativeTo(owner.getOwner());
		setVisible(true);
			
		}

	private void initComponents() {
		JPanel p1 = new JPanel();
		p1.setLayout(new BorderLayout());
		
		JPanel p = new JPanel();
		
		p.setLayout(new BorderLayout());
		p.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		
		btnCancel = new JButton("Cancel");
		btnSave = new JButton("Add changes");
		btnCancel.addActionListener(this);
		btnSave.addActionListener(this);
		btnCancel.setBackground(new Color(204, 204, 255));
		btnSave.setBackground(new Color(204, 204, 255));
		
		p.add(btnSave, BorderLayout.WEST);
		p.add(btnCancel, BorderLayout.EAST);
		
		JPanel asnPan = new JPanel();
		asnPan.setLayout(new BorderLayout());
		asnPan.add(compAsn.getComponent(), BorderLayout.PAGE_START);
		JScrollPane scroll = new JScrollPane(asnPan);
		p1.add(scroll, BorderLayout.CENTER);
		p1.add(p, BorderLayout.PAGE_END);
		
		add(p1);
	}

	public void actionPerformed(ActionEvent arg0) {
		if(arg0.getSource() == btnSave){
			saveAction();
		}
		else if(arg0.getSource() == btnCancel){
			cancelAction();
		}
		
	}
	
	public void saveAction(){
		try{
			boolean ret = compAsn.saveData();
			if(!ret){
				JOptionPane.showMessageDialog( this, ValidateAsnObject.getErrorMessage(), "Error", JOptionPane.ERROR_MESSAGE );
			}
			else{
				isOkPressed = true;
				setVisible(false);
			}
		}
		catch(Exception e){
			e.printStackTrace();
			JOptionPane.showMessageDialog( this, e.getMessage(), "Error",JOptionPane.WARNING_MESSAGE );
		}
	}
	public void cancelAction(){
		setVisible(false);
	}
}
