package drawing;

/**
 * This class represents an edge of the graph
 * @author  MC
 */
public class Edge {
	/**
	 * the vertice where the edge starts
	 */
	public Vertice start;
	/**
	 * the vertice where the edge ends
	 */
	public Vertice end;
	/**
	 * whether th edge is oriented
	 */
	public boolean isOriented;
	/**
	 * whether the edge is virtual
	 */
	public boolean isVirtual;
	
	/**
	 * constructor
	 * @param startIn @see Edge#start
	 * @param endIn @see Edge#end
	 * @param oriented @see Edge#isOriented
	 */
	public Edge(Vertice startIn, Vertice endIn, boolean oriented){
		start = startIn;
		end = endIn;
		isOriented = oriented;
		isVirtual = false;
	}
	/**
	 * constructor
	 * @param startIn @see Edge#start
	 * @param endIn @see Edge#end
	 * @param oriented @see Edge#isOriented
	 * @param isV @see Edge#isVirtual
	 */
	public Edge(Vertice startIn, Vertice endIn, boolean oriented, boolean isV){
		start = startIn;
		end = endIn;
		isOriented = oriented;
		isVirtual = isV;
	}
}
