/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.Cell;
import com.lowagie.text.Row;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.table.RtfCell;
import com.lowagie.text.rtf.table.RtfTable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfRow
extends RtfElement {
    private static final byte[] ROW_BEGIN = "\\trowd".getBytes();
    private static final byte[] ROW_WIDTH_STYLE = "\\trftsWidth3".getBytes();
    private static final byte[] ROW_WIDTH = "\\trwWidth".getBytes();
    private static final byte[] ROW_KEEP_TOGETHER = "\\trkeep".getBytes();
    private static final byte[] ROW_HEADER_ROW = "\\trhdr".getBytes();
    private static final byte[] ROW_ALIGN_LEFT = "\\trql".getBytes();
    private static final byte[] ROW_ALIGN_RIGHT = "\\trqr".getBytes();
    private static final byte[] ROW_ALIGN_CENTER = "\\trqc".getBytes();
    private static final byte[] ROW_ALIGN_JUSTIFIED = "\\trqj".getBytes();
    private static final byte[] ROW_GRAPH = "\\trgaph10".getBytes();
    private static final byte[] ROW_CELL_SPACING_LEFT = "\\trspdl".getBytes();
    private static final byte[] ROW_CELL_SPACING_TOP = "\\trspdt".getBytes();
    private static final byte[] ROW_CELL_SPACING_RIGHT = "\\trspdr".getBytes();
    private static final byte[] ROW_CELL_SPACING_BOTTOM = "\\trspdb".getBytes();
    private static final byte[] ROW_CELL_SPACING_LEFT_STYLE = "\\trspdfl3".getBytes();
    private static final byte[] ROW_CELL_SPACING_TOP_STYLE = "\\trspdft3".getBytes();
    private static final byte[] ROW_CELL_SPACING_RIGHT_STYLE = "\\trspdfr3".getBytes();
    private static final byte[] ROW_CELL_SPACING_BOTTOM_STYLE = "\\trspdfb3".getBytes();
    private static final byte[] ROW_CELL_PADDING_LEFT = "\\trpaddl".getBytes();
    private static final byte[] ROW_CELL_PADDING_RIGHT = "\\trpaddr".getBytes();
    private static final byte[] ROW_CELL_PADDING_LEFT_STYLE = "\\trpaddfl3".getBytes();
    private static final byte[] ROW_CELL_PADDING_RIGHT_STYLE = "\\trpaddfr3".getBytes();
    private static final byte[] ROW_END = "\\row".getBytes();
    private RtfTable parentTable = null;
    private ArrayList cells = null;
    private int width = 0;
    private int rowNumber = 0;

    protected RtfRow(RtfDocument rtfDocument, RtfTable rtfTable, Row row, int n) {
        super(rtfDocument);
        this.parentTable = rtfTable;
        this.rowNumber = n;
        this.importRow(row);
    }

    private void importRow(Row row) {
        this.cells = new ArrayList();
        this.width = this.document.getDocumentHeader().getPageSetting().getPageWidth() - this.document.getDocumentHeader().getPageSetting().getMarginLeft() - this.document.getDocumentHeader().getPageSetting().getMarginRight();
        this.width = (int)((float)(this.width / 100) * this.parentTable.getTableWidthPercent());
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < row.columns(); ++i) {
            n2 = (int)((float)(this.width / 100) * this.parentTable.getProportionalWidths()[i]);
            Cell cell = (Cell)row.getCell(i);
            RtfCell rtfCell = new RtfCell(this.document, this, cell);
            rtfCell.setCellRight(n += n2);
            rtfCell.setCellWidth(n2);
            this.cells.add(rtfCell);
        }
    }

    protected void handleCellSpanning() {
        RtfCell rtfCell = new RtfCell(true);
        for (int i = 0; i < this.cells.size(); ++i) {
            RtfBasicElement rtfBasicElement;
            int n;
            RtfCell rtfCell2 = (RtfCell)this.cells.get(i);
            if (rtfCell2.getColspan() > 1) {
                int n2 = rtfCell2.getColspan();
                for (n = i + 1; n < i + n2; ++n) {
                    if (n >= this.cells.size()) continue;
                    rtfBasicElement = (RtfCell)this.cells.get(n);
                    rtfCell2.setCellRight(rtfCell2.getCellRight() + ((RtfCell)rtfBasicElement).getCellWidth());
                    rtfCell2.setCellWidth(rtfCell2.getCellWidth() + ((RtfCell)rtfBasicElement).getCellWidth());
                    this.cells.set(n, rtfCell);
                }
            }
            if (rtfCell2.getRowspan() <= 1) continue;
            ArrayList arrayList = this.parentTable.getRows();
            for (n = 1; n < rtfCell2.getRowspan(); ++n) {
                rtfBasicElement = (RtfRow)arrayList.get(this.rowNumber + n);
                if (this.rowNumber + n < arrayList.size()) {
                    RtfCell rtfCell3 = (RtfCell)((RtfRow)rtfBasicElement).getCells().get(i);
                    rtfCell3.setCellMergeChild(rtfCell2);
                }
                if (rtfCell2.getColspan() <= 1) continue;
                int n3 = rtfCell2.getColspan();
                for (int j = i + 1; j < i + n3; ++j) {
                    if (j >= ((RtfRow)rtfBasicElement).getCells().size()) continue;
                    ((RtfRow)rtfBasicElement).getCells().set(j, rtfCell);
                }
            }
        }
    }

    protected void cleanRow() {
        int n = 0;
        while (n < this.cells.size()) {
            if (((RtfCell)this.cells.get(n)).isDeleted()) {
                this.cells.remove(n);
                continue;
            }
            ++n;
        }
    }

    private byte[] writeRowDefinitions() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(ROW_BEGIN);
            byteArrayOutputStream.write(10);
            byteArrayOutputStream.write(ROW_WIDTH_STYLE);
            byteArrayOutputStream.write(ROW_WIDTH);
            byteArrayOutputStream.write(this.intToByteArray(this.width));
            if (this.parentTable.getCellsFitToPage()) {
                byteArrayOutputStream.write(ROW_KEEP_TOGETHER);
            }
            if (this.rowNumber <= this.parentTable.getHeaderRows()) {
                byteArrayOutputStream.write(ROW_HEADER_ROW);
            }
            switch (this.parentTable.getAlignment()) {
                case 0: {
                    byteArrayOutputStream.write(ROW_ALIGN_LEFT);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(ROW_ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(ROW_ALIGN_CENTER);
                    break;
                }
                case 3: 
                case 8: {
                    byteArrayOutputStream.write(ROW_ALIGN_JUSTIFIED);
                }
            }
            byteArrayOutputStream.write(ROW_GRAPH);
            byteArrayOutputStream.write(this.parentTable.getBorders().write());
            if (this.parentTable.getCellSpacing() > 0.0f) {
                byteArrayOutputStream.write(ROW_CELL_SPACING_LEFT);
                byteArrayOutputStream.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                byteArrayOutputStream.write(ROW_CELL_SPACING_LEFT_STYLE);
                byteArrayOutputStream.write(ROW_CELL_SPACING_TOP);
                byteArrayOutputStream.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                byteArrayOutputStream.write(ROW_CELL_SPACING_TOP_STYLE);
                byteArrayOutputStream.write(ROW_CELL_SPACING_RIGHT);
                byteArrayOutputStream.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                byteArrayOutputStream.write(ROW_CELL_SPACING_RIGHT_STYLE);
                byteArrayOutputStream.write(ROW_CELL_SPACING_BOTTOM);
                byteArrayOutputStream.write(this.intToByteArray((int)(this.parentTable.getCellSpacing() / 2.0f)));
                byteArrayOutputStream.write(ROW_CELL_SPACING_BOTTOM_STYLE);
            }
            byteArrayOutputStream.write(ROW_CELL_PADDING_LEFT);
            byteArrayOutputStream.write(this.intToByteArray((int)(this.parentTable.getCellPadding() / 2.0f)));
            byteArrayOutputStream.write(ROW_CELL_PADDING_RIGHT);
            byteArrayOutputStream.write(this.intToByteArray((int)(this.parentTable.getCellPadding() / 2.0f)));
            byteArrayOutputStream.write(ROW_CELL_PADDING_LEFT_STYLE);
            byteArrayOutputStream.write(ROW_CELL_PADDING_RIGHT_STYLE);
            byteArrayOutputStream.write(10);
            for (int i = 0; i < this.cells.size(); ++i) {
                RtfCell rtfCell = (RtfCell)this.cells.get(i);
                byteArrayOutputStream.write(rtfCell.writeDefinition());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.writeRowDefinitions());
            for (int i = 0; i < this.cells.size(); ++i) {
                RtfCell rtfCell = (RtfCell)this.cells.get(i);
                byteArrayOutputStream.write(rtfCell.write());
            }
            byteArrayOutputStream.write(RtfBasicElement.DELIMITER);
            if (this.document.getDocumentSettings().isOutputTableRowDefinitionAfter()) {
                byteArrayOutputStream.write(this.writeRowDefinitions());
            }
            byteArrayOutputStream.write(ROW_END);
            byteArrayOutputStream.write("\n".getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected RtfTable getParentTable() {
        return this.parentTable;
    }

    protected ArrayList getCells() {
        return this.cells;
    }
}

