/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.postscript;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Jpeg;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.codec.postscript.JavaCharStream;
import com.lowagie.text.pdf.codec.postscript.PACommand;
import com.lowagie.text.pdf.codec.postscript.PAEngine;
import com.lowagie.text.pdf.codec.postscript.PAParser;
import com.lowagie.text.pdf.codec.postscript.PAPencil;
import com.lowagie.text.pdf.codec.postscript.PAToken;
import com.lowagie.text.pdf.codec.postscript.PainterException;
import com.lowagie.text.pdf.codec.postscript.ParseException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.JFrame;

public class PAContext {
    public PAPencil pencil;
    public Stack dictionaries;
    public Stack operands;
    public PAEngine engine;
    PAParser poorscript = null;
    protected Random randomNumberGenerator;
    InputStream is = null;
    protected Object lastUnknownIdentifier;
    public static boolean IgnoreUnknownCommands = false;
    public static boolean DebugExecution = false;
    static /* synthetic */ Class class$com$lowagie$text$pdf$codec$postscript$PAContext;

    public PAContext(Component component) {
        this(new PAPencil(component));
    }

    public PAContext(Graphics2D graphics2D, Dimension dimension) {
        this(new PAPencil(graphics2D, dimension));
    }

    public PAContext(PAPencil pAPencil) {
        this.pencil = pAPencil;
        this.dictionaries = new Stack();
        this.operands = new Stack();
        this.engine = new PAEngine(this);
        HashMap hashMap = this.constructSystemDict();
        this.dictionaries.push(hashMap);
        HashMap hashMap2 = this.constructGlobalDict();
        this.dictionaries.push(hashMap2);
        HashMap hashMap3 = this.constructUserDict();
        hashMap.put("userdict", hashMap3);
        this.dictionaries.push(hashMap3);
        this.randomNumberGenerator = new Random();
        this.lastUnknownIdentifier = null;
    }

    public void draw(InputStream inputStream) throws PainterException {
        try {
            String string = "init.ps";
            InputStream inputStream2 = (class$com$lowagie$text$pdf$codec$postscript$PAContext == null ? (class$com$lowagie$text$pdf$codec$postscript$PAContext = PAContext.class$("com.lowagie.text.pdf.codec.postscript.PAContext")) : class$com$lowagie$text$pdf$codec$postscript$PAContext).getResourceAsStream(string);
            this.poorscript = new PAParser(inputStream2);
            this.poorscript.parse(this);
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.poorscript.ReInit(inputStream);
            this.poorscript.parse(this);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            throw new PainterException(parseException.toString());
        }
    }

    public Object getLastUnknownIdentifier() {
        return this.lastUnknownIdentifier;
    }

    public double[] popNumberOperands(int n) throws PainterException {
        double[] dArray = new double[n];
        for (int i = n - 1; i >= 0; --i) {
            Object e;
            try {
                e = this.operands.pop();
            }
            catch (EmptyStackException emptyStackException) {
                throw new PainterException("Operand stack is empty poping " + n + " number operands");
            }
            if (!(e instanceof Number)) {
                throw new PainterException("Number expected on operand stack poping " + n + " number operands, found " + e.getClass().getName());
            }
            double d = ((Number)e).doubleValue();
            dArray[i] = d;
        }
        return dArray;
    }

    public Object[] popOperands(int n) throws PainterException {
        Object[] objectArray = new Object[n];
        for (int i = n - 1; i >= 0; --i) {
            Object e;
            try {
                e = this.operands.pop();
            }
            catch (EmptyStackException emptyStackException) {
                throw new PainterException("Operand stack is empty poping " + n + " operands");
            }
            objectArray[i] = e;
        }
        return objectArray;
    }

    public Object peekOperand() throws PainterException {
        Object e;
        try {
            e = this.operands.peek();
        }
        catch (EmptyStackException emptyStackException) {
            throw new PainterException("Operand stack is empty peeking operand");
        }
        return e;
    }

    public Object findIdentifier(Object object) {
        Object var2_2 = null;
        int n = this.dictionaries.size();
        for (int i = n - 1; i >= 0 && var2_2 == null; --i) {
            HashMap hashMap = (HashMap)this.dictionaries.elementAt(i);
            var2_2 = hashMap.get(object);
        }
        if (var2_2 == null) {
            this.lastUnknownIdentifier = object;
        }
        return var2_2;
    }

    public Object findDictionary(Object object) {
        Object var2_2 = null;
        HashMap hashMap = null;
        int n = this.dictionaries.size();
        for (int i = n - 1; i >= 0 && var2_2 == null; --i) {
            hashMap = (HashMap)this.dictionaries.elementAt(i);
            var2_2 = hashMap.get(object);
        }
        if (var2_2 == null) {
            return var2_2;
        }
        return hashMap;
    }

    public void collectArray() throws PainterException {
        int n;
        Object e;
        int n2;
        boolean bl = false;
        int n3 = this.operands.size();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            e = this.operands.elementAt(n2);
            if (!(e instanceof PAToken) || ((PAToken)e).type != 7) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new PainterException("No array was started");
        }
        ArrayList arrayList = new ArrayList(n3 - n2 - 1);
        for (n = 0; n < n3 - n2 - 1; ++n) {
            arrayList.add(null);
        }
        for (n = n3 - 1; n > n2; --n) {
            try {
                e = this.operands.pop();
            }
            catch (EmptyStackException emptyStackException) {
                throw new PainterException("Operand stack is empty collecting array elements");
            }
            arrayList.set(n - n2 - 1, e);
        }
        try {
            this.operands.pop();
        }
        catch (EmptyStackException emptyStackException) {
            throw new PainterException("Operand stack is empty removing begin array mark");
        }
        this.operands.push(arrayList);
    }

    public void collectDict() throws PainterException {
        Object e;
        int n;
        boolean bl = false;
        int n2 = this.operands.size();
        for (n = n2 - 1; n >= 0; --n) {
            e = this.operands.elementAt(n);
            if (!(e instanceof PAToken) || ((PAToken)e).type != 9) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new PainterException("No dict was started");
        }
        HashMap hashMap = new HashMap();
        for (int i = n2 - 1; i > n; i -= 2) {
            Object e2;
            try {
                e2 = this.operands.pop();
                e = this.operands.pop();
            }
            catch (EmptyStackException emptyStackException) {
                throw new PainterException("Operand stack is empty collecting hashmap elements");
            }
            hashMap.put(e, e2);
        }
        try {
            this.operands.pop();
        }
        catch (EmptyStackException emptyStackException) {
            throw new PainterException("Operand stack is empty removing begin array mark");
        }
        this.operands.push(hashMap);
    }

    protected HashMap constructGlobalDict() {
        HashMap hashMap = new HashMap();
        return hashMap;
    }

    protected HashMap constructUserDict() {
        HashMap hashMap = new HashMap();
        return hashMap;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(2);
        PAContext pAContext = new PAContext(new PAPencil(jFrame));
        HashMap hashMap = (HashMap)pAContext.findDictionary("systemdict");
        Iterator iterator = new TreeSet(hashMap.keySet()).iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            Object v = hashMap.get(string);
            String string2 = v.getClass().getName();
            System.out.println(string + ":" + string2);
        }
        System.exit(0);
    }

    protected HashMap constructSystemDict() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("newpath", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.pencil.newpath();
            }
        });
        hashMap.put("moveto", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(2);
                pAContext.pencil.moveto(dArray[0], dArray[1]);
            }
        });
        hashMap.put("rmoveto", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(2);
                pAContext.pencil.rmoveto(dArray[0], dArray[1]);
            }
        });
        hashMap.put("lineto", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(2);
                pAContext.pencil.lineto(dArray[0], dArray[1]);
            }
        });
        hashMap.put("rlineto", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(2);
                pAContext.pencil.rlineto(dArray[0], dArray[1]);
            }
        });
        hashMap.put("arc", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(5);
                pAContext.pencil.arc(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4]);
            }
        });
        hashMap.put("arcn", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(5);
                pAContext.pencil.arcn(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4]);
            }
        });
        hashMap.put("curveto", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(6);
                pAContext.pencil.curveto(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            }
        });
        hashMap.put("rcurveto", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(6);
                pAContext.pencil.rcurveto(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            }
        });
        hashMap.put("closepath", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.pencil.closepath();
            }
        });
        hashMap.put("gsave", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.pencil.gsave();
            }
        });
        hashMap.put("grestore", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.pencil.grestore();
            }
        });
        hashMap.put("translate", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                if (pAContext.peekOperand() instanceof Number) {
                    AffineTransform affineTransform = new AffineTransform();
                    AffineTransform affineTransform2 = pAContext.pencil.graphics.getTransform();
                    double[] dArray = pAContext.popNumberOperands(2);
                    affineTransform.translate(dArray[0], dArray[1]);
                    affineTransform2.concatenate(affineTransform);
                    pAContext.pencil.graphics.setTransform(affineTransform2);
                } else {
                    Object[] objectArray = pAContext.popOperands(3);
                    if (!(objectArray[0] instanceof Number)) {
                        throw new PainterException("translate: wrong arguments");
                    }
                    if (!(objectArray[1] instanceof Number)) {
                        throw new PainterException("translate: wrong arguments");
                    }
                    if (!(objectArray[2] instanceof ArrayList)) {
                        throw new PainterException("translate: wrong arguments");
                    }
                    ArrayList arrayList = (ArrayList)objectArray[2];
                    if (arrayList.size() != 6) {
                        throw new PainterException("translate: wrong arguments");
                    }
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.translate(((Number)objectArray[0]).doubleValue(), ((Number)objectArray[1]).doubleValue());
                    double[] dArray = new double[6];
                    affineTransform.getMatrix(dArray);
                    for (int i = 0; i < 6; ++i) {
                        arrayList.set(i, new Double(dArray[i]));
                    }
                    pAContext.operands.push(arrayList);
                }
            }
        });
        hashMap.put("rotate", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                if (pAContext.peekOperand() instanceof Number) {
                    AffineTransform affineTransform = new AffineTransform();
                    AffineTransform affineTransform2 = pAContext.pencil.graphics.getTransform();
                    double[] dArray = pAContext.popNumberOperands(1);
                    affineTransform.rotate(dArray[0] * Math.PI / 180.0);
                    affineTransform2.concatenate(affineTransform);
                    pAContext.pencil.graphics.setTransform(affineTransform2);
                } else {
                    AffineTransform affineTransform = new AffineTransform();
                    Object[] objectArray = pAContext.popOperands(2);
                    if (!(objectArray[0] instanceof Number)) {
                        throw new PainterException("rotate: wrong arguments");
                    }
                    if (!(objectArray[1] instanceof ArrayList)) {
                        throw new PainterException("rotate: wrong arguments");
                    }
                    ArrayList arrayList = (ArrayList)objectArray[1];
                    if (arrayList.size() != 6) {
                        throw new PainterException("rotate: wrong arguments");
                    }
                    affineTransform.rotate(((Number)objectArray[0]).doubleValue());
                    double[] dArray = new double[6];
                    affineTransform.getMatrix(dArray);
                    for (int i = 0; i < 6; ++i) {
                        arrayList.set(i, new Double(dArray[i]));
                    }
                    pAContext.operands.push(arrayList);
                }
            }
        });
        hashMap.put("scale", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                if (pAContext.peekOperand() instanceof Number) {
                    AffineTransform affineTransform = new AffineTransform();
                    AffineTransform affineTransform2 = pAContext.pencil.graphics.getTransform();
                    double[] dArray = pAContext.popNumberOperands(2);
                    affineTransform.scale(dArray[0], dArray[1]);
                    affineTransform2.concatenate(affineTransform);
                    pAContext.pencil.graphics.setTransform(affineTransform2);
                } else {
                    Object[] objectArray = pAContext.popOperands(3);
                    if (!(objectArray[0] instanceof Number)) {
                        throw new PainterException("scale: wrong arguments");
                    }
                    if (!(objectArray[1] instanceof Number)) {
                        throw new PainterException("scale: wrong arguments");
                    }
                    if (!(objectArray[2] instanceof ArrayList)) {
                        throw new PainterException("scale: wrong arguments");
                    }
                    ArrayList arrayList = (ArrayList)objectArray[2];
                    double[] dArray = new double[6];
                    if (arrayList.size() != 6) {
                        throw new PainterException("scale: wrong arguments");
                    }
                    dArray[0] = ((Number)objectArray[0]).doubleValue();
                    dArray[1] = 0.0;
                    dArray[2] = 0.0;
                    dArray[3] = ((Number)objectArray[1]).doubleValue();
                    dArray[4] = 0.0;
                    dArray[5] = 0.0;
                    for (int i = 0; i < 6; ++i) {
                        arrayList.set(i, new Double(dArray[i]));
                    }
                    pAContext.operands.push(arrayList);
                }
            }
        });
        hashMap.put("currentmatrix", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof ArrayList)) {
                    throw new PainterException("currentmatrix: wrong argument");
                }
                ArrayList arrayList = (ArrayList)objectArray[0];
                double[] dArray = new double[6];
                if (arrayList.size() != 6) {
                    throw new PainterException("currentmatrix: wrong arguments");
                }
                AffineTransform affineTransform = pAContext.pencil.graphics.getTransform();
                affineTransform.getMatrix(dArray);
                for (int i = 0; i < 6; ++i) {
                    arrayList.set(i, new Double(dArray[i]));
                }
                pAContext.operands.push(arrayList);
            }
        });
        hashMap.put("setmatrix", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof ArrayList)) {
                    throw new PainterException("setmatrix: wrong argument");
                }
                ArrayList arrayList = (ArrayList)objectArray[0];
                double[] dArray = new double[6];
                if (arrayList.size() != 6) {
                    throw new PainterException("setmatrix: wrong arguments");
                }
                dArray[0] = ((Number)arrayList.get(0)).doubleValue();
                dArray[1] = ((Number)arrayList.get(1)).doubleValue();
                dArray[2] = ((Number)arrayList.get(2)).doubleValue();
                dArray[3] = ((Number)arrayList.get(3)).doubleValue();
                dArray[4] = ((Number)arrayList.get(4)).doubleValue();
                dArray[5] = ((Number)arrayList.get(5)).doubleValue();
                AffineTransform affineTransform = new AffineTransform(dArray);
                pAContext.pencil.graphics.setTransform(affineTransform);
            }
        });
        hashMap.put("stroke", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.pencil.stroke();
            }
        });
        hashMap.put("fill", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.pencil.fill();
            }
        });
        hashMap.put("eofill", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.pencil.eofill();
            }
        });
        hashMap.put("show", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof String)) {
                    throw new PainterException("show: wrong arguments");
                }
                pAContext.pencil.show((String)objectArray[0]);
            }
        });
        hashMap.put("stringwidth", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof String)) {
                    throw new PainterException("stringwidth: wrong arguments");
                }
                Font font = pAContext.pencil.graphics.getFont();
                Rectangle2D rectangle2D = font.getStringBounds((String)objectArray[0], pAContext.pencil.graphics.getFontRenderContext());
                pAContext.operands.push(new Float(rectangle2D.getWidth()));
                pAContext.operands.push(new Float(rectangle2D.getHeight()));
            }
        });
        hashMap.put("showpage", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.pencil.showpage();
            }
        });
        hashMap.put("findfont", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof PAToken)) {
                    throw new PainterException("findfont: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[0];
                if (pAToken.type != 1) {
                    throw new PainterException("findfont: wrong arguments");
                }
                pAContext.operands.push(pAContext.pencil.findFont((String)pAToken.value));
            }
        });
        hashMap.put("makefont", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof Font)) {
                    throw new PainterException("makefont: wrong arguments");
                }
                if (!(objectArray[1] instanceof ArrayList)) {
                    throw new PainterException("makefont: wrong arguments");
                }
                pAContext.operands.push(objectArray[0]);
            }
        });
        hashMap.put("scalefont", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof Font)) {
                    throw new PainterException("scalefont: wrong arguments");
                }
                if (!(objectArray[1] instanceof Number)) {
                    throw new PainterException("scalefont: wrong arguments");
                }
                Font font = ((Font)objectArray[0]).deriveFont(((Number)objectArray[1]).floatValue());
                System.out.println("Fonthoehe:" + font.getSize2D());
                pAContext.operands.push(font);
            }
        });
        hashMap.put("setfont", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof Font)) {
                    throw new PainterException("setfont: wrong arguments");
                }
                Font font = (Font)objectArray[0];
                System.out.println("Fonthoehe:" + font.getSize2D());
                pAContext.pencil.graphics.setFont(font);
                pAContext.pencil.state.font = font;
            }
        });
        hashMap.put("def", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof PAToken)) {
                    throw new PainterException("def: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[0];
                if (pAToken.type != 1) {
                    throw new PainterException("def: wrong arguments");
                }
                try {
                    ((HashMap)pAContext.dictionaries.peek()).put(pAToken.value, objectArray[1]);
                }
                catch (EmptyStackException emptyStackException) {
                    throw new PainterException(emptyStackException.toString());
                }
            }
        });
        hashMap.put("bind", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof PAToken)) {
                    throw new PainterException("bind: wrong arguments, not PAToken");
                }
                PAToken pAToken = (PAToken)objectArray[0];
                if (pAToken.type != 2) {
                    throw new PainterException("bind: wrong arguments, not Procedure " + pAToken.value);
                }
                pAContext.engine.bindProcedure(pAToken);
                pAContext.operands.push(pAToken);
            }
        });
        hashMap.put("mul", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(2);
                pAContext.operands.push(new Double(dArray[0] * dArray[1]));
            }
        });
        hashMap.put("div", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(2);
                pAContext.operands.push(new Double(dArray[0] / dArray[1]));
            }
        });
        hashMap.put("mod", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(2);
                int n = (int)dArray[0];
                int n2 = (int)dArray[1];
                int n3 = n % n2;
                pAContext.operands.push(new Integer(n3));
            }
        });
        hashMap.put("add", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(2);
                pAContext.operands.push(new Double(dArray[0] + dArray[1]));
            }
        });
        hashMap.put("neg", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                pAContext.operands.push(new Double(-dArray[0]));
            }
        });
        hashMap.put("ceiling", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                pAContext.operands.push(new Double(Math.ceil(dArray[0])));
            }
        });
        hashMap.put("sub", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(2);
                pAContext.operands.push(new Double(dArray[0] - dArray[1]));
            }
        });
        hashMap.put("atan", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(2);
                pAContext.operands.push(new Double(Math.atan2(dArray[0], dArray[1])));
            }
        });
        hashMap.put("sin", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                pAContext.operands.push(new Double(Math.sin(dArray[0] * Math.PI / 180.0)));
            }
        });
        hashMap.put("cos", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                pAContext.operands.push(new Double(Math.cos(dArray[0] * Math.PI / 180.0)));
            }
        });
        hashMap.put("sqrt", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                pAContext.operands.push(new Double(Math.sqrt(dArray[0])));
            }
        });
        hashMap.put("log", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                pAContext.operands.push(new Double(Math.log(dArray[0])));
            }
        });
        hashMap.put("exp", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(2);
                pAContext.operands.push(new Double(Math.pow(dArray[0], dArray[1])));
            }
        });
        hashMap.put("exch", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                pAContext.operands.push(objectArray[1]);
                pAContext.operands.push(objectArray[0]);
            }
        });
        hashMap.put("dup", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                pAContext.operands.push(objectArray[0]);
                pAContext.operands.push(objectArray[0]);
            }
        });
        hashMap.put("roll", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof Number)) {
                    throw new PainterException("roll: wrong arguments");
                }
                if (!(objectArray[1] instanceof Number)) {
                    throw new PainterException("roll: wrong arguments");
                }
                int n = ((Number)objectArray[0]).intValue();
                int n2 = ((Number)objectArray[1]).intValue();
                if (n2 == 0 || n <= 0) {
                    return;
                }
                Object[] objectArray2 = pAContext.popOperands(n);
                if (n2 < 0) {
                    int n3;
                    n2 = -n2;
                    for (n3 = n2 %= n; n3 < n; ++n3) {
                        pAContext.operands.push(objectArray2[n3]);
                    }
                    for (n3 = 0; n3 < n2; ++n3) {
                        pAContext.operands.push(objectArray2[n3]);
                    }
                } else {
                    int n4;
                    for (n4 = n - (n2 %= n); n4 < n; ++n4) {
                        pAContext.operands.push(objectArray2[n4]);
                    }
                    for (n4 = 0; n4 < n - n2; ++n4) {
                        pAContext.operands.push(objectArray2[n4]);
                    }
                }
            }
        });
        hashMap.put("pop", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.popOperands(1);
            }
        });
        hashMap.put("index", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof Number)) {
                    throw new PainterException("index: wrong arguments");
                }
                int n = ((Number)objectArray[0]).intValue();
                try {
                    pAContext.operands.push(pAContext.operands.elementAt(n));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new PainterException(arrayIndexOutOfBoundsException.toString());
                }
            }
        });
        hashMap.put("mark", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.operands.push(new PAToken(null, 3));
            }
        });
        hashMap.put("cvx", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object e = pAContext.operands.pop();
                ArrayList arrayList = (ArrayList)e;
                Stack stack = new Stack();
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    stack.add(arrayList.get(i));
                }
                PAToken pAToken = new PAToken(stack, 2);
                pAContext.operands.push(pAToken);
            }
        });
        hashMap.put("cleartomark", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                boolean bl = false;
                while (!bl) {
                    try {
                        Object e = pAContext.operands.pop();
                        if (!(e instanceof PAToken) || ((PAToken)e).type != 3) continue;
                        bl = true;
                    }
                    catch (EmptyStackException emptyStackException) {
                        throw new PainterException(emptyStackException.toString());
                    }
                }
            }
        });
        hashMap.put("copy", new PACommand(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (objectArray[0] instanceof PAToken && objectArray[1] instanceof PAToken) {
                    if (((PAToken)objectArray[0]).type != ((PAToken)objectArray[1]).type) throw new PainterException("copy operation failed because composite objects on stack are not of same type");
                    pAContext.operands.push(objectArray[0]);
                    pAContext.operands.push(objectArray[0]);
                    return;
                } else {
                    int n;
                    pAContext.operands.push(objectArray[0]);
                    if (!(objectArray[1] instanceof Number)) throw new PainterException("I expect a number on stack, dude");
                    int n2 = ((Number)objectArray[1]).intValue();
                    int n3 = pAContext.operands.size();
                    Object[] objectArray2 = new Object[n2];
                    for (n = n3 - n2; n < n3; ++n) {
                        try {
                            objectArray2[n - n3 + n2] = pAContext.operands.elementAt(n);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            throw new PainterException(arrayIndexOutOfBoundsException.toString());
                        }
                    }
                    for (n = 0; n < n2; ++n) {
                        pAContext.operands.push(objectArray2[n]);
                    }
                }
            }
        });
        hashMap.put("setgray", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                pAContext.pencil.graphics.setPaint(new Color((float)dArray[0], (float)dArray[0], (float)dArray[0]));
            }
        });
        hashMap.put("setrgbcolor", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(3);
                float[] fArray = new float[]{(float)Math.max(Math.min(dArray[0], 1.0), 0.0), (float)Math.max(Math.min(dArray[1], 1.0), 0.0), (float)Math.max(Math.min(dArray[2], 1.0), 0.0)};
                pAContext.pencil.graphics.setPaint(new Color(fArray[0], fArray[1], fArray[2]));
            }
        });
        hashMap.put("currentrgbcolor", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Color color = pAContext.pencil.graphics.getColor();
                float[] fArray = color.getRGBComponents(null);
                pAContext.operands.push(new Float(fArray[0]));
                pAContext.operands.push(new Float(fArray[1]));
                pAContext.operands.push(new Float(fArray[2]));
            }
        });
        hashMap.put("sethsbcolor", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(3);
                float[] fArray = new float[]{(float)Math.max(Math.min(dArray[0], 1.0), 0.0), (float)Math.max(Math.min(dArray[1], 1.0), 0.0), (float)Math.max(Math.min(dArray[2], 1.0), 0.0)};
                pAContext.pencil.graphics.setPaint(new Color(fArray[0], fArray[1], fArray[2]));
            }
        });
        hashMap.put("setcmykcolor", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(4);
                float[] fArray = new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3]};
                int n = (int)(255.0f * Math.max(0.0f, 1.0f - fArray[0] - fArray[3]));
                int n2 = (int)(255.0f * Math.max(0.0f, 1.0f - fArray[1] - fArray[3]));
                int n3 = (int)(255.0f * Math.max(0.0f, 1.0f - fArray[2] - fArray[3]));
                pAContext.pencil.graphics.setPaint(new Color(n, n2, n3));
            }
        });
        hashMap.put("setlinewidth", new PACommand(){

            private double minLineWidth(double d, AffineTransform affineTransform) {
                double[] dArray = new double[4];
                affineTransform.getMatrix(dArray);
                double d2 = dArray[0] * dArray[3] - dArray[1] * dArray[2];
                double d3 = 0.25 / Math.sqrt(Math.abs(d2));
                if (d < d3) {
                    d = d3;
                }
                return d;
            }

            public void execute(PAContext pAContext) throws PainterException {
                Stroke stroke = pAContext.pencil.graphics.getStroke();
                double[] dArray = pAContext.popNumberOperands(1);
                dArray[0] = this.minLineWidth(dArray[0], pAContext.pencil.graphics.getTransform());
                BasicStroke basicStroke = stroke instanceof BasicStroke ? new BasicStroke((float)dArray[0], ((BasicStroke)stroke).getEndCap(), ((BasicStroke)stroke).getLineJoin(), ((BasicStroke)stroke).getMiterLimit(), ((BasicStroke)stroke).getDashArray(), ((BasicStroke)stroke).getDashPhase()) : new BasicStroke((float)dArray[0], 1, 1);
                pAContext.pencil.graphics.setStroke(basicStroke);
            }
        });
        hashMap.put("setlinecap", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Stroke stroke = pAContext.pencil.graphics.getStroke();
                double[] dArray = pAContext.popNumberOperands(1);
                BasicStroke basicStroke = stroke instanceof BasicStroke ? new BasicStroke(((BasicStroke)stroke).getLineWidth(), (int)dArray[0], ((BasicStroke)stroke).getLineJoin(), ((BasicStroke)stroke).getMiterLimit(), ((BasicStroke)stroke).getDashArray(), ((BasicStroke)stroke).getDashPhase()) : new BasicStroke(1.0f, (int)dArray[0], 1);
                pAContext.pencil.graphics.setStroke(basicStroke);
            }
        });
        hashMap.put("setmiterlimit", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Stroke stroke = pAContext.pencil.graphics.getStroke();
                double[] dArray = pAContext.popNumberOperands(1);
                BasicStroke basicStroke = stroke instanceof BasicStroke ? new BasicStroke(((BasicStroke)stroke).getLineWidth(), ((BasicStroke)stroke).getEndCap(), ((BasicStroke)stroke).getLineJoin(), (float)dArray[0], ((BasicStroke)stroke).getDashArray(), ((BasicStroke)stroke).getDashPhase()) : new BasicStroke(1.0f, 1, 1, (float)dArray[0]);
                pAContext.pencil.graphics.setStroke(basicStroke);
            }
        });
        hashMap.put("setdash", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Stroke stroke = pAContext.pencil.graphics.getStroke();
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof ArrayList)) {
                    throw new PainterException("setdash: wrong arguments");
                }
                if (!(objectArray[1] instanceof Number)) {
                    throw new PainterException("setdash: wrong arguments");
                }
                ArrayList arrayList = (ArrayList)objectArray[0];
                if (arrayList.size() == 0) {
                    return;
                }
                float[] fArray = new float[arrayList.size()];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = ((Number)arrayList.get(i)).floatValue();
                }
                float f = ((Number)objectArray[1]).floatValue();
                BasicStroke basicStroke = stroke instanceof BasicStroke ? new BasicStroke(((BasicStroke)stroke).getLineWidth(), ((BasicStroke)stroke).getEndCap(), ((BasicStroke)stroke).getLineJoin(), ((BasicStroke)stroke).getMiterLimit(), fArray, f) : new BasicStroke(1.0f, 1, 1, 1.0f, fArray, f);
                pAContext.pencil.graphics.setStroke(basicStroke);
            }
        });
        hashMap.put("setlinejoin", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Stroke stroke = pAContext.pencil.graphics.getStroke();
                double[] dArray = pAContext.popNumberOperands(1);
                BasicStroke basicStroke = stroke instanceof BasicStroke ? new BasicStroke(((BasicStroke)stroke).getLineWidth(), ((BasicStroke)stroke).getEndCap(), (int)dArray[0], ((BasicStroke)stroke).getMiterLimit(), ((BasicStroke)stroke).getDashArray(), ((BasicStroke)stroke).getDashPhase()) : new BasicStroke(1.0f, 1, (int)dArray[0]);
                pAContext.pencil.graphics.setStroke(basicStroke);
            }
        });
        hashMap.put("dumpstack", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Enumeration enumeration = pAContext.operands.elements();
                System.out.println("-------------Stack--------------");
                while (enumeration.hasMoreElements()) {
                    System.out.println(enumeration.nextElement());
                }
                System.out.println("--------------------------------");
            }
        });
        hashMap.put("for", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(4);
                if (!(objectArray[3] instanceof PAToken)) {
                    throw new PainterException("for: wrong arguments");
                }
                if (!(objectArray[0] instanceof Number)) {
                    throw new PainterException("for: wrong arguments");
                }
                if (!(objectArray[1] instanceof Number)) {
                    throw new PainterException("for: wrong arguments");
                }
                if (!(objectArray[2] instanceof Number)) {
                    throw new PainterException("for: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[3];
                if (pAToken.type != 2) {
                    throw new PainterException("for: wrong arguments");
                }
                int n = ((Number)objectArray[0]).intValue();
                int n2 = ((Number)objectArray[1]).intValue();
                int n3 = ((Number)objectArray[2]).intValue();
                if (n2 > 0) {
                    for (int i = n; i <= n3; i += n2) {
                        pAContext.operands.push(new Integer(i));
                        pAContext.engine.process(pAToken);
                    }
                } else {
                    for (int i = n; i >= n3; i -= n2) {
                        pAContext.operands.push(new Integer(i));
                        pAContext.engine.process(pAToken);
                    }
                }
            }
        });
        hashMap.put("repeat", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[1] instanceof PAToken)) {
                    throw new PainterException("repeat: wrong arguments");
                }
                if (!(objectArray[0] instanceof Number)) {
                    throw new PainterException("repeat: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[1];
                if (pAToken.type != 2) {
                    throw new PainterException("repeat: wrong arguments");
                }
                int n = ((Number)objectArray[0]).intValue();
                for (int i = 0; i < n; ++i) {
                    pAContext.engine.process(pAToken);
                }
            }
        });
        hashMap.put("true", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.operands.push(new Boolean(true));
            }
        });
        hashMap.put("false", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.operands.push(new Boolean(false));
            }
        });
        hashMap.put("lt", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof Number) && !(objectArray[0] instanceof String)) {
                    throw new PainterException("lt: wrong arguments");
                }
                if (objectArray[0] instanceof Number) {
                    double d;
                    if (!(objectArray[1] instanceof Number)) {
                        throw new PainterException("lt: wrong arguments");
                    }
                    double d2 = ((Number)objectArray[0]).doubleValue();
                    if (d2 < (d = ((Number)objectArray[1]).doubleValue())) {
                        pAContext.operands.push(new Boolean(true));
                    } else {
                        pAContext.operands.push(new Boolean(false));
                    }
                } else {
                    if (!(objectArray[1] instanceof String)) {
                        throw new PainterException("lt: wrong arguments");
                    }
                    String string = (String)objectArray[0];
                    String string2 = (String)objectArray[1];
                    if (string.compareTo(string2) < 0) {
                        pAContext.operands.push(new Boolean(true));
                    } else {
                        pAContext.operands.push(new Boolean(false));
                    }
                }
            }
        });
        hashMap.put("gt", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof Number) && !(objectArray[0] instanceof String)) {
                    throw new PainterException("gt: wrong arguments");
                }
                if (objectArray[0] instanceof Number) {
                    double d;
                    if (!(objectArray[1] instanceof Number)) {
                        throw new PainterException("gt: wrong arguments");
                    }
                    double d2 = ((Number)objectArray[0]).doubleValue();
                    if (d2 > (d = ((Number)objectArray[1]).doubleValue())) {
                        pAContext.operands.push(new Boolean(true));
                    } else {
                        pAContext.operands.push(new Boolean(false));
                    }
                } else {
                    if (!(objectArray[1] instanceof String)) {
                        throw new PainterException("gt: wrong arguments");
                    }
                    String string = (String)objectArray[0];
                    String string2 = (String)objectArray[1];
                    if (string.compareTo(string2) > 0) {
                        pAContext.operands.push(new Boolean(true));
                    } else {
                        pAContext.operands.push(new Boolean(false));
                    }
                }
            }
        });
        hashMap.put("ge", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof Number) && !(objectArray[0] instanceof String)) {
                    throw new PainterException("ge: wrong arguments");
                }
                if (objectArray[0] instanceof Number) {
                    double d;
                    if (!(objectArray[1] instanceof Number)) {
                        throw new PainterException("ge: wrong arguments");
                    }
                    double d2 = ((Number)objectArray[0]).doubleValue();
                    if (d2 >= (d = ((Number)objectArray[1]).doubleValue())) {
                        pAContext.operands.push(new Boolean(true));
                    } else {
                        pAContext.operands.push(new Boolean(false));
                    }
                } else {
                    if (!(objectArray[1] instanceof String)) {
                        throw new PainterException("ge: wrong arguments");
                    }
                    String string = (String)objectArray[0];
                    String string2 = (String)objectArray[1];
                    if (string.compareTo(string2) >= 0) {
                        pAContext.operands.push(new Boolean(true));
                    } else {
                        pAContext.operands.push(new Boolean(false));
                    }
                }
            }
        });
        hashMap.put("ne", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof Number) && !(objectArray[0] instanceof String)) {
                    throw new PainterException("ne: wrong arguments");
                }
                if (objectArray[0] instanceof Number) {
                    double d;
                    if (!(objectArray[1] instanceof Number)) {
                        throw new PainterException("ne: wrong arguments");
                    }
                    double d2 = ((Number)objectArray[0]).doubleValue();
                    if (d2 != (d = ((Number)objectArray[1]).doubleValue())) {
                        pAContext.operands.push(new Boolean(true));
                    } else {
                        pAContext.operands.push(new Boolean(false));
                    }
                } else {
                    if (!(objectArray[1] instanceof String)) {
                        throw new PainterException("ne: wrong arguments");
                    }
                    String string = (String)objectArray[0];
                    String string2 = (String)objectArray[1];
                    if (string.equals(string2)) {
                        pAContext.operands.push(new Boolean(false));
                    } else {
                        pAContext.operands.push(new Boolean(true));
                    }
                }
            }
        });
        hashMap.put("eq", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof Number) && !(objectArray[0] instanceof String)) {
                    throw new PainterException("eq: wrong arguments");
                }
                if (objectArray[0] instanceof Number) {
                    double d;
                    if (!(objectArray[1] instanceof Number)) {
                        throw new PainterException("eq: wrong arguments");
                    }
                    double d2 = ((Number)objectArray[0]).doubleValue();
                    if (d2 == (d = ((Number)objectArray[1]).doubleValue())) {
                        pAContext.operands.push(new Boolean(true));
                    } else {
                        pAContext.operands.push(new Boolean(false));
                    }
                } else {
                    if (!(objectArray[1] instanceof String)) {
                        throw new PainterException("eq: wrong arguments");
                    }
                    String string = (String)objectArray[0];
                    String string2 = (String)objectArray[1];
                    if (string.compareTo(string2) == 0) {
                        pAContext.operands.push(new Boolean(true));
                    } else {
                        pAContext.operands.push(new Boolean(false));
                    }
                }
            }
        });
        hashMap.put("if", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof Boolean)) {
                    throw new PainterException("if: wrong arguments");
                }
                if (!(objectArray[1] instanceof PAToken)) {
                    throw new PainterException("if: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[1];
                if (pAToken.type != 2) {
                    throw new PainterException("if: wrong arguments");
                }
                if (((Boolean)objectArray[0]).booleanValue()) {
                    pAContext.engine.process(pAToken);
                }
            }
        });
        hashMap.put("ifelse", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(3);
                if (!(objectArray[0] instanceof Boolean)) {
                    throw new PainterException("ifelse: wrong arguments");
                }
                if (!(objectArray[1] instanceof PAToken)) {
                    throw new PainterException("ifelse: wrong arguments");
                }
                if (!(objectArray[2] instanceof PAToken)) {
                    throw new PainterException("ifelse: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[1];
                PAToken pAToken2 = (PAToken)objectArray[2];
                if (pAToken.type != 2) {
                    throw new PainterException("ifelse: wrong arguments");
                }
                if (pAToken2.type != 2) {
                    throw new PainterException("ifelse: wrong arguments");
                }
                if (((Boolean)objectArray[0]).booleanValue()) {
                    pAContext.engine.process(pAToken);
                } else {
                    pAContext.engine.process(pAToken2);
                }
            }
        });
        hashMap.put("dict", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                pAContext.operands.push(new HashMap((int)dArray[0]));
            }
        });
        hashMap.put("put", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(3);
                if (objectArray[0] instanceof HashMap && objectArray[1] instanceof PAToken) {
                    PAToken pAToken = (PAToken)objectArray[1];
                    if (pAToken.type != 1) {
                        throw new PainterException("put: wrong arguments");
                    }
                    ((HashMap)objectArray[0]).put(pAToken.value, objectArray[2]);
                } else if (objectArray[0] instanceof ArrayList && objectArray[1] instanceof Number) {
                    ArrayList arrayList = (ArrayList)objectArray[0];
                    Number number = (Number)objectArray[1];
                    arrayList.set(number.intValue(), objectArray[2]);
                } else if (objectArray[0] instanceof StringBuffer && objectArray[1] instanceof Number && objectArray[2] instanceof Number) {
                    StringBuffer stringBuffer = (StringBuffer)objectArray[0];
                    Number number = (Number)objectArray[1];
                    Number number2 = (Number)objectArray[2];
                    stringBuffer.setCharAt(number.intValue(), (char)number2.intValue());
                } else {
                    throw new PainterException("put: wrong arguments");
                }
            }
        });
        hashMap.put("get", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof HashMap) && !(objectArray[0] instanceof ArrayList)) {
                    throw new PainterException("get: wrong arguments");
                }
                if (objectArray[0] instanceof HashMap) {
                    if (!(objectArray[1] instanceof PAToken)) {
                        throw new PainterException("get: wrong arguments");
                    }
                    PAToken pAToken = (PAToken)objectArray[1];
                    if (pAToken.type != 1) {
                        throw new PainterException("get: wrong arguments");
                    }
                    pAContext.operands.push(((HashMap)objectArray[0]).get(pAToken.value));
                } else if (objectArray[0] instanceof ArrayList) {
                    if (!(objectArray[1] instanceof Number)) {
                        throw new PainterException("get: wrong arguments");
                    }
                    pAContext.operands.push(((ArrayList)objectArray[0]).get(((Number)objectArray[1]).intValue()));
                }
            }
        });
        hashMap.put("getinterval", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(3);
                if (!(objectArray[0] instanceof HashMap) && !(objectArray[0] instanceof ArrayList)) {
                    throw new PainterException("getinterval: wrong arguments");
                }
                if (objectArray[0] instanceof HashMap) {
                    if (!(objectArray[1] instanceof PAToken)) {
                        throw new PainterException("getinterval: wrong arguments");
                    }
                    PAToken pAToken = (PAToken)objectArray[1];
                    if (pAToken.type != 1) {
                        throw new PainterException("getinterval: wrong arguments");
                    }
                    if (!(objectArray[2] instanceof Number)) {
                        throw new PainterException("getinterval: wrong arguments");
                    }
                    HashMap hashMap = new HashMap();
                    pAContext.operands.push(((HashMap)objectArray[0]).get(pAToken.value));
                } else if (objectArray[0] instanceof ArrayList) {
                    if (!(objectArray[1] instanceof Number)) {
                        throw new PainterException("getinterval: wrong arguments");
                    }
                    if (!(objectArray[2] instanceof Number)) {
                        throw new PainterException("getinterval: wrong arguments");
                    }
                    ArrayList arrayList = (ArrayList)objectArray[0];
                    int n = ((Number)objectArray[1]).intValue();
                    int n2 = n + ((Number)objectArray[2]).intValue();
                    ArrayList arrayList2 = new ArrayList(arrayList.subList(n, n2));
                    pAContext.operands.push(arrayList2);
                }
            }
        });
        hashMap.put("load", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof PAToken)) {
                    throw new PainterException("load: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[0];
                if (pAToken.type != 1) {
                    throw new PainterException("load: wrong arguments");
                }
                pAContext.operands.push(pAContext.findIdentifier(pAToken.value));
            }
        });
        hashMap.put("length", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                int n = 0;
                Object[] objectArray = pAContext.popOperands(1);
                if (objectArray[0] instanceof PAToken) {
                    PAToken pAToken = (PAToken)objectArray[0];
                    if (pAToken.type != 1) {
                        throw new PainterException("length: wrong arguments");
                    }
                    n = ((String)pAToken.value).length();
                } else if (objectArray[0] instanceof HashMap) {
                    n = ((HashMap)objectArray[0]).size();
                } else if (objectArray[0] instanceof ArrayList) {
                    n = ((ArrayList)objectArray[0]).size();
                } else if (objectArray[0] instanceof String) {
                    n = ((String)objectArray[0]).length();
                } else {
                    throw new PainterException("length: wrong arguments");
                }
                pAContext.operands.push(new Integer(n));
            }
        });
        hashMap.put("begin", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof HashMap)) {
                    throw new PainterException("begin: wrong arguments");
                }
                pAContext.dictionaries.push(objectArray[0]);
            }
        });
        hashMap.put("end", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                try {
                    pAContext.dictionaries.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    throw new PainterException("Dictionary stack is empty");
                }
            }
        });
        hashMap.put("undef", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof HashMap)) {
                    throw new PainterException("undef: wrong arguments");
                }
                if (!(objectArray[1] instanceof PAToken)) {
                    throw new PainterException("undef: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[1];
                if (pAToken.type != 1) {
                    throw new PainterException("undef: wrong arguments");
                }
            }
        });
        hashMap.put("known", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof PAToken)) {
                    throw new PainterException("known: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[0];
                if (pAToken.type != 1) {
                    throw new PainterException("known: wrong arguments");
                }
                Object object = pAContext.findIdentifier(pAToken.value);
                if (object != null) {
                    pAContext.operands.push(new Boolean(true));
                } else {
                    pAContext.operands.push(new Boolean(false));
                }
            }
        });
        hashMap.put("where", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof PAToken)) {
                    throw new PainterException("where: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[0];
                if (pAToken.type != 1) {
                    throw new PainterException("where: wrong arguments");
                }
                Object object = pAContext.findDictionary(pAToken.value);
                if (object != null) {
                    pAContext.operands.push(object);
                    pAContext.operands.push(new Boolean(true));
                } else {
                    pAContext.operands.push(new Boolean(false));
                }
            }
        });
        hashMap.put("aload", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (objectArray[0] instanceof PAToken) {
                    objectArray[0] = ((PAToken)objectArray[0]).value;
                }
                if (!(objectArray[0] instanceof AbstractList)) {
                    throw new PainterException("aload: wrong arguments");
                }
                AbstractList abstractList = (AbstractList)objectArray[0];
                Iterator iterator = abstractList.iterator();
                while (iterator.hasNext()) {
                    pAContext.operands.push(iterator.next());
                }
                pAContext.operands.push(objectArray[0]);
            }
        });
        hashMap.put("forall", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof ArrayList)) {
                    throw new PainterException("forall: wrong arguments");
                }
                if (!(objectArray[1] instanceof PAToken)) {
                    throw new PainterException("forall: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[1];
                if (pAToken.type != 2) {
                    throw new PainterException("forall: wrong arguments");
                }
                ArrayList arrayList = (ArrayList)objectArray[0];
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    pAContext.operands.push(iterator.next());
                    pAContext.engine.process(pAToken);
                }
            }
        });
        hashMap.put("currentflat", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)pAContext.pencil.graphics;
                PdfContentByte pdfContentByte = pdfGraphics2D.getContent();
                pAContext.operands.push(new Double(1.0));
            }
        });
        hashMap.put("setflat", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)pAContext.pencil.graphics;
                PdfContentByte pdfContentByte = pdfGraphics2D.getContent();
                pdfContentByte.setFlatness((float)dArray[0]);
            }
        });
        hashMap.put("round", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                pAContext.operands.push(new Long(Math.round(dArray[0])));
            }
        });
        hashMap.put("abs", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                pAContext.operands.push(new Double(Math.abs(dArray[0])));
            }
        });
        hashMap.put("transform", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                if (pAContext.peekOperand() instanceof Number) {
                    double[] dArray = new double[2];
                    double[] dArray2 = pAContext.popNumberOperands(2);
                    AffineTransform affineTransform = pAContext.pencil.graphics.getTransform();
                    affineTransform.transform(dArray2, 0, dArray, 0, 1);
                    pAContext.operands.push(new Double(dArray[0]));
                    pAContext.operands.push(new Double(dArray[1]));
                } else {
                    Object[] objectArray = pAContext.popOperands(3);
                    if (!(objectArray[0] instanceof Number)) {
                        throw new PainterException("transform: wrong arguments");
                    }
                    if (!(objectArray[1] instanceof Number)) {
                        throw new PainterException("transform: wrong arguments");
                    }
                    if (!(objectArray[2] instanceof ArrayList)) {
                        throw new PainterException("transform: wrong arguments");
                    }
                    ArrayList arrayList = (ArrayList)objectArray[2];
                    double[] dArray = new double[6];
                    if (arrayList.size() != 6) {
                        throw new PainterException("transform: wrong arguments");
                    }
                    for (int i = 0; i < 6; ++i) {
                        dArray[i] = ((Number)arrayList.get(i)).doubleValue();
                    }
                    AffineTransform affineTransform = new AffineTransform(dArray);
                    double[] dArray3 = new double[]{((Number)objectArray[0]).doubleValue(), ((Number)objectArray[1]).doubleValue()};
                    double[] dArray4 = new double[2];
                    affineTransform.transform(dArray3, 0, dArray4, 0, 1);
                    pAContext.operands.push(new Double(dArray4[0]));
                    pAContext.operands.push(new Double(dArray4[1]));
                }
            }
        });
        hashMap.put("itransform", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                if (pAContext.peekOperand() instanceof Number) {
                    double[] dArray = new double[2];
                    double[] dArray2 = pAContext.popNumberOperands(2);
                    AffineTransform affineTransform = pAContext.pencil.graphics.getTransform();
                    try {
                        affineTransform.inverseTransform(dArray2, 0, dArray, 0, 1);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        throw new PainterException(noninvertibleTransformException.toString());
                    }
                    pAContext.operands.push(new Double(dArray[0]));
                    pAContext.operands.push(new Double(dArray[1]));
                } else {
                    Object[] objectArray = pAContext.popOperands(3);
                    if (!(objectArray[0] instanceof Number)) {
                        throw new PainterException("itransform: wrong arguments");
                    }
                    if (!(objectArray[1] instanceof Number)) {
                        throw new PainterException("itransform: wrong arguments");
                    }
                    if (!(objectArray[2] instanceof ArrayList)) {
                        throw new PainterException("itransform: wrong arguments");
                    }
                    ArrayList arrayList = (ArrayList)objectArray[2];
                    double[] dArray = new double[6];
                    if (arrayList.size() != 6) {
                        throw new PainterException("itransform: wrong arguments");
                    }
                    for (int i = 0; i < 6; ++i) {
                        dArray[i] = ((Number)arrayList.get(i)).doubleValue();
                    }
                    AffineTransform affineTransform = new AffineTransform(dArray);
                    double[] dArray3 = new double[]{((Number)objectArray[0]).doubleValue(), ((Number)objectArray[0]).doubleValue()};
                    double[] dArray4 = new double[2];
                    try {
                        affineTransform.inverseTransform(dArray3, 0, dArray4, 0, 1);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        throw new PainterException(noninvertibleTransformException.toString());
                    }
                    pAContext.operands.push(new Double(dArray4[0]));
                    pAContext.operands.push(new Double(dArray4[1]));
                }
            }
        });
        hashMap.put("currentpoint", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Point2D point2D = pAContext.pencil.state.path.getCurrentPoint();
                pAContext.operands.push(new Double(point2D.getX()));
                pAContext.operands.push(new Double(point2D.getY()));
            }
        });
        hashMap.put("clippath", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.pencil.clippath();
            }
        });
        hashMap.put("matrix", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                ArrayList<Double> arrayList = new ArrayList<Double>(6);
                arrayList.add(new Double(1.0));
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(1.0));
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(0.0));
                pAContext.operands.push(arrayList);
            }
        });
        hashMap.put("concatmatrix", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                int n;
                Object[] objectArray = pAContext.popOperands(3);
                if (!(objectArray[0] instanceof ArrayList)) {
                    throw new PainterException("concatmatrix: wrong arguments");
                }
                if (!(objectArray[1] instanceof ArrayList)) {
                    throw new PainterException("concatmatrix: wrong arguments");
                }
                if (!(objectArray[2] instanceof ArrayList)) {
                    throw new PainterException("concatmatrix: wrong arguments");
                }
                ArrayList arrayList = (ArrayList)objectArray[0];
                ArrayList arrayList2 = (ArrayList)objectArray[1];
                ArrayList arrayList3 = (ArrayList)objectArray[2];
                double[] dArray = new double[6];
                if (arrayList.size() != 6) {
                    throw new PainterException("concatmatrix: wrong arguments");
                }
                if (arrayList2.size() != 6) {
                    throw new PainterException("concatmatrix: wrong arguments");
                }
                if (arrayList3.size() != 6) {
                    throw new PainterException("concatmatrix: wrong arguments");
                }
                for (n = 0; n < 6; ++n) {
                    dArray[n] = ((Number)arrayList.get(n)).doubleValue();
                }
                AffineTransform affineTransform = new AffineTransform(dArray);
                for (n = 0; n < 6; ++n) {
                    dArray[n] = ((Number)arrayList2.get(n)).doubleValue();
                }
                AffineTransform affineTransform2 = new AffineTransform(dArray);
                affineTransform.concatenate(affineTransform2);
                affineTransform.getMatrix(dArray);
                for (n = 0; n < 6; ++n) {
                    arrayList3.set(n, new Double(dArray[n]));
                }
                pAContext.operands.push(arrayList3);
            }
        });
        hashMap.put("pathbbox", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Rectangle2D rectangle2D = pAContext.pencil.state.path.getBounds2D();
                pAContext.operands.push(new Double(rectangle2D.getMinX()));
                pAContext.operands.push(new Double(rectangle2D.getMinY()));
                pAContext.operands.push(new Double(rectangle2D.getMaxX()));
                pAContext.operands.push(new Double(rectangle2D.getMaxY()));
            }
        });
        hashMap.put("initmatrix", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)pAContext.pencil.graphics;
                PdfContentByte pdfContentByte = pdfGraphics2D.getContent();
            }
        });
        hashMap.put("initclip", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)pAContext.pencil.graphics;
                PdfContentByte pdfContentByte = pdfGraphics2D.getContent();
                pAContext.pencil.clippath();
            }
        });
        hashMap.put("truncate", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                double d = dArray[0] < 0.0 ? Math.ceil(dArray[0]) : Math.floor(dArray[0]);
                pAContext.operands.push(new Double(d));
            }
        });
        hashMap.put("rand", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.operands.push(new Integer(Math.abs(PAContext.this.randomNumberGenerator.nextInt(Integer.MAX_VALUE))));
            }
        });
        hashMap.put("srand", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                double[] dArray = pAContext.popNumberOperands(1);
                PAContext.this.randomNumberGenerator = new Random(Math.round(dArray[0]));
            }
        });
        hashMap.put("version", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.operands.push("2016");
            }
        });
        hashMap.put("cvi", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof Number) && !(objectArray[0] instanceof String)) {
                    throw new PainterException("cvi: wrong arguments");
                }
                if (objectArray[0] instanceof Number) {
                    int n = ((Number)objectArray[0]).intValue();
                    pAContext.operands.push(new Integer(n));
                } else {
                    String string = (String)objectArray[0];
                    pAContext.operands.push(new Integer(string));
                }
            }
        });
        hashMap.put("cvr", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof Number) && !(objectArray[0] instanceof String)) {
                    throw new PainterException("cvr: wrong arguments");
                }
                if (objectArray[0] instanceof Number) {
                    int n = ((Number)objectArray[0]).intValue();
                    pAContext.operands.push(new Double(n));
                } else {
                    String string = (String)objectArray[0];
                    pAContext.operands.push(new Double(string));
                }
            }
        });
        hashMap.put("usertime", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.operands.push(new Long(System.currentTimeMillis()));
            }
        });
        hashMap.put("save", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)pAContext.pencil.graphics;
                PdfContentByte pdfContentByte = pdfGraphics2D.getContent();
                pdfContentByte.saveState();
                pAContext.operands.push(new Long(0L));
            }
        });
        hashMap.put("restore", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)pAContext.pencil.graphics;
                PdfContentByte pdfContentByte = pdfGraphics2D.getContent();
                pdfContentByte.restoreState();
                Object[] objectArray = pAContext.popOperands(1);
            }
        });
        hashMap.put("clear", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.operands.clear();
            }
        });
        hashMap.put("readonly", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
            }
        });
        hashMap.put("currentfile", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                JavaCharStream javaCharStream = pAContext.poorscript.jj_input_stream;
                InputStream inputStream = new InputStream(this, javaCharStream){
                    private final /* synthetic */ JavaCharStream val$jcs;
                    private final /* synthetic */ 111 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$jcs = javaCharStream;
                    }

                    public int read() throws IOException {
                        return this.val$jcs.readChar();
                    }
                };
                pAContext.operands.push(inputStream);
            }
        });
        hashMap.put("flushfile", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof InputStream)) {
                    throw new PainterException("flushfile: wrong arguments");
                }
                InputStream inputStream = (InputStream)objectArray[0];
                try {
                    while (inputStream.read() != -1) {
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        hashMap.put("closefile", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof InputStream)) {
                    throw new PainterException("closefile: wrong arguments");
                }
                InputStream inputStream = (InputStream)objectArray[0];
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        hashMap.put("string", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof Number)) {
                    throw new PainterException("string: wrong arguments");
                }
                int n = ((Number)objectArray[0]).intValue();
                StringBuffer stringBuffer = new StringBuffer(n);
                stringBuffer.setLength(n);
                pAContext.operands.push(stringBuffer);
            }
        });
        hashMap.put("null", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.operands.push(null);
            }
        });
        hashMap.put("currentscreen", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                if (!IgnoreUnknownCommands) {
                    throw new UnsupportedOperationException("currentscreen");
                }
                pAContext.operands.push(new Double(60.0));
                pAContext.operands.push(new Double(0.0));
                pAContext.operands.push(new Double(0.0));
            }
        });
        hashMap.put("setscreen", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(3);
            }
        });
        hashMap.put("flattenpath", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
            }
        });
        hashMap.put("filter", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object object;
                Object object2;
                Object object3;
                String string = (String)((PAToken)pAContext.popOperands((int)1)[0]).value;
                while (!((object3 = pAContext.peekOperand()) instanceof InputStream)) {
                    object2 = pAContext.popOperands(1);
                }
                object2 = (InputStream)pAContext.popOperands(1)[0];
                if (string.equals("ASCIIHexDecode")) {
                    Object object4 = object2;
                    object = new InputStream(this, (InputStream)object4){
                        private final /* synthetic */ InputStream val$is;
                        private final /* synthetic */ 120 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$is = inputStream;
                        }

                        public int read() throws IOException {
                            int n;
                            int n2;
                            do {
                                if ((n2 = this.val$is.read()) == -1) {
                                    return -1;
                                }
                                if (n2 != 62) continue;
                                return -1;
                            } while (n2 == 10 || n2 == 13);
                            do {
                                if ((n = this.val$is.read()) == 62) {
                                    return -1;
                                }
                                if (n != -1) continue;
                                return -1;
                            } while (n == 10 || n == 13);
                            int n3 = 0;
                            if (n2 >= 48 && n2 <= 57) {
                                n3 = n2 - 48;
                            }
                            if (n2 >= 65 && n2 <= 70) {
                                n3 = n2 - 55;
                            }
                            int n4 = 0;
                            if (n >= 48 && n <= 57) {
                                n4 = n - 48;
                            }
                            if (n >= 65 && n <= 70) {
                                n4 = n - 55;
                            }
                            return n3 * 16 + n4;
                        }
                    };
                } else {
                    object = object2;
                }
                pAContext.operands.push(object);
            }
        });
        hashMap.put("clip", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.pencil.clip();
            }
        });
        hashMap.put("setcolorspace", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)pAContext.pencil.graphics;
                PdfContentByte pdfContentByte = pdfGraphics2D.getContent();
                Object[] objectArray = pAContext.popOperands(1);
                if (objectArray[0] instanceof PAToken) {
                    String string = (String)((PAToken)objectArray[0]).value;
                    pdfContentByte.setDefaultColorspace(PdfName.COLORSPACE, PdfName.DEVICERGB);
                }
            }
        });
        hashMap.put("image", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)pAContext.pencil.graphics;
                PdfContentByte pdfContentByte = pdfGraphics2D.getContent();
                Object[] objectArray = pAContext.popOperands(1);
                if (objectArray[0] instanceof Number) {
                    int n = ((Number)objectArray[0]).intValue();
                    objectArray = pAContext.popOperands(4);
                    int n2 = ((Number)objectArray[0]).intValue();
                    int n3 = ((Number)objectArray[1]).intValue();
                } else if (objectArray[0] instanceof PAToken) {
                    PAToken pAToken = (PAToken)objectArray[0];
                    objectArray = pAContext.popOperands(4);
                    int n = ((Number)objectArray[0]).intValue();
                    int n4 = ((Number)objectArray[1]).intValue();
                    int n5 = ((Number)objectArray[2]).intValue();
                    ArrayList arrayList = (ArrayList)objectArray[3];
                    System.out.println("I " + n + "*" + n4 + " " + n5 + " " + arrayList);
                } else if (objectArray[0] instanceof HashMap) {
                    Object object;
                    HashMap hashMap = (HashMap)objectArray[0];
                    Iterator iterator = hashMap.keySet().iterator();
                    int n = 0;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    InputStream inputStream = null;
                    Object var12_20 = null;
                    Object var13_21 = null;
                    while (iterator.hasNext()) {
                        object = (PAToken)iterator.next();
                        if (((PAToken)object).value.toString().equals("ImageType")) {
                            n8 = ((Number)hashMap.get(object)).intValue();
                        }
                        if (((PAToken)object).value.toString().equals("DataSource")) {
                            inputStream = (InputStream)hashMap.get(object);
                        }
                        if (((PAToken)object).value.toString().equals("BitsPerComponent")) {
                            n7 = ((Number)hashMap.get(object)).intValue();
                        }
                        if (((PAToken)object).value.toString().equals("Width")) {
                            n = ((Number)hashMap.get(object)).intValue();
                        }
                        if (((PAToken)object).value.toString().equals("Height")) {
                            n6 = ((Number)hashMap.get(object)).intValue();
                        }
                        if (((PAToken)object).value.toString().equals("Decode")) {
                            var12_20 = hashMap.get(object);
                        }
                        if (!((PAToken)object).value.toString().equals("ImageMatrix")) continue;
                        var13_21 = hashMap.get(object);
                    }
                    try {
                        int n9;
                        object = new byte[0];
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        while ((n9 = inputStream.read()) >= 0) {
                            byteArrayOutputStream.write(n9);
                        }
                        System.out.println("I " + n + "*" + n6 + " " + n7 + " " + n8 + " " + var12_20 + " " + var13_21 + " " + inputStream);
                        object = byteArrayOutputStream.toByteArray();
                        Jpeg jpeg = new Jpeg((byte[])object);
                        try {
                            pdfContentByte.addImage(jpeg, n, 0.0f, 0.0f, n6, 0.0f, 0.0f);
                        }
                        catch (DocumentException documentException) {
                            documentException.printStackTrace();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    catch (BadElementException badElementException) {
                        badElementException.printStackTrace();
                    }
                }
            }
        });
        hashMap.put("imagemask", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(5);
            }
        });
        hashMap.put("exec", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (objectArray[0] instanceof PAToken) {
                    PAToken pAToken = (PAToken)objectArray[0];
                    pAContext.engine.process(pAToken);
                }
            }
        });
        hashMap.put("currentdict", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.operands.push(pAContext.dictionaries.peek());
            }
        });
        hashMap.put("cleardictstack", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                pAContext.dictionaries.clear();
                HashMap hashMap = pAContext.constructSystemDict();
                pAContext.dictionaries.push(hashMap);
                HashMap hashMap2 = pAContext.constructGlobalDict();
                pAContext.dictionaries.push(hashMap2);
                HashMap hashMap3 = pAContext.constructUserDict();
                hashMap.put("userdict", hashMap3);
                hashMap.put("globaldict", hashMap2);
                pAContext.dictionaries.push(hashMap3);
            }
        });
        hashMap.put("charpath", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(2);
                if (!(objectArray[0] instanceof String)) {
                    throw new PainterException("charpath: wrong arguments");
                }
                if (!(objectArray[1] instanceof Boolean)) {
                    throw new PainterException("charpath: wrong arguments");
                }
                pAContext.pencil.charpath((String)objectArray[0], (Boolean)objectArray[1]);
            }
        });
        hashMap.put("stopped", new PACommand(){

            public void execute(PAContext pAContext) throws PainterException {
                Object[] objectArray = pAContext.popOperands(1);
                if (!(objectArray[0] instanceof PAToken)) {
                    throw new PainterException("stopped: wrong arguments");
                }
                PAToken pAToken = (PAToken)objectArray[0];
                if (pAToken.type != 2) {
                    throw new PainterException("stopped: wrong arguments");
                }
                pAContext.engine.process(pAToken);
                pAContext.operands.push(new Boolean(false));
            }
        });
        hashMap.put("systemdict", hashMap);
        return hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NamedInputStream
    extends InputStream {
        public String filename;
        InputStream in;

        NamedInputStream(InputStream inputStream, String string) {
            this.filename = string;
            this.in = inputStream;
        }

        public int read() throws IOException {
            return this.in.read();
        }
    }
}

