/*****************************************************************************
*  sha.h                                                      VERSION 3.00   *
*----------------------------------------------------------------------------*
*  S E C U R E   H A S H   S T A N D A R D  (SHA)                            *
*  FEDERAL INFORMATION PROCESSING STANDARDS PUBLICATION 180                  *
*  APRIL 1993                                                                *
*----------------------------------------------------------------------------*
*  This software was produced at the National Institute of Standards and     *
*  Technology (NIST) as part of research efforts and is for demonstration    *
*  purposes only.  Our primary goals in its design did not include widespread*
*  use outside of our own laboratories.  Acceptance of this software implies *
*  that you agree to use it for non-commercial purposes only and that you    *
*  agree to accept it as nonproprietary and unlicensed, not supported by NIST*
*  and not carrying any warranty, either expressed or implied, as to its     *
*  performance or fitness for any particular purpose.                        *
*----------------------------------------------------------------------------*
*  Produced by the National Institute of Standards and Technology (NIST),    *
*  Computer Systems Laboratory (CSL) Security Technology Group.              *
*****************************************************************************/

#ifndef CONFIG_H
#define VERSIONINFO_1   1
#include "config.h"
#endif


#ifndef _SHA_H_
#define _SHA_H_

#define SHADIGITLEN     4               /* in bytes */
#define SHABLOCKLEN     512             /* in bits */
#define SHABYTEBLOCKLEN 64              /* in bytes */
#define SHAHASHLEN      20              /* in bytes */

typedef struct {
	 ULONG Numbits;
	 ULONG Numblocks[2];  /* each block contains 64 bytes */
	 ULONG Mblock[16];
	 ULONG H[5];
} SHA_CTX;

#define BYTE   unsigned char

/*
#define DEBUGSHA
*/

#ifdef LITTLE_ENDIAN
#define n1E6    1000.0
#else
#define n1E6    1000000.0
#endif

#ifdef PROTOTYPES

/*****************
 * SHA functions *
 *****************/
#ifndef WINDOWS31
int	SHAInit(SHA_CTX _far *);
int	SHAUpdate(SHA_CTX _far *, BYTE _far *buffer, int);
int	SHAFinal(SHA_CTX _far *);
void	ProcessBlock(SHA_CTX _far *);
int	SHAInit2(SHA_CTX _far *, ULONG _far *);
int	SHATest(void);
void	SHATimeTrial(void);
int	SHAFile(char _far *, ULONG _far *);
int	SHAFileDate(char _far *, ULONG, ULONG _far *);
int	SHAString(char _far *, ULONG _far *);
int	SHABlock(BYTE _far *, int, ULONG _far *);
#else

extern int  SHAInit(SHA_CTX *);
extern int  SHAInit2(SHA_CTX *, ULONG *);
extern int  SHAUpdate(SHA_CTX *, unsigned char *, int);
extern int  SHAFinal(SHA_CTX *);
extern int  SHATest();
extern void  ProcessBlock(SHA_CTX *);
#ifdef LITTLE_ENDIAN
extern void  byteReverse(ULONG *, int);
#endif
#ifdef LITTLE_ENDIAN2
extern void  byteReverse(BYTE *, int);
#endif

extern int	 SHATest(void);
extern void	 SHATimeTrial(void);
extern int	 SHAFile(char *, ULONG *);
extern int	 SHAFileDate(char *, ULONG, ULONG *);
extern int	 SHAString(char *, ULONG *);
extern int	 SHABlock(BYTE *, int, ULONG *);
/*
int F_P_E SHAInit();
int F_P_E SHAUpdate();
int F_P_E SHAFinal();
int F_P_E SHATest();
void F_P_E ProcessBlock();
#ifdef LITTLE_ENDIAN
void F_P_E byteReverse(ULONG *, int);
#endif
int F_P_E SHAInit2();
*/

#endif

#else

/*****************
 * SHA functions *
 *****************/

int	SHAFile();
int	SHAInit();
int	SHAInit2();
int	SHAUpdate();
int	SHATest();
int	SHAFinal();
void	ProcessBlock();
void	byteReverse(); 
int	SHATest();
void	SHATimeTrial();
int	SHAFile();
int	SHAFileDate();
int	SHAString();
int	SHABlock();

#endif

#endif /*_SHA_H_*/

