DEFDBL A-Z
 '****************************
 ' P R O G R A M   E L V A C *
 '****************************
 '
 '
 '
 '---------------------------------------------------------------------------
 '
 ' A            RATE OF CAR ACCELERATION IN FT/S**2.
 ' Asi          RATE OF CAR ACCELERATION IN M/S**2.
 ' BASTRANSIN   BASIC TRANSFER INEFFICIENCY. CHOSEN TO 0.1.
 ' BOTTOEXIT    DISTANCE FROM BOTTOMMOST FLOOR TO EXIT.
 ' DISTANTFLR   THE NUMBER OF THE FLOOR MOST DISTANT FROM THE EXIT FLOOR.
 ' DOORINEFF()  DOOR INEFFICIENCY VALUES, SELECTED BY THE USER FROM A TABLE.     ' DOORTIME()   TIME IN SECONDS REQUIRED FOR THE OPENING AND CLOSING OF THE
 ' DOORPTYPES$  DIFFERENT TYPES OF ELEVATOR DOORS, IN A FORMAT USED FOR
 '               PRINTING.
 ' DOORTYPES$   CHARACTER STRING ARRAY WHICH CONTAINS THE DIFFERENT TYPES OF
 '               ELEVATOR DOORS AS WELL AS THEIR CHARACTERISTICS.
 ' DRTIME       TIME (s) REQUIRED FOR THE OPENING AND CLOSING OF THE ELEVATOR
 '               CAR DOOR.
 ' ELCARS       TOTAL NUMBER OF ELEVATOR CARS WITHIN THE GROUP, INPUT BY THE
 '               USER.
 ' ELEVATION(I) ELEVATIONS OF THE VARIOUS FLOORS ABOVE THE LOWEST FLOOR,
 '               WHICH IS ASSUMED TO HAVE AN ELEVATION OF 0. I IS Ith FLOOR.
 ' EXITDELAY    TIME (s) TO OUTSIDE AFTER LEAVING ELEVATOR.
 ' EXITFLR      POSITION OF THE EXIT FLOOR RELATIVE TO THE LOWEST FLOOR
 '               IN THE BUILDING. FOR EXAMPLE, IF EXITFLR IS 3, IT IS TWO
 '               FLOORS ABOVE THE LOWEST ONE.
 ' EXITIMEFLRI  TIME (s) FOR ALL RESIDENTS OF FLOOR I TO REACH EXIT FLOOR.
 ' EXITNAME$    NAME OF FLOOR CHOSEN TO BE THE EXIT FLOOR.
 ' EVACTIME     TOTAL EVACUATION TIME USING ALL ELEVATOR CARS IN THE BANK.
 ' FINPCT$      SET TO "Y" WHEN THE MODEL USER WISHES TO CONTINUE THE RUN
 '               WITH NEW ELEVATOR PERCENTAGE VALUES.
 ' FLOORS$      THE CHARACTER VARIABLE CONTAINING THE LINE OF FLOOR NAMES.
 ' FLRNAMES$(I) CHARACTER ARRAY WHICH HOLDS THE FLOOR NAMES AFTER THE RANGES
 '               HAVE BEEN EXPANDED BY THE PROGRAM.
 ' FULLOAD      NUMBER OF PEOPLE THAT FULLY LOAD THE ELEVATOR CAR.
 ' HGTDIF(I)    HEIGHT DIFFERENCE BETWEEN FLOOR I AND FLOOR I+1.
 ' INFOPATH$    THE LOCATION WHERE GENERAL INFORMATION ABOUT THE PROGRAM
 '               IS SENT.
 ' KILLEXP      A VARIABLE THAT IS SET TO 1 IF ANY ERRORS ARE FOUND IN THE
 '               SPECIFIED LINE OF FLOOR NAMES.
 ' LEVELTME     TIME (s) REQUIRED FOR THE LEVELING OF THE ELEVATOR CAR. IT
 '               CURRENTLY IS SET TO .5 SECONDS.
 ' METELEV      ELEVATION OF CURRENT FLOOR IN METERS. RECOMPUTED FOR EACH
 '               FLOOR.
 ' MTITLE1$     FIRST TITLE ROW FOR OUTPUT TABLE.
 ' MTITLE2$     SECOND TITLE ROW FOR OUTPUT TABLE.
 ' MTITLE3$     THIRD TITLE ROW FOR OUTPUT TABLE.
 ' NPPLELAST    THIS IS THE NUMBER OF PEOPLE IN THE ELEVATOR CAR DURING THE
 '               LAST TRIP, AND IS RECOMPUTED FOR EACH FLOOR.
 ' NTRIPSFULL   THE NUMBER OF ROUND TRIPS WITH A FULLY LOADED ELEVATOR CAR,
 '               RECOMPUTED FOR EACH FLOOR.
 ' OPTIONERROR$ A FLAG THAT IS SET TO "YES" IF THE OUTPUTOPTION IS NOT
 '               1 OR 2.
 ' OTHERTRANSIN OTHER TRANSFER INEFFICIENCY VALUE, DUE TO ELEVATOR CAR SHAPE
 '               AND OCCUPANT USE.
 ' OUTPUTOPTION AN INTEGER BETWEEN 1 AND 2 WHICH IS CHOSEN BY THE USER TO
 '               DETERMINE WHERE STORED OUTPUT IS SENT.
 ' PATHSEL$     "N" IF ONLY SCREEN OUTPUT IS DESIRED, "PRN" IF THE FINAL
 '               OUTPUT RESULTS ARE TO BE PRINTED, OR A DOS FILENAME IF THE
 '               FINAL OUTPUT RESULTS ARE TO BE SENT TO A FILE.
 ' PEOPLE(I)    NUMBER OF PEOPLE ON THE Ith FLOOR.
 ' PERCNT(I)    PERCENT OF PEOPLE ON Ith FLOOR WHO USE ELEVATOR CARS TO LEAVE
 '               THE BUILDING.
 ' PPLEFLR      TYPICAL NUMBER OF PEOPLE ON A FLOOR, GIVEN BY THE USER.
 ' PPLEI        ACTUAL NUMBER OF PEOPLE ON Ith FLOOR WHO USE THE ELEVATOR
 '               CAR. IT IS THE PRODUCT OF PEOPLE(I) AND PERCNT(I).
 ' PRINTINFO$   A FLAG SET TO Y IF THE USER WISHES TO READ ABOUT THE MODEL.
 ' RERUNPERCNT  FLAG SET EQUAL TO 0 WHEN THE USER WISHES TO LEAVE THE MAIN
 '               DO LOOP, OR 1 WHEN HE WISHES TO RERUN IT WITH NEW ELEVATOR
 '               USAGE PERCENTAGE VALUES.
 ' RERUNOUTPUT$  SET EQUAL TO Y WHEN THE USER DESIRES TO SEND THE OUTPUT
 '               RESULTS TO THE PRINTER OR A FILE.
 ' RERUNPROG$   SET EQUAL TO "Y" WHEN THE USER WISHES TO RERUN THE PROGRAM.
 ' RNDTIMES(I)  TOTAL TIME (s) FOR THE TRIPS REQUIRED TO EVACUATE FLOOR I.
 ' STARTUPTIME  TIME SPENT BEFORE THE ACTUAL EVACUATION BY ELEVATOR CARS
 '               BEGINS. IT IS COMPUTED FIRST TO BE THE TIME REQUIRED TO
 '               BRING A FULLY LOADED ELEVATOR CAR FROM THE MOST DISTANT
 '               FLOOR TO THE EXIT FLOOR. IF THIS IS NOT SATISFACTORY, THE
 '               USER INPUTS A LARGER VALUE.
 ' STNDTMEFULL  STANDING TIME CALCULATED FOR A FULLY LOADED ELEVATOR.
 ' TIMEFULL     SUM OF THE TIMES OF FULLY LOADED ROUND TRIPS. RECOMPUTED FOR
 '               EACH FLOOR.
 ' TIMELAST     TIME REQUIRED FOR THE LAST ROUND TRIP FROM A FLOOR.
 ' TIMES(I)     TIME FOR A ONE WAY TRIP TO FLOOR I.
 ' TITLE$       TITLE OF THE CURRENT RUN.
 ' TOKENS$(I)   NON-BLANK SUBSTRINGS CONTAINED WITHIN EACH PARSED LINE (SEE
 '               PARSING ROUTINE).
 ' TOPTOEXIT    DISTANCE FROM TOP FLOOR TO EXIT FLOOR.
 ' TOTFLRS      TOTAL NUMBER OF FLOORS IN THE BUILDING.
 ' TOTINEFF     BASIC TRANSFER INEFFICIENCY + DOOR INEFFICIENCY +
 '               OTHER TRANSFER INEFFICIENCY.
 ' TOTTIME      TOTAL TIME TO EVACUATE BUILDING BY ELEVATOR.
 ' TRANS        TRANSITIONAL COEFFICIENT. V1 = TRANS*VMAX.
 ' TRIPINEFF    TRIP INEFFICIENCY DUE TO GATHERING STRAGGLERS, TRAVEL TO
 '               EMPTY FLOORS, FLOW RESTRICTIONS, ETC.
 ' TRIPS        NUMBER OF ROUND TRIPS NEEDED TO EVACUATE A FLOOR.
 ' TYPDIF       TYPICAL FLOOR TO FLOOR HEIGHT IN FEET.
 ' TYPDIFsi     TYPICAL FLOOR TO FLOOR HEIGHT IN METERS.
 ' TYPPERCNT    TYPICAL PERCENT OF ELEVATOR USAGE.
 ' UNITS        1 IF SI UNITS ARE DESIRED, 2 IF ENGLISH UNITS ARE REQUESTED.
 ' VMAX         MAXIMUM ELEVATOR CAR VELOCITY IN ft./second.
 ' VMAXsi       MAXIMUM ELEVATOR CAR VELOCITY IN m./second.
 '---------------------------------------------------------------------------

 '      FIRST, DECLARE THE FIVE SUBROUTINES AND THE FUNCTION CALLED BY THE
 '      MAIN PROGRAM. THESE SIX SUBPROGRAMS AND THEIR ARGUMENTS WILL BE
 '      DESCRIBED BY COMMENT STATEMENTS APPEARING LATER.
      DECLARE SUB CHECK (NUMTOK#, LLIMIT#, UPLIMIT#, ARRPTR#)
      DECLARE SUB PARSE (STORE$, NUMTOKS#)
      DECLARE SUB HEIGHTS ()
      DECLARE SUB RANGEEXP (FLRSTR$, FLRSUB1, FLRSUB2, FLR1$, FLR2$, EXPEXCP)
      DECLARE SUB TRIPTIME ()
      DECLARE FUNCTION CALCSTAND# (PEOP#)

 '      THESE ARE THE VARIABLES SHARED WITH OTHER ROUTINES.
      DIM SHARED TOKENS$(200), FLOORS$, UNITS
      DIM SHARED FLRNAMES$(200), HGTDIF(200), ELEVATION(200)
      DIM SHARED TIMES(200), people(200), PERCNT(200)
      DIM SHARED KILLEXP, TOTFLRS, EXITFLR
      DIM SHARED TYPDIF, TYPDIFsi, VMAX, TRANS, A, LEVELTME, FULLOAD
      DIM SHARED DRTIME, TOTINEFF
     
 '      DIMENSION THE ARRAYS WHICH ARE NOT SHARED.
      DIM DOORTYPES$(15), Doortime(14), DOORINEFF(14), RNDTIMES(200)
      DIM DOORPTYPES$(13)

 
 '      DATA STATEMENTS INITIALIZING THE DOORTIME AND DOOR TRANFER
 '      INEFFICIENCY ARRAY NOW APPEAR.
      DATA 6.6,5.9,4.1,7.0,6.6,4.6,7.7,5.3,8.8,6.0,9.9,6.5,6.0
      DATA .10,.10,.08,.07,.07,.05,.02,0,.02,0,.02,0,0
      FOR I = 1 TO 13: READ Doortime(I): NEXT I
      FOR I = 1 TO 13: READ DOORINEFF(I): NEXT I


 '      DATA STATEMENTS USED IN INITIALIZING THE DOOR TYPE ARRAY
 '      ARE NOW GIVEN. THE ARRAY IS THEN INITIALIZED.
      DATA" A Single-Slide           900mm (36in)       6.6           0.10"
      DATA" B Two-Speed              900mm (36in)       5.9           0.10"
      DATA" C Center-Opening         900mm (36in)       4.1           0.08"
      DATA" D Single-Slide          1100mm (42in)       7.0           0.07"
      DATA" E Two-Speed             1100mm (42in)       6.6           0.07"
      DATA" F Center-Opening        1100mm (42in)       4.6           0.05"
      DATA" G Two-Speed             1200mm (48in)       7.7           0.02"
      DATA" H Center-Opening        1200mm (48in)       5.3           0   "
      DATA" I Two-Speed             1400mm (54in)       8.8           0.02"
      DATA" J Center-Opening        1400mm (54in)       6.0           0   "
      DATA" K Two-Speed             1600mm (60in)       9.9           0.02"
      DATA" L Center-Opening        1600mm (60in)       6.5           0   "
      DATA" M Two-Speed,            1600mm (60in)       6.0           0   "
      DATA"     Center-Opening                                            "
      DATA" N OTHER                                                       "
      FOR I = 1 TO 15: READ DOORTYPES$(I): NEXT I


 '      DATA STATEMENTS TO INITIALIZE THE DOOR TYPE PRINTING ARRAY NOW
 '      APPEAR. INITIALIZATION OF THE ARRAY IS PERFORMED.
      DATA" A Single-Slide                900mm (36in) wide"
      DATA" B Two-Speed                   900mm (36in) wide"
      DATA" C Center-Opening              900mm (36in) wide"
      DATA" D Single-Slide               1100mm (42in) wide"
      DATA" E Two-Speed                  1100mm (42in) wide"
      DATA" F Center-Opening             1100mm (42in) wide"
      DATA" G Two-Speed                  1200mm (48in) wide"
      DATA" H Center-Opening             1200mm (48in) wide"
      DATA" I Two-Speed                  1400mm (54in) wide"
      DATA" J Center-Opening             1400mm (54in) wide"
      DATA" K Two-Speed                  1600mm (60in) wide"
      DATA" L Center-Opening             1600mm (60in) wide"
      DATA" M Two-Speed, Center-Opening  1600mm (60in) wide"
      FOR I = 1 TO 13: READ DOORPTYPES$(I): NEXT I


 '      SET THE DEFAULT VALUES OF SOME OF THE VARIABLES.
      BASTRANSIN = .1#
      TRANS = .6#
      LEVELTME = .5#
      RERUNOUTPUT$ = "N"
      PATHSEL$ = "SCRN:"

 '      THE MAIN TITLES FOR THE OUTPUT TABLE ARE NOW CREATED.
      MTITLE1$ = "                             One     Round   People"
      MTITLE1$ = MTITLE1$ + "                   Time"
      MTITLE2$ = "Floor       Elevation        Way     Trip      on"
      MTITLE2$ = MTITLE2$ + "    Percent  Round    per"
      MTITLE3$ = "Name        m       ft      Time s   Time s"
      MTITLE3$ = MTITLE3$ + "  Floor   Usage    Trips   Floor s"



 '  ******************************************************
 '  ***   MAIN PROGRAM EXECUTION DO LOOP.
 '           THIS LOOP RUNS THE ENTIRE PROGRAM. AT THE END,
 '           THE USER IS ASKED IF HE WISHES TO RERUN IT. IF
 '           SO, THE PROGRAM IS RERUN. OTHERWISE, THE LOOP
 '           IS EXITED AND THE PROGRAM STOPS.
 '  ******************************************************

   DO
    
     
 '      INITIALLY SEND COMPUTED OUTPUT TO THE SCREEN.
      CLS
      OPEN "SCRN:" FOR OUTPUT AS #1


      PRINT ""
      PRINT "****************************************************************"
      PRINT " ELVAC VERSION 1.00                                             "
      PRINT " WRITTEN BY DANIEL M. ALVORD AND                                "
      PRINT "        JOHN H. KLOTE                                           "
      PRINT "                                                                "
      PRINT "CONTRIBUTION OF THE NATIONAL INSTITUTE OF STANDARDS AND         "
      PRINT "   TECHNOLOGY. (U.S.)                                           "
      PRINT "  NOT SUBJECT TO COPYRIGHT                                      "
      PRINT "                                                                "
      PRINT "FOR COMPILED VERSION ONLY - PORTIONS (C) COPYRIGHT MICROSOFT    "
      PRINT "CORPORATION, 1988. ALL RIGHTS RESERVED.                         "
      PRINT "                                                                "
      PRINT "DOCUMENTATION: KLOTE,J.H., ALVORD,D.M., ROUTINE FOR ANALYSIS OF "
      PRINT "THE PEOPLE MOVEMENT TIME FOR ELEVATOR EVACUATION, NATIONAL      "
      PRINT "INSTITUTE OF STANDARDS AND TECHNOLOGY, (U.S.),                  "
      PRINT "NISTIR 4730, 1992.                                              "
      PRINT "****************************************************************"
      PRINT ""


 '      THE USER NOW INDICATES IF HE WISHES TO READ GENERAL INFORMATION
 '      ABOUT PARTICULAR CONCEPTS OF THE ELEVATOR MODEL.
      INPUT "Do you want to read about the model (Y or N)?  ", PRINTINFO$
      PRINTINFO$ = UCASE$(PRINTINFO$)

 '      THE USER NOW SPECIFIES WHERE THE GENERAL INFORMATION SHOULD BE
 '      PLACED.
      PRINT ""
      IF PRINTINFO$ = "Y" THEN
         PRINT "Where do you wish the general information to appear?"
         PRINT "  (a filename, PRN for printer, or ENTER for output"
         INPUT "   to the screen.)  ", INFOPATH$
         INFOPATH$ = UCASE$(INFOPATH$)
         IF INFOPATH$ = "" THEN INFOPATH$ = "SCRN:"
         OPEN INFOPATH$ FOR OUTPUT AS #2
      END IF

 '      GENERAL INFORMATION ABOUT THE MODEL AND ITS COMPUTER IMPLEMENTATION
 '      IS NOW GIVEN, IF THE USER SO SPECIFIES.
      IF PRINTINFO$ = "Y" THEN

      CLS
      PRINT ""
      PRINT #2, " --------------Basic concepts of the model------------------"
      PRINT #2, " Basic transfer inefficiency- a factor that allows for      "
      PRINT #2, "   rounding off of probable stops, door operating time, door"
      PRINT #2, "   starting and stopping time, and the unpredictability of  "
      PRINT #2, "   people. A value of 0.10 is used for commonly accepted    "
      PRINT #2, "   arrangements of elevator groups.                         "
      PRINT #2, " Discharge floor-  When emergency evacuation starts,        "
      PRINT #2, "   elevators will take people to a discharge floor where    "
      PRINT #2, "   passengers on the elevators will exit. This floor may    "
      PRINT #2, "   lead to the outside or to an area of relative safety.    "
      PRINT #2, " Door inefficiency- Adjusts for any increase in transfer    "
      PRINT #2, "   time over that of a 1200 mm (48 in) wide center opening  "
      PRINT #2, "   door.                                                    "
       IF INFOPATH$ = "SCRN:" THEN
          PRINT ""
          INPUT "Press ENTER to continue.......", junk$
          CLS
          PRINT ""
       END IF
      PRINT #2, " Dwell time- The minimum time an elevator car door remains  "
      PRINT #2, "   open. The time used in this program is 4 seconds.        "
      PRINT #2, " Groups-  Elevators are located in groups of up to eight    "
      PRINT #2, "   elevators. The elevators in a group are located near each"
      PRINT #2, "   other and are controlled together to move people         "
      PRINT #2, "   efficiently.                                             "
      PRINT #2, " Elevator evacuation start up time- The time from activation"
      PRINT #2, "   of the alarms(for example) to the start of the round trips"
      PRINT #2, "   that evacuate people. If the elevators are operated      "
      PRINT #2, "   automatically during evacuation, one starts the elevator "
      PRINT #2, "   evacuation after all of the elevators have been moved    "
      PRINT #2, "   to the discharge floor and the people in them have left. "
      PRINT #2, "   In the case of manual elevator operation, the time for   "
      PRINT #2, "   elevators operators to reach the cars must be included.  "
      PRINT #2, " Motion- Elevator motion starts with constant acceleration, "
      PRINT #2, "   followed by transitional acceleration until constant     "
      PRINT #2, "   velocity motion at the normal operating velocity of the  "
      PRINT #2, "   car is attained.                                                 "
       IF INFOPATH$ = "SCRN:" THEN
          PRINT ""
          INPUT "Press ENTER to continue....", junk$
          CLS
          PRINT ""
       END IF
      PRINT #2, " Other transfer inefficiency- accounts for inefficiencies   "
      PRINT #2, "   due to unusual elevator car shape or limited physical    "
      PRINT #2, "   capability of passengers. In office buildings, a value of"
      PRINT #2, "   0 is used.                                               "
      PRINT #2, " Round trip- a round trip starts at the discharge floor and "
      PRINT #2, "   consists of the sequence: elevator doors close, car      "
      PRINT #2, "   travels to another floor, doors open, passengers enter   "
      PRINT #2, "   the car, doors close, car travels to discharge floor,    "
      PRINT #2, "   doors open, and passengers leave the car. Alternatively, "
      PRINT #2, "   it may be defined as two one way trips and a standing    "
      PRINT #2, "   period.                                                  "
      PRINT #2, " Standing time-  Twice the time required to open and close  "
      PRINT #2, "   the elevator doors, plus the time for people to enter the"
      PRINT #2, "   elevator, plus the time for people to leave the elevator."
      PRINT #2, " Trip inefficiency- a multiplicative factor that accounts   "
      PRINT #2, "   for trips to empty floors and for trips to pick up only a"
      PRINT #2, "   few stragglers.                                                  "
       IF INFOPATH$ = "SCRN:" THEN
          PRINT ""
          INPUT "Press ENTER to continue....", junk$
          CLS
          PRINT ""
       END IF
      PRINT #2, " -------Concepts inherent to the computer program-----------"
      PRINT #2, " Range- A range is a set of floor names that is expanded by "
      PRINT #2, "   the program into a set of contiguous floor numbers. For  "
      PRINT #2, "   example, the range 2-10 is expanded into 2,3,4,5,6,...., "
      PRINT #2, "   9,10.                                                    "
      PRINT #2, " Typical- Used to save effort in the input. It is best shown"
      PRINT #2, "   by example. The typical inter floor height of a building "
      PRINT #2, "   typical inter floor height of a building is the most     "
      PRINT #2, "   commonly occurring height between floors (12 feet is an  "
      PRINT #2, "   example). There is a typical inter floor height, a       "
      PRINT #2, "   typical number of people on a floor, and a typical       "
      PRINT #2, "   elevator usage percent.                                  "
     
      END IF
     
      IF INFOPATH$ = "SCRN:" THEN PRINT "": PRINT "": PRINT ""


 '      READ IN THE TITLE OF THE CURRENT RUN.
      PRINT "Enter the title of this run. "
      LINE INPUT TITLE$



 '      ENTER VALUE INDICATING WHETHER METRIC OR ENGLISH UNITS ARE DESIRED.
      DO
         PRINT ""
         INPUT "Enter 1 for SI units or 2 for English units: ", UNITS
         IF UNITS <> 1 AND UNITS <> 2 THEN
            PRINT "  ***INVALID UNIT INDICATOR."
         END IF
      LOOP UNTIL UNITS = 1 OR UNITS = 2



 '      READ IN THE LINE OF FLOOR NAMES. THE LINE IS EXAMINED BY THE PROGRAM
 '      AND, IF ANY ERRORS ARE DISCOVERED, THE USER MUST REENTER THE LINE.
 '      IF NO ERRORS ARE FOUND, THE PROGRAM WILL USE THE FLOOR NAME LINE
 '      TO CREATE THE INDIVIDUAL FLOOR NAMES. THE HEIGHTS SUBROUTINE IS THEN
 '      CALLED TO READ IN THE TYPICAL FLOOR HEIGHT, ANY HEIGHT EXCEPTIONS,
 '      AND THEN TO COMPUTE THE ELEVATIONS OF EACH FLOOR.

      DO
         PRINT ""
         PRINT "Enter floors that the elevators serve (for example- B G 1-6)"
         LINE INPUT FLOORS$
         CALL HEIGHTS
      LOOP UNTIL KILLEXP = 0


 '      THE USER IS NOW PROMPTED BY THE PROGRAM TO KEY IN THE EXIT (DISCHARGE)
 '      FLOOR NAME. IF THE NAME IS NOT FOUND IN THE LIST OF FLOOR NAMES, AN
 '      ERROR MESSAGE APPEARS AND THE USER MUST RETYPE THE EXIT FLOOR NAME.
      DO
         PRINT ""
         INPUT "Discharge floor"; EXITNAME$
         EXITFLR = 0
         FOR I = 1 TO TOTFLRS
            IF EXITNAME$ = FLRNAMES$(I) THEN
               EXITFLR = I
               EXIT FOR
            END IF
         NEXT I
         IF EXITFLR = 0 THEN
            PRINT ""
            PRINT "       FLOOR NAME "; EXITNAME$; " NOT FOUND."
            PRINT "         VALID NAMES- "; FLOORS$
         END IF
      LOOP UNTIL EXITFLR <> 0


 '      THE EXIT DELAY TIME MUST NOW BE INPUT. IF IT IS NOT WITHIN A CERTAIN
 '      RANGE, THE PROGRAM PROMPTS THE USER TO RETYPE IT.
      DO
         PRINT ""
         INPUT "Time to outside after leaving elevator (s)"; EXITDELAY
         IF 0# > EXITDELAY OR EXITDELAY > 10000# THEN
            PRINT " *****TIME TO OUTSIDE IS OUT OF RANGE."
         END IF
      LOOP UNTIL EXITDELAY >= 0# AND EXITDELAY <= 10000#


 '      THE TRIP INEFFICIENCY FACTOR IS NOW ENTERED.
      DO
         PRINT ""
         INPUT "Trip inefficiency factor (for example .1)?   ", TRIPINEFF
         IF 0# > TRIPINEFF OR TRIPINEFF > 1# THEN
            PRINT " *****TRIP INEFFICIENCY FACTOR IS OUT OF RANGE."
         END IF
      LOOP UNTIL TRIPINEFF >= 0# AND TRIPINEFF <= 1#


 '      THE TOTAL NUMBER OF ELEVATOR CARS IN THE GROUP IS NOW INPUT.
     DO
        PRINT ""
        INPUT "Number of elevator cars in the group?   ", ELCARS
        IF ELCARS <= 0# OR 100# < ELCARS THEN
           PRINT " *****TOTAL NUMBER OF ELEVATOR CARS IS OUT OF RANGE."
        END IF
     LOOP UNTIL ELCARS > 0# AND ELCARS <= 100#

 
 '      THE USER NOW ENTERS THE NORMAL OPERATING VELOCITY OF THE ELEVATOR
 '      CAR.
      DO
         PRINT ""
         IF UNITS = 1 THEN
            INPUT "Normal operating velocity of car (m/s)"; VMAXsi
            VMAX = VMAXsi * (1 / .3048#)
         ELSE
            INPUT "Normal operating velocity of car (fpm)"; VMAX
            VMAX = VMAX / 60
            VMAXsi = VMAX * .3048#
         END IF
         IF 0# >= VMAX OR 60000# < VMAX THEN
            PRINT " *****NORMAL CAR VELOCITY IS OUT OF RANGE."
         END IF
      LOOP UNTIL VMAX > 0# AND VMAX <= 60000#


 '      NOW THE RATE OF ACCELERATION OF THE ELEVATOR CAR IS INPUT.
      DO
         PRINT ""
         IF UNITS = 1 THEN
            INPUT "Car acceleration (m/s**2)"; Asi
            A = Asi * (1 / .3048#)
         ELSE
            INPUT "Car Acceleration (ft/s**2)"; A
            Asi = A * .3048#
         END IF
         IF 0# >= A OR 1000# < A THEN
            PRINT " *****CAR ACCELERATION RATE IS OUT OF RANGE."
         END IF
      LOOP UNTIL 0# < A AND A <= 1000#


 '      NEXT, ENTER THE DESIRED FULL LOAD FOR THE ELEVATOR CAR. IT MUST BE
 '      INTEGER.
      DO
         PRINT ""
         FLAG = 0
         INPUT "Elevator Full Load (people)"; FULLOAD
         IF 0# >= FULLOAD OR 50# < FULLOAD THEN
            PRINT " *****ELEVATOR FULL LOAD VALUE IS OUT OF RANGE."
            FLAG = 1
         END IF
         IF INT(FULLOAD) <> FULLOAD THEN
            PRINT " *****ELEVATOR FULL LOAD VALUE MUST BE AN INTEGER."
            FLAG = 1
         END IF
      LOOP UNTIL FLAG = 0


 '      THE TIME REQUIRED TO OPEN AND CLOSE THE ELEVATOR CAR DOORS IS NOW
 '      ENTERED.
      DO
         PRINT ""
         PRINT "                   ------ MENU OF DOOR TYPES ------  "
         PRINT STRING$(69, "-")
         PRINT " Door type" + STRING$(16, " ");
         PRINT " Door width   Time to Open   Door Transfer"
         PRINT STRING$(39, " ") + " and Close, s    Inefficiency"
         PRINT STRING$(69, "-")
         FOR I = 1 TO 15
            PRINT DOORTYPES$(I)
         NEXT I
         PRINT "     ***Pick one of the door choices A - M.  "
         INPUT "         If you wish to specify another type, enter N.   ", R$
         R$ = UCASE$(R$)
         IF LEN(R$) = 1 THEN
            DOORCHOICE = ASC(R$) - 64
            IF DOORCHOICE < 1 OR DOORCHOICE > 14 THEN
               PRINT ""
               PRINT " *****DOOR CHOICE INVALID."
            ELSEIF DOORCHOICE = 14 THEN
               PRINT ""
               PRINT "     *** ANOTHER DOOR TYPE SPECIFIED***"
               PRINT ""
               INPUT "     New doortime value (s)?  ", Doortime(14)
               DO
                  PRINT ""
                  INPUT "     New door inefficiency value?  ", DOORINEFF(14)
                  MM = DOORINEFF(14)
                  IF MM < 0# OR MM > 1# THEN
                     PRINT ""
                     PRINT "     ***Door inefficiency value is out of range."
                  END IF
               LOOP UNTIL MM >= 0# AND MM <= 1#
            END IF
         ELSE
            PRINT ""
            PRINT " *****DOOR CHOICE CONTAINS MORE THAN ONE CHARACTER."
         END IF
      LOOP UNTIL LEN(R$) = 1 AND DOORCHOICE >= 1 AND DOORCHOICE <= 14
     

 '      THE OTHER TRANSFER INEFFICIENCY FACTOR IS NOW INPUT.
      DO
         PRINT ""
         INPUT "Other transfer inefficiency?   ", OTHERTRANSIN
         IF OTHERTRANSIN < 0# OR OTHERTRANSIN > 1# THEN
            PRINT " *****OTHER TRANSFER INEFFICIENCY IS OUT OF RANGE."
         END IF
      LOOP UNTIL 0# <= OTHERTRANSIN AND OTHERTRANSIN <= 1#


 '      THE DOORTIME AND TOTAL TRANSFER INEFFICIENCY ARE NOW COMPUTED.
      DRTIME = Doortime(DOORCHOICE)
      TOTINEFF = BASTRANSIN + DOORINEFF(DOORCHOICE) + OTHERTRANSIN


 '      THE STANDING TIME REQUIRED TO FULLY LOAD AN ELEVATOR CAR IS NOW
 '      COMPUTED AND STORED.
      STNDTMEFULL = CALCSTAND#(FULLOAD#)


 '      NEXT, THE ONE WAY TRIP TIMES ARE COMPUTED FOR EACH FLOOR.
      CALL TRIPTIME
      

 '      NOW THE START UP TIME IS COMPUTED OR INPUT. THIS IS THE TIME REQUIRED
 '      TO PREPARE FOR THE ACTUAL EGRESS BY ELEVATOR AFTER THE SIGNAL FOR
 '      EVACUATION IS GIVEN.
      TOPTOEXIT = ELEVATION(TOTFLRS) - ELEVATION(EXITFLR)
      BOTTOEXIT = ELEVATION(EXITFLR) - ELEVATION(1)
      IF TOPTOEXIT > BOTTOEXIT THEN DISTANTFLR = TOTFLRS ELSE DISTANTFLR = 1
      IF FULLOAD > 6 THEN OVER6FACT = .6 * (FULLOAD - 6)
      UNLOADTIME = 4# + OVER6FACT
      STARTUPTIME = (1 + TOTINEFF) * (DRTIME + UNLOADTIME) + TIMES(DISTANTFLR)
      PRINT "The startup time for automatically operated elevators ";
      PRINT USING "is ####.## seconds."; STARTUPTIME
      INPUT " Do you want to enter another value (Y or N)?   ", NEWFLAG$
      NEWFLAG$ = UCASE$(NEWFLAG$)
      IF NEWFLAG$ = "Y" THEN
         DO
            INPUT "  ?  ", STARTUPTIME
            IF STARTUPTIME < 0 OR STARTUPTIME > 10000 THEN
               PRINT ""
               PRINT "    VALUE FOR START UP TIME IS NOT IN CORRECT RANGE. "
            END IF
            PRINT ""
         LOOP UNTIL STARTUPTIME >= 0 AND STARTUPTIME <= 10000
      ELSE
         PRINT ""
      END IF
     
 
 '      THE TYPICAL NUMBER OF PEOPLE ASSIGNED TO EACH FLOOR MUST NOW BE
 '      ENTERED. IT MUST BE AN INTEGER.
      DO
         FLAG = 0
         INPUT "Typical Number of People per Floor"; PPLEFLR
         IF 0# >= PPLEFLR OR 100000# < PPLEFLR THEN
            PRINT " *****TYPICAL PEOPLE PER FLOOR VALUE IS OUT OF RANGE."
            FLAG = 1
         END IF
         IF INT(PPLEFLR) <> PPLEFLR THEN
            PRINT " *****TYPICAL PEOPLE PER FLOOR VALUE MUST BE AN INTEGER."
            FLAG = 1
         END IF
      LOOP UNTIL FLAG = 0
      FOR I = 1 TO TOTFLRS: people(I) = PPLEFLR: NEXT I

 '      NEXT, THE PEOPLE PER FLOOR EXCEPTIONS ARE INPUT. THESE OVERRIDE
 '      THE TYPICAL PEOPLE NUMBER.
      FOR I = 1 TO 1000
         PRINT "  People per floor exception:"
         PRINT "   Floor Range, people (enter END to stop)"
         LINE INPUT STORE$
         CALL PARSE(STORE$, NUMTOKS#)
         CALL CHECK(NUMTOKS#, 0#, 100000#, 2#)
         IF TOKENS$(1) = "STOP" THEN EXIT FOR
      NEXT I

 

 '      ***************************************************************
 '      * MAIN DO LOOP
 '      *     READS IN A NEW SET OF ELEVATOR USE PERCENTAGES. THIS LOOP
 '      *     IS RERUN UNTIL THE CURRENT INPUT VALUES TOGETHER WITH THE
 '      *     NEW PERCENTAGE VALUES PRODUCE SATISFACTORY RESULTS.
 '      ***************************************************************

      DO


 '      THE TYPICAL ELEVATOR USAGE IS NOW KEYED IN. THIS IS THE PERCENT OF
 '      PEOPLE ON EACH FLOOR WHO USE ELEVATOR CARS TO EGRESS. IT MUST BE
 '      A VALUE BETWEEN 0 AND 100.
      DO
         PRINT ""
         INPUT "Percent of people on typical floor using elevator"; TYPPERCNT
         IF TYPPERCNT < 0# OR TYPPERCNT > 100# THEN
            PRINT " *****ELEVATOR USAGE PERCENT IS OUT OF RANGE."
         END IF
      LOOP UNTIL 0# <= TYPPERCNT AND TYPPERCNT <= 100#
      FOR I = 1 TO TOTFLRS: PERCNT(I) = TYPPERCNT: NEXT I

 '      NEXT, EXCEPTIONS TO THE TYPICAL ELEVATOR USAGE PERCENT ARE ENTERED.
 '      THESE OVERRIDE THE TYPICAL PERCENT.
      FOR I = 1 TO 1000
         PRINT "  Percent usage exceptions:"
         PRINT "    Floor Range, Percent (enter END to stop)"
         LINE INPUT STORE$
         CALL PARSE(STORE$, NUMTOKS#)
         CALL CHECK(NUMTOKS#, 0#, 100#, 3#)
         IF TOKENS$(1) = "STOP" THEN EXIT FOR
      NEXT I
     

 '      *********************************
 '      * MAIN OUTPUT LOOP
 '      *********************************

 '       FIRST, CLEAR THE SCREEN. NEXT, EXECUTE THE OUTPUT LOOP UNTIL THE
 '       VALUE OF RERUNOUTPUT$ IS Y. THE VALUE OF THIS VARIABLE IS 1 ONLY WHEN
 '       THE USER WANTS TO PRINT OR STORE THE OUTPUT RESULTS.
      CLS
      
     
      DO


 '      IMPORTANT PROGRAM PARAMETERS ARE NOW PRINTED. THESE APPEAR BEFORE
 '      THE TABLE OF FLOOR INFORMATION.
      PRINT #1, ""
      PRINT #1, TITLE$
      PRINT #1, ""
      PRINT #1, USING "People per floor is ######.      "; PPLEFLR
      PRINT #1, USING "Distance between floors is  ####.## m"; TYPDIFsi;
      PRINT #1, USING "  or ####.## ft.           "; TYPDIF
      PRINT #1, USING "Elevator usage percent is ###.###%"; TYPPERCNT
      PRINT #1, USING "Normal car velocity is      ###.## m/s "; VMAXsi;
      PRINT #1, USING "or ####.## fpm."; VMAX * 60
      PRINT #1, USING "Car acceleration is           ##.## m/s2"; Asi;
      PRINT #1, USING " or ##.## ft/s2."; A
      PRINT #1, USING "Car full load is ### people."; FULLOAD
      PRINT #1, USING "Full load standing time is ###.## s."; STNDTMEFULL
      PRINT #1, USING "Other transfer inefficiency is #.####"; OTHERTRANSIN
      PRINT #1, USING "Trip inefficiency is #.###  "; TRIPINEFF
      IF DOORCHOICE <> 14 THEN
         PRINT #1, "Door type:"; DOORPTYPES$(DOORCHOICE)
         PRINT #1, USING "   Doortime s ###.###   "; Doortime(DOORCHOICE);
         PRINT #1, USING " Door inefficiency  ###.### "; DOORINEFF(DOORCHOICE)
      ELSE
         PRINT #1, "Door type:  OTHER  "
         PRINT #1, "   Doortime s ";
         PRINT #1, USING "###.###    Door inefficiency "; Doortime(14);
         PRINT #1, USING "#.### "; DOORINEFF(14)
      END IF
      PRINT #1, ""
      PRINT #1, STRING$(78, "-")


 '      NOW THE VALUES FOR THE OUTPUT TABLE ARE COMPUTED AND PRINTED. THE
 '      FIRST ROW CORRESPONDS TO THE TOP FLOOR OF THE BUILDING, THE NEXT
 '      ROW TO THE FLOOR BENEATH THE TOP FLOOR, ETC.
      PRINT #1, MTITLE1$
      PRINT #1, MTITLE2$
      PRINT #1, MTITLE3$
      PRINT #1, STRING$(78, "-")
      TOTTIME = 0#
      FOR I = TOTFLRS TO 1 STEP -1
         PPLEI = people(I) * PERCNT(I) * .01#
         IF INT(PPLEI) <> PPLEI THEN PPLEI = INT(PPLEI + .5#) + 1
         TRIPS = PPLEI / FULLOAD
         IF INT(TRIPS) <> TRIPS THEN TRIPS = CINT(TRIPS + .5#)
         NTRIPSFULL = INT(PPLEI / FULLOAD)
         NPPLELAST = PPLEI - NTRIPSFULL * FULLOAD
         RNDTIMES(I) = 2# * TIMES(I)
         IF NTRIPSFULL = 0# THEN
            TIMELAST = RNDTIMES(I) + CALCSTAND(NPPLELAST#)
            RNDTIMES(I) = TIMELAST
            TIMEFULL = 0#
         ELSEIF NTRIPSFULL > 0# AND NPPLELAST = 0# THEN
            TIMELAST = 0#
            RNDTIMES(I) = RNDTIMES(I) + STNDTMEFULL
            TIMEFULL = NTRIPSFULL * RNDTIMES(I)
         ELSEIF NTRIPSFULL > 0# AND NPPLELAST > 0# THEN
            TIMELAST = RNDTIMES(I) + CALCSTAND(NPPLELAST#)
            RNDTIMES(I) = RNDTIMES(I) + STNDTMEFULL
            TIMEFULL = NTRIPSFULL * RNDTIMES(I)
         END IF
         IF PPLEI = 0# THEN
            EXITIMEFLRI = 0#
         ELSE
            EXITIMEFLRI = TIMEFULL + TIMELAST
         END IF
         PRINT #1, USING "\      \ "; FLRNAMES$(I);
         METELEV = ELEVATION(I) * .3048#
         PRINT #1, USING "####.#  ####.#   "; METELEV; ELEVATION(I);
         IF I = EXITFLR THEN
            PRINT #1, " "
         ELSE
            PRINT #1, USING "####.#   ####.#   "; TIMES(I); RNDTIMES(I);
            PRINT #1, USING "######   ###.#    "; people(I); PERCNT(I);
            PRINT #1, USING "####   #####.#"; TRIPS; EXITIMEFLRI
            TOTTIME = TOTTIME + EXITIMEFLRI
         END IF
      NEXT I
      PRINT #1, STRING$(78, "-")
      EVACTIME = (TOTTIME / ELCARS) * (1# + TRIPINEFF) + EXITDELAY
      EVACTIME = EVACTIME + STARTUPTIME


 '      THE TOTAL BUILDING EVACUATION TIME NOW APPEARS.
      PRINT #1, STRING$(43, " ");
      PRINT #1, "Total round trip time=";
      PRINT #1, USING "  #######.#"; TOTTIME
      PRINT #1, STRING$(51, " ");
      PRINT #1, "Start up time=";
      PRINT #1, USING "     ####.#"; STARTUPTIME
      PRINT #1, STRING$(11, " ");
      PRINT #1, "Time to get to the outside after leaving the elevator=";
      PRINT #1, USING "      ###.#"; EXITDELAY
      PRINT #1, STRING$(30, " ");
      PRINT #1, USING "Evacuation time using ## elevators="; ELCARS;
      PRINT #1, USING "  #######.#"; EVACTIME
      PRINT #1, STRING$(53, " ");
      PRINT #1, USING "(or  ######.# minutes)"; EVACTIME / 60



 '      DETERMINE IF THE PROGRAM USER WISHES TO SAVE THE OUTPUT SHOWN ON THE
 '      SCREEN. IF THIS IS THE CASE, THE OUTPUT LOOP IS RERUN. THE USER MAY
 '      PRINT THE OUTPUT, SEND IT TO A FILE, OR DO BOTH.
      PRINT ""
      IF PATHSEL$ = "SCRN:" THEN
         INPUT "Do you want to save the output (Y or N)?  ", RERUNOUTPUT$
      ELSE
         INPUT "Do you want to save the output again (Y or N)?  ", RERUNOUTPUT$
      END IF
      RERUNOUTPUT$ = UCASE$(RERUNOUTPUT$)
      IF RERUNOUTPUT$ = "Y" THEN
         DO
             OPTIONERROR$ = "NO"
             PRINT ""
             PRINT " The options for saving the output now follow.         "
             PRINT " Enter a number corresponding to one of the following: "
             PRINT "    1.  Send the output to the printer.                "
             PRINT "    2.  Store the output in a file.                    "
             PRINT ""
             INPUT "Output option?  ", OUTPUTOPTION
             IF OUTPUTOPTION < 1 OR OUTPUTOPTION > 2 THEN
                PRINT ""
                PRINT "  *** Incorrect option number. Must be 1 OR 2. ***"
                OPTIONERROR$ = "YES"
             END IF
             IF OUTPUTOPTION = 1 THEN
                PATHSEL$ = "PRN"
                CLOSE #1
                OPEN PATHSEL$ FOR OUTPUT AS #1
             ELSEIF OUTPUTOPTION = 2 THEN
                PRINT ""
                INPUT "   What is the filename?  ", PATHSEL$
                PATHSEL$ = UCASE$(PATHSEL$)
                CLOSE #1
                OPEN PATHSEL$ FOR OUTPUT AS #1
             END IF
          LOOP UNTIL OPTIONERROR$ = "NO"
       ELSE
          PATHSEL$ = "SCRN:"
          CLOSE #1
          OPEN PATHSEL$ FOR OUTPUT AS #1
          RERUNOUTPUT$ = "N"
       END IF
     

 '      *************************
 '      * END OF MAIN OUTPUT LOOP
 '      *************************
      LOOP UNTIL RERUNOUTPUT$ = "N"


 '      DETERMINE IF THE USER WISHES TO RERUN THE PROGRAM WITH NEW ELEVATOR
 '      USAGE PERCENTAGES.
      PRINT ""
      INPUT "Rerun program with new usage percentages (Y or N)?  ", FINPCT$
      FINPCT$ = UCASE$(FINPCT$)
      IF FINPCT$ = "Y" AND PATHSEL$ <> "SCRN:" THEN
         CLOSE #1
         OPEN "SCRN:" FOR OUTPUT AS #1
      END IF
      IF FINPCT$ = "Y" THEN RERUNPERCNT = 1
      IF FINPCT$ <> "Y" THEN RERUNPERCNT = 0


 '   **************************
 '   *** END OF MAIN DO LOOP
 '   **************************

      LOOP UNTIL RERUNPERCNT = 0


 ' *********************************
 ' *** END OF PROGRAM EXECUTION LOOP
 ' *********************************

      PRINT ""
      INPUT "Do you wish to rerun the entire program (Y or N)?  ", RERUNPROG$
      RERUNPROG$ = UCASE$(RERUNPROG$)
      CLOSE #1
   
    LOOP UNTIL RERUNPROG$ = "N"


      END

 '---------------------------------------------------------------------------
 '   F U N C T I O N   C A L C S T A N D
 '---------------------------------------------------------------------------
 '          THIS FUNCTION COMPUTES THE STANDING TIME PORTION OF AN ELEVATOR'S
 '    TRIP. IT IS DEFINED AS FOLLOWS:
 ' STANDING TIME = (1 + TOTINEFF) * (2*DOORTIME+LOADING TIME+UNLOADING TIME)
 '---------------------------------------------------------------------------
 '            LOCAL VARIABLES:
 '      LOADTIME    TIME (s) TO LOAD AN ELEVATOR CAR.
 '      PEOP#       NUMBER OF PEOPLE FOR WHICH THE STANDING TIME IS COMPUTED.
 '      OVER6FACT   EXTRA TIME REQUIRED WHEN PEOP# IS OVER 6.
 '      UNLOADTIME  TIME (s) TO UNLOAD AN ELEVATOR CAR AT THE EXIT FLOOR.
 '            GLOBAL VARIABLES:
 '      DRTIME      TIME (s) REQUIRED FOR THE OPENING AND CLOSING OF THE
 '                   ELEVATOR CAR DOOR.
 '      TOTINEFF    TOTAL TRANSFER INEFFICIENCY.
 '---------------------------------------------------------------------------
      FUNCTION CALCSTAND# (PEOP#)

      OVER6FACT = 0
      IF PEOP# > 6# THEN OVER6FACT = .6# * (PEOP# - 6)
      IF PEOP# <= 2# THEN LOADTIME = 2# ELSE LOADTIME = PEOP#
      UNLOADTIME = 4# + OVER6FACT
      
      CALCSTAND# = (1# + TOTINEFF) * (2# * DRTIME + LOADTIME + UNLOADTIME)

      END FUNCTION

 '---------------------------------------------------------------------------
 '   S U B R O U T I N E   C H E C K
 '---------------------------------------------------------------------------
 '                   THIS SUBROUTINE CHECKS HEIGHT, PEOPLE PER FLOOR, AND
 '            ELEVATOR USAGE PER FLOOR EXCEPTIONS. THESE EXCEPTIONS ARE
 '            ENTERED IN THE FORM nm,val , WHERE nm IS A FLOOR NAME AND val
 '            IS AN EXCEPTION VALUE. THE STRING VALUE "END" STOPS EXCEPTION
 '            INPUT FOR EACH OF THE THREE CATEGORIES OF EXCEPTIONS.
 '---------------------------------------------------------------------------
 '                    ARGUMENTS:
 '      NUMTOK#    NUMBER OF STRINGS FOUND ON THE CURRENT LINE BY THE PARSING
 '                  ROUTINE. THIS IS PASSED TO CHECK.
 '      LLIMIT#    LOWER LIMIT FOR THE SECOND ITEM ON THE LINE.
 '      UPLIMIT#   UPPER LIMIT FOR THE SECOND ITEM.
 '      ARRPTR#    EITHER 1, 2, OR 3. IT DETERMINES THE ARRAY TO WHICH THE
 '                  SECOND ITEM IS PASSED.
 '---------------------------------------------------------------------------
      SUB CHECK (NUMTOK#, LLIMIT#, UPLIMIT#, ARRPTR#)

      IF NUMTOK# = 0 THEN
         PRINT "      BLANK LINE HAS BEEN ENTERED OR GENERATED."
         EXIT SUB
      END IF

 '       IF THE INFORMATION ON THE LINE IS SUCH THAT NO FURTHER ANALYSIS
 '       IS POSSIBLE, EXIT THE SUBROUTINE. IF THERE IS ONE ITEM, AND IT IS
 '       THE CORRECT END INDICATOR, SET A FLAG TO STOP SUBROUTINE CALLS
 '       FOR THIS TYPE OF EXCEPTION.
      IF NUMTOK# > 2 THEN
         PRINT "      MORE THAN TWO ITEMS ON LINE."
         EXIT SUB
      ELSEIF NUMTOK# = 2 AND UCASE$(TOKENS$(1)) = "END" THEN
         PRINT "      TWO ITEMS ON LINE, BUT FIRST ONE IS THE END INDICATOR."
         EXIT SUB
      ELSEIF NUMTOK# = 1 AND UCASE$(TOKENS$(1)) = "END" THEN
         TOKENS$(1) = "STOP"
         EXIT SUB
      ELSEIF NUMTOK# = 1 AND UCASE$(TOKENS$(1)) <> "END" THEN
         PRINT "      ONE ITEM ON LINE, NOT CORRECT END INDICATOR."
         EXIT SUB
      END IF

 '       THE FIRST ITEM ON THE LINE SHOULD BE THE FLOOR NAME OR RANGE. CHECK
 '       TO SEE IF IT MATCHES A NAME THAT HAS BEEN PREVIOUSLY SPECIFIED.
 '       THE RANGE EXPANSION SUBROUTINE IS CALLED TO CHECK THE FLOOR RANGE
 '       SPECIFIED. IF THE VALUE OF EXPECP IS 0, THE RANGE WAS EXPANDED.
 '       IF 1, THE RANGE COULD NOT BE EXPANDED DUE TO CERTAIN ERRORS FOUND
 '       IN ITS COMPONENTS. IF IT IS 2, THE FLOOR NAME IS A SINGLE ITEM.
      CALL RANGEEXP(TOKENS$(1), FLRSUB1, FLRSUB2, FLREXCP1$, FLREXCP2$, EXPECP)
     
 '       PRINT OUT AN ERROR MESSAGE IF ONE OR MORE OF THE NAMES IN THE FLOOR
 '       RANGE COULD NOT BE FOUND IN THE FLOOR NAME TABLE.
      IF FLRSUB1 = 0 AND EXPECP = 0 THEN
         PRINT "     FLOOR NAME "; FLREXCP1$; " NOT FOUND."
         PRINT "       VALID NAMES- "; FLOORS$
      END IF
      IF FLRSUB2 = 0 AND EXPECP = 0 THEN
         PRINT "     SECOND FLOOR NAME "; FLREXCP2$; "  NOT FOUND."
         PRINT "       VALID NAMES- "; FLOORS$
      END IF
      IF FLRSUB1 = 0 AND EXPECP = 2 THEN
         PRINT "     FLOOR NAME "; FLREXCP1$; " NOT FOUND."
         PRINT "       VALID NAMES- "; FLOORS$
      END IF
     
     
      ERRFLAG = 0

 '       DETERMINE IF THE SECOND ITEM IS A VALID NUMBER.
      FOR I = 1 TO LEN(TOKENS$(2))
         PTR$ = MID$(TOKENS$(2), I, 1)
         IF INSTR(".0123456789", PTR$) = 0 THEN
            PRINT "      INVALID NUMBER AFTER FLOOR NAME."
            ERRFLAG = 1
            EXIT FOR
         END IF
         IF INSTR(".", PTR$) = 1 AND ARRPTR# = 2# THEN
            PRINT "      NO DECIMAL POINTS ALLOWED IN PEOPLE/FLR NUMBER."
            ERRFLAG = 1
         END IF
      NEXT I

 '       IF THE ITEM IS A VALID NUMBER, DETERMINE IF IT LIES BETWEEN THE
 '       LOWER AND UPPER LIMITS.
      IF ERRFLAG = 0 THEN
         NUMB = VAL(TOKENS$(2))
         IF NUMB < LLIMIT# OR NUMB > UPLIMIT# THEN
            PRINT "      NUMBER AFTER FLOOR NAME IS OUT OF RANGE."
            ERRFLAG = 1
         END IF
      END IF

 '       IF ANY ERRORS HAVE BEEN DETECTED, LEAVE THE SUBROUTINE.
      IF ERRFLAG = 1 THEN EXIT SUB

 '       SET THE APPROPRIATE ARRAY ROW(S) TO THE VALUE OF THE EXCEPTION.
      FOR I = FLRSUB1 TO FLRSUB2
         IF ARRPTR# = 1# AND UNITS = 1 THEN HGTDIF(I) = NUMB * (1 / .3048#)
         IF ARRPTR# = 1# AND UNITS = 2 THEN HGTDIF(I) = NUMB
         IF ARRPTR# = 2# THEN people(I) = NUMB
         IF ARRPTR# = 3# THEN PERCNT(I) = NUMB
      NEXT I
     
    
      END SUB

 '---------------------------------------------------------------------------
 '     S U B R O U T I N E   H E I G H T S
 '---------------------------------------------------------------------------
 '            THIS SUBROUTINE FIRST CALLS THE PARSING ROUTINE TO ISOLATE ALL
 '      FLOOR NAMES IN THE FLOOR NAME LINE INPUT BY THE USER. IT CHECKS FOR
 '      SITUATIONS WHICH MAKE FURTHER ANALYSIS IMPOSSIBLE. IT THEN EXAMINES
 '      ALL FLOOR NAMES WHICH CONTAIN THE CHARACTER "-". THESE ARE TERMED
 '      RANGES (such as 2-10 is the range of floors from 2 through 10). ANY
 '      RANGES FOUND ARE EXAMINED CAREFULLY FOR POSSIBLE AMBIGUITIES,
 '      INVALID NUMBERS, ETC. IF NO ERRORS ARE DETECTED, ANY RANGES THAT HAVE
 '      BEEN FOUND ARE EXPANDED. NEXT, THE SUBROUTINE PROMPTS THE USER FOR
 '      HEIGHT EXCEPTIONS. AFTER THESE HAVE BEEN ENTERED THE ELEVATIONS ARE
 '      COMPUTED AND THE SUBROUTINE IS EXITTED.
 '---------------------------------------------------------------------------
 '                       LOCAL VARIABLES, AND GLOBAL VARIABLES CHANGED HERE:
 '       CURTOK$      CONTAINS STRING VALUE BEING TESTED AS A POSSIBLE RANGE.
 '       ELEMENT      NUMBER OF SUBSTRINGS FOUND ON THE FLOOR NAME LINE.
 '       ELEVATION(I) ELEVATION OF Ith FLOOR ABOVE LOWEST FLOOR.
 '       FLOORS$      INITIALLY CONTAINS THE FLOOR NAME LINE INPUT BY THE
 '                     USER, THEN IT IS COMPRESSED TO REMOVE EXTRA BLANKS.
 '       FLRNAMES$(I) ARRAY CONTAINING THE FLOOR NAMES AFTER RANGE EXPANSION.
 '       HGTDIF(I)    ARRAY WHOSE Ith ROW IS THE HEIGHT DIFFERENCE BETWEEN
 '                     FLOOR I AND FLOOR I+1, WHERE THE LOWEST FLOOR IS 1.
 '       KILLEXP      IF THIS IS SET TO 1, THE MAIN PROGRAM KEEPS ON PROMPTING
 '                     THE USER FOR A NEW FLOOR NAME LINE.
 '       PTR          COUNTER USED WHEN FLRNAMES$ ARRAY IS CREATED.
 '       RANGE1$(I)   CONTAINS THE FIRST RANGE VALUE OF Ith RANGE FOUND. FOR
 '                     EXAMPLE, IF THE 4th RANGE FOUND IS 7-10, RANGE1$(4)="7"
 '       RANGE2$(I)   SIMILAR TO RANGE1$(I), BUT STORES SECOND RANGE VALUES.
 '       RANGEMK      LOCATION OF THE CHARACTER "-" IN A SUBSTRING. IF IT IS
 '                     NOT 0, THE SUBSTRING IS ASSUMED TO BE A RANGE.
 '       STORE$       CONTAINS THE HEIGHT EXCEPTION LINE.
 '       TOTFLRS      SET EQUAL TO THE TOTAL NUMBER OF FLOORS FOUND AFTER
 '                     EXPANSION.
 '       TYPDIF       TYPICAL FLOOR TO FLOOR HEIGHT. CAN BE OVERRIDDEN BY
 '                     HEIGHT EXCEPTIONS FOR INDIVIDUAL FLOORS.
 '---------------------------------------------------------------------------
 '
      SUB HEIGHTS

      DIM RANGE1$(200), RANGE2$(200)

      KILLEXP = 0

 '       PARSE THE LINE OF FLOOR NAMES.
      CALL PARSE(FLOORS$, NUMTOK#)
      ELEMENT = NUMTOK#

 '       IF NO ITEMS ARE FOUND ON THE FLOOR NAME LINE, PRINT ERROR MESSAGE
 '       AND EXIT SUBROUTINE.
      IF ELEMENT = 0 THEN
         PRINT ""
         PRINT " BLANK LINE HAS BEEN ENTERED OR GENERATED."
         KILLEXP = 1
         EXIT SUB
      END IF

 '       IF ONE ITEM IS FOUND, AND IT IS NOT A RANGE, THEN ONLY ONE FLOOR
 '       NAME HAS BEEN INPUT.
      IF ELEMENT = 1 AND INSTR(TOKENS$(1), "-") = 0 THEN
         PRINT ""
         PRINT " ONLY ONE FLOOR IS GIVEN."
         KILLEXP = 1
         EXIT SUB
      END IF

      FLOORS$ = ""

 '       CHECK EACH SUBSTRING TO SEE IF IT IS A RANGE. IF SO, TEST FOR COMMON
 '       ERROR SITUATIONS.
      PRINT ""
     
      FOR I = 1 TO ELEMENT
         CURTOK$ = TOKENS$(I)
         CALL RANGEEXP(CURTOK$, SUBS1, SUBS2, FLRVAL1$, FLRVAL2$, EXPRANGE)
         IF EXPRANGE = 1 THEN
            KILLEXP = 1
         ELSEIF EXPRANGE = 2 THEN
            RANGE1$(I) = ""
            FLOORS$ = FLOORS$ + " " + CURTOK$
         ELSEIF EXPRANGE = 0 THEN
            RANGE1$(I) = FLRVAL1$
            RANGE2$(I) = FLRVAL2$
            FLOORS$ = FLOORS$ + " " + CURTOK$
         END IF
      NEXT I

      
 '       IF ERRORS HAVE BEEN DETECTED, EXIT SUBROUTINE
      IF KILLEXP = 1 THEN EXIT SUB

 '       IF NO ERRORS HAVE BEEN FOUND, PERFORM RANGE EXPANSION(IF NECESSARY),
 '       AND INITIALIZE THE FLRNAMES$ ARRAY.
      PTR = 1
      FOR I = 1 TO ELEMENT
         IF RANGE1$(I) = "" THEN
            FLRNAMES$(PTR) = TOKENS$(I)
            PTR = PTR + 1
         ELSE
            FOR J = VAL(RANGE1$(I)) TO VAL(RANGE2$(I))
               FLRNAMES$(PTR) = STR$(J)
               FLRNAMES$(PTR) = LTRIM$(FLRNAMES$(PTR))
               PTR = PTR + 1
            NEXT J
         END IF
      NEXT I

     
 '       READ IN THE TYPICAL FLOOR TO FLOOR HEIGHT AND THEN THE HEIGHT
 '       EXCEPTIONS.
      TOTFLRS = PTR - 1
      IF UNITS = 1 THEN
         INPUT "Typical floor to floor height (m)"; TYPDIFsi
         TYPDIF = TYPDIFsi * (1 / .3048#)
      ELSE
         INPUT "Typical floor to floor height (ft)"; TYPDIF
         TYPDIFsi = TYPDIF * .3048#
      END IF
      FOR K = 1 TO TOTFLRS: HGTDIF(K) = TYPDIF: NEXT K
      FOR I = 1 TO 1000
         PRINT "   Height exceptions:"
         IF UNITS = 1 THEN
            PRINT "    Floor range, height(m)  (enter END to stop)"
         END IF
         IF UNITS = 2 THEN
            PRINT "    Floor range, height(ft)  (enter END to stop)"
         END IF
         LINE INPUT STORE$
         CALL PARSE(STORE$, NUMTOK#)
         CALL CHECK(NUMTOK#, 0#, 10000#, 1#)
         IF TOKENS$(1) = "STOP" THEN EXIT FOR
      NEXT I

     
 '       COMPUTE THE ELEVATIONS OF EACH FLOOR, STARTING FROM THE LOWEST ONE.
      ELEVATION(1) = 0
      FOR I = 2 TO TOTFLRS + 1
         ELEVATION(I) = ELEVATION(I - 1) + HGTDIF(I - 1)
      NEXT I


      END SUB

 '---------------------------------------------------------------------------
 '         S U B R O U T I N E   P A R S E
 '---------------------------------------------------------------------------
 '               THIS SUBROUTINE IS PASSED THE STRING STORE$, CHANGES ANY
 '        COMMAS TO BLANKS, ISOLATES ALL SUBSTRINGS SEPARATED BY BLANKS
 '        WITHIN THE STRING, AND COUNTS THEM. THE ARGUMENT NUMTOK# IS SET TO
 '        THE COUNTED NUMBER. THE PARSING METHOD DESTROYS ALL SUBSTRINGS
 '        WITHIN STORE$ EXCEPT FOR THE RIGHTMOST ONE.
 '---------------------------------------------------------------------------
      SUB PARSE (STORE$, NUMTOK#)

      FOR COL = 1 TO LEN(STORE$)
         IF MID$(STORE$, COL, 1) = "," THEN MID$(STORE$, COL, 1) = " "
      NEXT COL
      STORE$ = RTRIM$(STORE$)
      FOR I = 1 TO 200
         STORE$ = LTRIM$(STORE$)
         NEXTBLNK = INSTR(STORE$, " ")
         IF NEXTBLNK = 0 THEN
            TOKENS$(I) = STORE$
            EXIT FOR
         END IF
         TOKENS$(I) = MID$(STORE$, 1, NEXTBLNK - 1)
         MID$(STORE$, 1, NEXTBLNK - 1) = STRING$(100, " ")
      NEXT I
      IF LEN(STORE$) <> 0 THEN NUMTOK# = I:  ELSE NUMTOK# = 0
     
      END SUB

 '---------------------------------------------------------------------------
 '      S U B R O U T I N E   R A N G E E X P
 '---------------------------------------------------------------------------
 '           THIS SUBROUTINE IS PASSED A FLOOR NAME OR FLOOR RANGE. IF IT IS
 '     PASSED A RANGE, IT CHECKS THE TWO PARTS OF THE RANGE FOR VARIOUS ERROR
 '     SITUATIONS, ISOLATES THE FIRST AND SECOND PART OF THE RANGE, AND
 '     FINDS THE LOCATIONS OF THE FLOOR NAMES WITHIN THE FLOOR NAME TABLE.
 '---------------------------------------------------------------------------
 '                          ARGUMENTS:
 ' EXPEXCP    AN OUTPUT PARAMETER. ITS VALUE IS 0 IF THE FLOOR ITEM IS A VALID
 '             RANGE, 1 IF IT IS AN INVALID RANGE, AND 2 IF THE FLOOR ITEM IS
 '             A SINGLE FLOOR NAME.
 ' FLREXCP1$  AN OUTPUT PARAMETER. THE VALUE OF THE FIRST ITEM IN THE RANGE,
 '             OR THE ONLY ITEM IF THERE IS NO RANGE.
 ' FLREXCP2$  AN OUTPUT PARAMETER. THE VALUE OF THE SECOND ITEM IN THE RANGE,
 '             OR THE ONLY ITEM IF THERE IS NO RANGE.
 ' FLRSTR$    THE CHARACTER STRING PASSED TO THIS SUBROUTINE.
 ' FLRSUB1    THE LOCATION OF THE FIRST FLOOR NAME WITHIN THE FLOOR NAME TABLE,
 '             OR 0 IF THE NAME IS NOT A VALID FLOOR NAME.
 ' FLRSUB2    THE LOCATION OF THE SECOND FLOOR NAME WITHIN THE FLOOR NAME
 '             TABLE, OR 0 IF THE NAME IS NOT A VALID FLOOR NAME.
 '---------------------------------------------------------------------------
 '                     IMPORTANT VARIABLES:
 ' CURTOK$     CONTAINS THE STRING PASSED TO THE SUBROUTINE.
 ' RANGEMK     THE LOCATION OF A DASH WITHIN THE FLOOR RANGE.
 ' TEMPRANGE1$ STORES THE FIRST PART OF THE RANGE.
 ' TEMPRANGE2$ STORES THE SECOND PART OF THE RANGE.
 ' --------------------------------------------------------------------------
 '
     SUB RANGEEXP (FLRSTR$, FLRSUB1, FLRSUB2, FLREXCP1$, FLREXCP2$, EXPEXCP)

 '       INITIALIZE SOME OF THE OUTPUT PARAMETERS.
      EXPEXCP = 0
      FLRSUB1 = 0
      FLRSUB2 = 0
      

 '       CHECK THE SUBSTRING TO SEE IF IT IS A RANGE. IF SO, TEST FOR COMMON
 '       ERROR SITUATIONS.
      IF FLRNAMES$(1) <> "" THEN PRINT ""
      CURTOK$ = FLRSTR$
      RANGEMK = INSTR(CURTOK$, "-")
      IF RANGEMK = 0 THEN
         TEMPRANGE1$ = ""
      ELSEIF RANGEMK = 1 OR RANGEMK = LEN(CURTOK$) THEN
         PRINT " MISPLACED DASH - NO RANGE EXPANSION PERFORMED. "; CURTOK$
         EXPEXCP = 1
      ELSEIF RANGEMK <> 0 THEN
         TEMPRANGE1$ = MID$(CURTOK$, 1, RANGEMK - 1)
         TEMPRANGE2$ = MID$(CURTOK$, RANGEMK + 1, LEN(CURTOK$))
         FOR J = 1 TO LEN(TEMPRANGE1$)
            IF INSTR("0123456789", MID$(TEMPRANGE1$, J, 1)) = 0 THEN
               PRINT " INCORRECT 1ST RANGE IN  "; CURTOK$; ", POS "; J
               EXPEXCP = 1
            END IF
         NEXT J
         FOR J = 1 TO LEN(TEMPRANGE2$)
            IF INSTR("0123456789", MID$(TEMPRANGE2$, J, 1)) = 0 THEN
               PRINT " INCORRECT 2ND RANGE IN  "; CURTOK$; ", POS "; J
               EXPEXCP = 1
            END IF
         NEXT J
         IF EXPEXCP = 0 AND VAL(TEMPRANGE1$) >= VAL(TEMPRANGE2$) THEN
            PRINT " 1ST RANGE IS NOT LESS THAN 2ND RANGE IN  "; CURTOK$
            EXPEXCP = 1
         END IF
      END IF
     
     
 '       IF ERRORS HAVE BEEN DETECTED, EXIT SUBROUTINE
      IF EXPEXCP = 1 THEN EXIT SUB


 '       IF THE STRING IS A SINGLE NAME, THEN SET BOTH TEMPORARY RANGES TO IT.
      IF TEMPRANGE1$ = "" THEN
         TEMPRANGE1$ = CURTOK$
         TEMPRANGE2$ = CURTOK$
         EXPEXCP = 2
      END IF

 '       PERFORM THE FOLLOWING SECTION ONLY WHEN THE FLOOR NAMES ARRAY
 '       HAS ALREADY BEEN CREATED.
 '        IF NO ERRORS HAVE BEEN FOUND, FIND THE LOCATION OF THE FLOOR NAMES
 '        WITHIN THE FLOOR NAMES ARRAY (IF THE PASSED VALUE IS A RANGE),
      IF FLRNAMES$(1) <> "" THEN
         FOR I = 1 TO TOTFLRS
            IF TEMPRANGE1$ = FLRNAMES$(I) THEN FLRSUB1 = I
            IF TEMPRANGE2$ = FLRNAMES$(I) THEN FLRSUB2 = I
         NEXT I
      END IF
     
 '        IF NO ERRORS HAVE BEEN FOUND, AND THE PASSED VALUE IS A SINGLE NAME,
 '        THEN FIND ITS LOCATION WITHIN THE FLOOR NAMES ARRAY.
      IF FLRNAMES$(1) <> "" THEN
         FOR I = 1 TO TOTFLRS
            IF TEMPRANGE1$ = FLRNAMES$(I) THEN FLRSUB1 = I
         NEXT I
      END IF


      FLREXCP1$ = TEMPRANGE1$
      FLREXCP2$ = TEMPRANGE2$
     
     
   END SUB

 '---------------------------------------------------------------------------
 '      S U B R O U T I N E   T R I P T I M E
 '---------------------------------------------------------------------------
 '           SUBROUTINE TRIPTIME COMPUTES THE TRAVEL TIME FROM THE DESIGNATED
 '    EXIT FLOOR TO EACH OF THE OTHER FLOORS IN THE BUILDING. THE COMPUTED
 '    TIME IS FOR ONE WAY TRAVEL ONLY.  THERE ARE THREE MAIN SITUATIONS WHICH
 '    CAN OCCUR. THESE ARE:
 '      CASE 1 - DISTANCE TO BE TRAVELLED IS SUCH THAT LINEAR ACCELERATION
 '               IS MAINTAINED. THIS OCCURS WHEN DISTANCE IS SMALL.
 '      CASE 2 - DISTANCE TO BE TRAVELLED IS SLIGHTLY GREATER. NON-LINEAR,
 '               OR TRANSITIONAL, ACCELERATION IS REACHED.
 '      CASE 3 - DISTANCE IS GREAT ENOUGH THAT MAXIMUM ELEVATOR CAR VELOCITY
 '               IS REACHED. THIS IS THE CONSTANT VELOCITY CASE.
 '---------------------------------------------------------------------------
 '                        VARIABLES:
 '      A           ACCELERATION RATE OF ELEVATOR CAR.
 '      LEVELTME    LEVELING TIME (s).
 '      S1          DISTANCE REQUIRED FOR ELEVATOR CAR TO REACH VELOCITY V1.
 '      S2          DISTANCE CAR REQUIRES TO REACH VMAX (MAXIMUM VELOCITY),
 '      ST          ACTUAL DISTANCE BETWEEN EXIT FLOOR AND FLOOR FOR WHICH
 '                   THE TRIPTIME IS BEING COMPUTED.
 '      T1          TIME (s)  FOR ELEVATOR CAR TO TRAVEL A DISTANCE OF S1.
 '      T2          TIME (s) FOR CAR TO ATTAIN VMAX.
 '      T2CASE2     TIME (s) FOR CAR TO ATTAIN MAXIMUM VELOCITY IN CASE 2.
 '      T5          TIME (s) FOR ELEVATOR CAR TO TRAVEL THE DISTANCE ST,
 '                   IN CASE 3, NOT INCLUDING LEVELING TIME.
 '      TIMES(I)    ONE WAY TRIP TIMES COMPUTED FOR EACH FLOOR.
 '      TOTFLRS     TOTAL NUMBER OF FLOORS.
 '      TRANS       TRANSITIONAL COEFFICIENT.  V1=TRANS*VMAX.
 '      TT          ONE WAY TRIP TIME FOR THE CURRENT FLOOR.
 '      V2          MAXIMUM VELOCITY OF ELEVATOR CAR ATTAINED IN CASE 2.
 '      VCUBED      V**3, WHERE V IS AS DEFINED ABOVE.
 '      V1          MAXIMUM ELEVATOR CAR VELOCITY TIMES THE TRANSITIONAL
 '                   COEFFICIENT.
 '      VMAX        MAXIMUM CAR VELOCITY, SPECIFIED BY THE USER.
 '---------------------------------------------------------------------------
 '
      SUB TRIPTIME

 '       COMPUTE V1, S1, S2, T1, T2. ONLY PERFORMED ONCE.
      V1 = TRANS * VMAX
      S1 = V1 ^ 2# / (2# * A)
      S2 = (1# / (3# * A)) * (VMAX ^ 3# / V1 - V1 ^ 2#) + S1
      T1 = V1 / A
      T2 = ((VMAX ^ 2# - V1 * V1) / (2# * A * V1)) + T1
      PRINT ""
 '    PRINT " 2*S1= "; 2 * S1
 '    PRINT " 2*S2= "; 2 * S2

 '    ************************************************************************
 '    *   MAIN LOOP OF THIS SUBROUTINE. FOR EACH FLOOR OF THE BUILDING, THE
 '    *   DISTANCE ST IS COMPUTED. NEXT, THE LOOP DETERMINES IF CASE 1, CASE
 '    *   2, OR CASE 3 IS THE RELEVANT SITUATION, AND IT THEN PERFORMS THE
 '    *   APPROPRIATE CALCULATIONS.
 '    ************************************************************************
      FOR I = 1 TO TOTFLRS
 
         ST = ABS(ELEVATION(I) - ELEVATION(EXITFLR))

 '  CASE 1   0 <= ST < 2*S1
         IF 0! <= ST AND ST < 2 * S1 THEN
            TT = 2 * SQR(ST / A) + LEVELTME
            TIMES(I) = TT
 '          PRINT "   CASE 1 - FLOOR # "; I
         END IF
 '  CASE 2   2*S1 <= ST < 2*S2
         IF 2 * S1 <= ST AND ST < 2 * S2 THEN
            VCUBED = V1 ^ 3 + (3 * A * V1 * ((ST / 2#) - S1))
            V2 = VCUBED ^ (1# / 3#)
            T2CASE2 = ((V2 * V2) - (V1 * V1)) / (2 * A * V1) + T1
            TT = 2 * T2CASE2 + LEVELTME
            TIMES(I) = TT
 '          PRINT "   CASE 2 - FLOOR # "; I
         END IF
 '  CASE 3   2*S2 <= ST
         IF 2 * S2 <= ST THEN
            T5 = 2 * T2 + (ST - 2 * S2) / VMAX
            TT = T5 + LEVELTME
            TIMES(I) = TT
 '          PRINT "   CASE 3 - FLOOR # "; I
         END IF

      NEXT I


      END SUB

