C
      PROGRAM DETACT
C
C THIS IS PROGRAM DETACT-T2.
C IT CALCULATES THE RESPONSE OF THERMAL DETECTORS, BOTH FIXED TEMPERATURE
C AND RATE OF TEMPERATURE RISE, TO FIRES WHOSE HEAT RELEASE RATE GROWS
C PROPORTIONALLY WITH THE SQUARE OF TIME FROM IGNITION.
C 
C WRITTEN BY DAVID W. STROUP, CENTER FOR FIRE RESEARCH, NBS
C
C THIS PROGRAM IS A CONTRIBUTION OF THE NATIONAL BUREAU OF STANDARDS AND
C IS NOT SUBJECT TO COPYRIGHT.
C
C VERSION 1.0
C
C ****************************** NOTATION ********************************
C
C INPUT:
C  J     - UNITS CODE  (1 OR 2)
C          1 - INPUT DATA IN ENGLISH UNITS
C          2 - INPUT DATA IN METRIC  UNITS
C  TAMB  - AMBIENT TEMPERATURE
C  RTI   - DETECTOR RESPONSE TIME INDEX
C  TACT  - DETECTOR ACTIVATION TEMPERATURE
C  ROR   - DETECTOR ACTIVATION RATE OF RISE
C  HF    - CEILING HEIGHT
C  ZF    - DETECTOR SPACING
C  M     - GROWTH FACTOR CODE, CHARACTER VARIABLE   (S, M, F, U, OR O)
C  ALPHA - FIRE GROWTH RATE CONSTANT
C
C OUTPUT:
C  T     - TIME OF ACTIVATION FOR FIXED TEMPERATURE DETECTOR 
C  QD    - HEAT RELEASE RATE AT TIME OF ACTIVATION, T
C  TR    - TIME OF ACTIVATION FOR RATE OF RISE DETECTOR
C  QDR   - HEAT RELEASE RATE AT TIME OF ACTIVATION, TR
C  IERR  - ERROR CODE   (0 OR 1)
C          0 - SUCCESSFUL
C          1 - UNSUCCESSFUL 
C
C ************************************************************************
C 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      CHARACTER M
      DATA IRTTY,IWTTY/5,6/
      DATA GE,CPE,RHOE/32.2D0,0.24D0,0.0735D0/
      DATA GM,CPM,RHOM/9.8D0,1.0035D0,1.1768D0/
      IERR = 0
      OPEN (IRTTY,FILE='CON')
      OPEN (IWTTY,FILE='CON') 
      WRITE (IWTTY,1)
1     FORMAT ('  DETACT-T2    VERSION 1.0'/
     &        ' WRITTEN BY D.W. STROUP  (1985)'//
     &        ' CONTRIBUTION OF THE '/
     &        ' NATIONAL BUREAU OF STANDARDS (U.S.).'/
     &        ' NOT SUBJECT TO COPYRIGHT.'//
     &        ' CALCULATES DETECTOR ACTUATION TIME'/
     &        ' BELOW UNCONFINED CEILINGS WITH '/
     &        ' TIME SQUARED FIRE GROWTH RATES.'//)
C
C ENTER INPUT DATA
C
5     CONTINUE
      WRITE (IWTTY,10)
10    FORMAT (' ENTER: 1 FOR ENGLISH UNIT INPUT'/8X,'2 FOR METRIC UNIT I
     &NPUT'/)
      READ (IRTTY,*) J
      IF (J.EQ.1) THEN
      WRITE (IWTTY,20)
20    FORMAT (' ENTER THE AMBIENT TEMPERATURE IN DEGREES F.'/)
      READ (IRTTY,*) TAMB
      WRITE (IWTTY,30)
30    FORMAT (' ENTER THE DETECTOR RESPONSE TIME INDEX (RTI) IN (FT-SEC)
     &**1/2.'/)
      READ (IRTTY,*) RTI
      IF (RTI.LE.0.000001D0) RTI = 0.000001D0
      RTIR = RTI
      WRITE (IWTTY,40)
40    FORMAT (' ENTER THE DETECTOR ACTIVATION TEMPERATURE IN DEGREES F.'
     &/)
      READ (IRTTY,*) TACT
      WRITE (IWTTY,50)
50    FORMAT (' ENTER A DETECTOR RATE OF RISE IN DEGREES F/MINUTE.'/)
      READ (IRTTY,*) ROR
      WRITE (IWTTY,60)
60    FORMAT (' ENTER THE CEILING HEIGHT IN FEET.'/)
      READ (IRTTY,*) HF
      WRITE (IWTTY,70)
70    FORMAT (' ENTER THE DETECTOR SPACING IN FEET.'/)
      READ (IRTTY,*) ZF
      WRITE (IWTTY,80) 
80    FORMAT (' ENTER: S FOR SLOW FIRE GROWTH RATE '/
     &        '        M FOR MEDIUM FIRE GROWTH RATE'/   
     &        '        F FOR FAST FIRE GROWTH RATE'/
     &        '        U FOR ULTRAFAST FIRE GROWTH RATE OR'/
     &        '        O FOR OTHER'/)
      READ (IRTTY,410) M
      IF ((M.EQ.'s').OR.(M.EQ.'S')) ALPHA = 0.00277778D0
      IF ((M.EQ.'m').OR.(M.EQ.'M')) ALPHA = 0.01111111D0
      IF ((M.EQ.'f').OR.(M.EQ.'F')) ALPHA = 0.0444445D0
      IF ((M.EQ.'u').OR.(M.EQ.'U')) ALPHA = 0.1777778D0
      IF ((M.EQ.'o').OR.(M.EQ.'O')) WRITE (IWTTY,90)
      IF ((M.EQ.'o').OR.(M.EQ.'O')) READ (IRTTY,*) ALPHA
90    FORMAT (' ENTER THE FIRE GROWTH RATE CONSTANT (ALPHA) IN BTU/SEC/S 
     &EC/SEC.'/)
100   CONTINUE
      ELSE
C
C METRIC UNIT INPUT
C
      WRITE (IWTTY,110)
110   FORMAT (' ENTER THE AMBIENT TEMPERATURE IN DEGREES C.'/)
      READ (IRTTY,*) TAMB
      WRITE (IWTTY,120)
120   FORMAT (' ENTER THE DETECTOR RESPONSE TIME INDEX (RTI) IN (M-SEC)*
     &*1/2.'/)
      READ (IRTTY,*) RTI
      IF (RTI.LE.0.000001D0) RTI = 0.000001D0
      RTIR = RTI
      WRITE (IWTTY,130)
130   FORMAT (' ENTER THE DETECTOR ACTIVATION TEMPERATURE IN DEGREES C.'
     &/)
      READ (IRTTY,*) TACT
      WRITE (IWTTY,140)
140   FORMAT (' ENTER A DETECTOR RATE OF RISE IN DEGREES C/MINUTE.'/)
      READ (IRTTY,*) ROR
      WRITE (IWTTY,150)
150   FORMAT (' ENTER THE CEILING HEIGHT IN METERS.'/) 
      READ (IRTTY,*) HF
      WRITE (IWTTY,160)
160   FORMAT (' ENTER THE DETECTOR SPACING IN METERS.'/)
      READ (IRTTY,*) ZF
      WRITE (IWTTY,80)
      READ (IRTTY,410) M
      IF ((M.EQ.'s').OR.(M.EQ.'S')) ALPHA = 2.930555556D0
      IF ((M.EQ.'m').OR.(M.EQ.'M')) ALPHA = 11.72222222D0
      IF ((M.EQ.'f').OR.(M.EQ.'F')) ALPHA = 46.88888889D0
      IF ((M.EQ.'u').OR.(M.EQ.'U')) ALPHA = 187.5555556D0
      IF ((M.EQ.'o').OR.(M.EQ.'O')) WRITE (IWTTY,170)
      IF ((M.EQ.'o').OR.(M.EQ.'O')) READ (IRTTY,*) ALPHA
170   FORMAT (' ENTER THE FIRE GROWTH RATE CONSTANT (ALPHA) IN WATTS/SEC/
     &SEC.'/)
180   CONTINUE
      ENDIF
C
C ******************* CALCULATIONS *************************************
C
      R = 0.5D0*DSQRT(2.0D0)*ZF
      ROH = R/HF
      ROR = ROR/60.D0
      IF (J.EQ.1) THEN
      TAMB = TAMB + 460.D0
      TACT = TACT + 460.D0
      A = GE/(CPE*TAMB*RHOE)
      G = GE
      ELSE
      TAMB = TAMB + 273.D0
      TACT = TACT + 273.D0
      A = GM/(CPM*TAMB*RHOM*1000.D0)
      G = GM
      ENDIF
      TOTS2 = A**(-1.D0/5.D0)*ALPHA**(-1.D0/5.D0)*HF**(4.D0/5.D0)
      DLTODL = A**(2.D0/5.D0)*(TAMB/G)*ALPHA**(2.D0/5.D0)
     &            *HF**(-3.D0/5.D0)
      UOUS2 = A**(1.D0/5.D0)*ALPHA**(1.D0/5.D0)*HF**(1.D0/5.D0)
      DELTD = TACT - TAMB
      IF (ROH.GT.0.3D0) THEN
      UODLTH = 0.59D0*ROH**(-0.63D0)
      ELSE
      UODLTH = 3.87D0/(9.115D0**0.5D0)
      ENDIF
      TS2F = 0.954D0*(1.D0+ROH)
      A2 = (4.D0/3.D0)*DLTODL*UOUS2**(-0.5D0)*UODLTH**(-0.5D0)*RTI/
     &              (TOTS2*(0.188D0+0.313D0*ROH))
      C = 1.D0+DELTD/A2
      CALL NWTN (C,Y,IERR,IWTTY)
      IF (IERR.EQ.1) GO TO 380
      DELTS2 = (4.D0/3.D0)*UOUS2**(-0.5D0)*UODLTH**(-0.5D0)*RTI*Y/
     &                 (TOTS2*(0.188D0+0.313D0*ROH))
      TS2 = 0.954D0*(1.D0+ROH)+(0.188D0+0.313D0*ROH)*DELTS2**(3.D0/4.D0)
      TS2 = TS2 + TS2F
      T = TS2*A**(-1.D0/5.D0)*ALPHA**(-1.D0/5.D0)*HF**(4.D0/5.D0)
      QD = ALPHA*T**2
      IF (RTIR.LE.2.0D0) RTIR = 2.0D0
      D1 = (4.D0/3.D0)*DLTODL/(TOTS2*(0.188D0+0.313D0*ROH))
      D2 = (3.D0/4.D0)*UOUS2**0.5D0*UODLTH**0.5D0*(1.D0/RTIR)*TOTS2
     &                *(0.188D0+0.313D0*ROH)
      CALL BISECT (D1,D2,ROR,DELTS2,IERR,IWTTY)
      IF (IERR.EQ.1) GO TO 380
      TS2R = 0.954D0*(1.D0+ROH)+(0.188D0+0.313D0*ROH)*DELTS2
     &            **(3.D0/4.D0) 
      TS2R = TS2R + TS2F
      TR = TS2R*A**(-1.D0/5.D0)*ALPHA**(-1.D0/5.D0)*HF**(4.D0/5.D0)
      QDR = ALPHA*TR**2
C
C ********** PRINT OUT RESULTS ***************************************
C
      ROR = ROR*60.D0
      WRITE (IWTTY,190)
190   FORMAT ('1  RESULTS:')
      IF (J.EQ.1) THEN
C
C ENGLISH (METRIC) OUTPUT
C
      HF2 = HF * 0.3048D0
      ZF2 = ZF * 0.3048D0
      WRITE (IWTTY,200) HF,HF2,ZF,ZF2
200   FORMAT ('0    CEILING HEIGHT   = ',F6.2,' FEET (',F6.2,' METERS)'/
     &          5X,'DETECTOR SPACING = ',F6.2,' FEET (',F6.2,' METERS)')
      RTI2 = RTI * (0.3048D0**0.5D0)
      WRITE (IWTTY,210) RTI,RTI2
210   FORMAT ('0    DETECTOR RTI = ',F6.1,' (FT-SEC)**1/2 (',F6.1,' (M-S
     &EC)**1/2)')
      ALPHA2 = ALPHA * 1055.D0
      WRITE (IWTTY,220) ALPHA,ALPHA2
220   FORMAT ('0    FIRE GROWTH CONSTANT = ',E12.4,' BTU/(SEC**3)'/
     &        '                           (',E12.4,' JOULES/SEC**3)')
      WRITE (IWTTY,400)
      READ (IRTTY,410) M
      WRITE (IWTTY,230)
230   FORMAT (/'0  FOR TEMPERATURE ACTUATED DETECTOR:')
      TACT = TACT - 460.D0
      TACT2 = (5.D0/9.D0)*(TACT-32.D0)
      WRITE (IWTTY,240) TACT,TACT2
240   FORMAT ('0    ACTIVATION TEMPERATURE = ',F6.1,' DEGREES F (' ,F6.1,
     & ' DEGREES C)')
      T = T / 60.D0
      WRITE (IWTTY,250) T
250   FORMAT ('0    TIME TO ACTIVATION = ',F8.2,' MINUTES')
      QD2 = QD * 1.055D0
      WRITE (IWTTY,260) QD,QD2
260   FORMAT ('0    HEAT RELEASE RATE = ',E12.4,' BTU/SEC'/
     &        '                        (',E12.4,' KILOJOULES/SEC)')
      WRITE (IWTTY,400)
      READ (IRTTY,410) M
      WRITE (IWTTY,270) 
270   FORMAT (//'0  FOR RATE OF RISE ACTUATED DETECTOR:')
      ROR2 = ROR * (5.D0/9.D0)
      WRITE (IWTTY,290) ROR,ROR2
290   FORMAT ('0    ACTIVATION RATE OF RISE = ',F6.2,' DEGREES F/MIN (',
     &                  F6.2,' DEGREES C/MIN)')
      TR = TR / 60.D0
      WRITE (IWTTY,250) TR
      QDR2 = QDR * 1.055D0
      WRITE (IWTTY,260) QDR,QDR2
      WRITE (IWTTY,400)
      READ (IRTTY,410) M
      ELSE
C
C METRIC (ENGLISH) OUTPUT
C
      HF2 = HF * (1.D0/0.3048D0)
      ZF2 = ZF * (1.D0/0.3048D0)
      WRITE (IWTTY,300) HF,HF2,ZF,ZF2
300   FORMAT ('0    CEILING HEIGHT   = ',F6.2,' METERS (',F6.2,' FEET)'/
     &          5X,'DETECTOR SPACING = ',F6.2,' METERS (',F6.2,' FEET)')
      RTI2 = RTI * ((1.D0/0.3048D0)**0.5D0)
      WRITE (IWTTY,320) RTI,RTI2
320   FORMAT ('0    DETECTOR RTI = ',F6.1,' (M-SEC)**1/2 (',F6.1,' (FT-S
     &EC)**1/2)')
      ALPHA2 = ALPHA * (1.D0/1055.D0)
      WRITE (IWTTY,330) ALPHA,ALPHA2
330   FORMAT ('0    FIRE GROWTH CONSTANT = ',E12.4,' JOULES/(SEC**3)'/
     &        '                           (',E12.4,' BTU/SEC**3)')
      WRITE (IWTTY,400)
      READ (IRTTY,410) M
      WRITE (IWTTY,230)
      TACT = TACT - 273.D0
      TACT2 = (9.D0/5.D0) * TACT + 32.D0
      WRITE (IWTTY,340) TACT,TACT2
340   FORMAT ('0    ACTIVATION TEMPERATURE = ',F6.1,' DEGREES C (',F6.1,
     & ' DEGREES F)')
      T = T / 60.D0
      WRITE (IWTTY,350) T
350   FORMAT ('0    TIME TO ACTIVATION = ',F8.2,' MINUTES')
      QD = QD / 1000.D0
      QD2 = QD * (1.D0/1.055D0)
      WRITE (IWTTY,360) QD,QD2
360   FORMAT ('0    HEAT RELEASE RATE = ',E12.4,' KILOJOULES/SEC'/
     &        '                        (',E12.4,' BTU/SEC)')
      WRITE (IWTTY,400)
      READ (IRTTY,410) M
      WRITE (IWTTY,270)
      ROR2 = ROR * (9.D0/5.D0)
      WRITE (IWTTY,370) ROR,ROR2
370   FORMAT ('0    ACTIVATION RATE OF RISE = ',F6.2,' DEGREES C/MIN (',
     &               F6.2,' DEGREES F/MIN)')
      TR = TR / 60.D0
      WRITE (IWTTY,350) TR
      QDR = QDR / 1000.D0
      QDR2 = QDR * (1.D0/1.055D0)
      WRITE (IWTTY,360) QDR,QDR2
      WRITE (IWTTY,400)
      READ (IRTTY,410) M
      ENDIF
      WRITE (IWTTY,420)
      READ (IRTTY,410) M
      IF ((M.EQ.'Y').OR.(M.EQ.'y')) GO TO 5
      STOP 'PROGRAM COMPLETED'
380   CONTINUE
      WRITE (IWTTY,390)
390   FORMAT (' *******> ERROR IN DETACT ROUTINE <*******')
400   FORMAT (//' <RETURN> TO CONTINUE')
410   FORMAT (A1)
      WRITE (IWTTY,420)
420   FORMAT (' TRY ANOTHER CASE (Y/N) ?'/)
      READ (IRTTY,410) M
      IF ((M.EQ.'Y').OR.(M.EQ.'y')) GO TO 5 
      STOP 'PROGRAM ABORTED'
      END
C
      SUBROUTINE NWTN (C,P,IERR,IWTTY)
C
C THIS IS ROUTINE NWTN. IT SOLVES THE FIXED TEMPERATURE DETECTOR
C ACTIVATION TIME EQUATION USING A NEWTON-RAPHSON METHOD.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      P0 = 0.1D0
      TOL = 0.00001D0
      N0 = 1000
      I = 1
      IERR = 0
10    CONTINUE
      IF (I.LE.N0) THEN
      IF (P0.GT.50.D0) THEN
      X = 0.0D0
      ELSE
      X = DEXP(-P0)
      ENDIF
      FX = P0 + X - C
      FPMX = 1.0D0 - X
      IF (FPMX.LT.0.00000001D0) GO TO 30
      P = P0 - (FX/FPMX)
      IF (ABS(P-P0).LT.TOL) THEN
      IERR = 0
      RETURN
      ELSE
      I = I + 1
      P0 = P
      ENDIF
      GO TO 10
      ENDIF
      IERR = 1
      WRITE (IWTTY,20) I
20    FORMAT (' NEWTON-RAPHSON FAILED AFTER N0 ITERATIONS, N0 = ',I4)
      RETURN
30    WRITE (IWTTY,40)
40    FORMAT (' SLOPE OF EQUATION TOO CLOSE TO ZERO FOR '/
     &   '   NEWTON-RAPHSON METHOD.'/
     &   '   ERROR RETURN')
      IERR = 1
      RETURN
      END
C
      SUBROUTINE BISECT (D1,D2,ROR,P,IERR,IWTTY)
C
C THIS IS ROUTINE BISECT. IT SOLVES THE RATE OF RISE DETECTOR ACTIVATION
C TIME EQUATION USING A BISECTION METHOD.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IERR = 0
      TOL = 0.00001D0
      N0 = 1000
      A = 0.0D0
      B = 1000.0D0
      RLMT = TOL / 20.0
10    CONTINUE
      IF ((D2*B).GT.50.D0) THEN
      X = 0.0D0
      ELSE
      X = DEXP (-D2*B)
      ENDIF
      FXB = D1*B**0.25D0-D1*B**0.25*X-ROR
      IF (FXB.LT.0.0D0) THEN 
      A = B
      B = B + 500.D0
      GO TO 10
      ENDIF
      I = 1
20    CONTINUE
      IF (I.LE.N0) THEN      
      P = A+(B-A)/2.0D0
      IF ((D2*P).GT.50.D0) THEN
      X = 0.0D0
      ELSE
      X = DEXP (-D2*P)
      ENDIF
      FX = D1*P**0.25D0-D1*P**0.25D0*X-ROR
      IF (((FX.GT.-RLMT).AND.(FX.LT.RLMT)).OR.
     &   (((B-A)/2.D0).LT.TOL)) THEN
      IERR = 0
      RETURN
      ELSE
      I = I + 1
      IF ((D2*A).GT.50.D0) THEN
      X = 0.0D0
      ELSE
      X = DEXP (-D2*A)
      ENDIF
      FXA = D1*A**0.25D0-D1*A**0.25D0*X-ROR
      IF ((FXA*FX).GT.0.0D0) THEN
      A = P
      ELSE
      B = P
      ENDIF
      ENDIF
      GO TO 20
      ENDIF
      IERR = 1
      WRITE (IWTTY,30) I
30    FORMAT (' BISECTION ROUTINE FAILED AFTER N0 ITERATIONS, N0 = ',I4)
      RETURN
      END
