10 PRINT "DETACT-T2   VERSION 2.0"
20 PRINT "WRITTEN BY D.W. STROUP  (1985)"
30 PRINT " "
40 PRINT "CONTRIBUTION OF THE"
50 PRINT "NATIONAL BUREAU OF STANDARDS (U.S.)."
60 PRINT "NOT SUBJECT TO COPYRIGHT. "
70 PRINT " "
80 PRINT "CALCULATES DETECTOR ACTUATION TIME"
90 PRINT "BELOW UNCONFINED CEILINGS WITH "
100 PRINT "TIME SQUARED FIRE GROWTH RATES "
110 PRINT " "
120 REM
130 REM INPUT:
140 REM  J     - UNITS CODE (1 OR 2)
150 REM          1 - INPUT DATA IN ENGLISH UNITS
160 REM          2 - INPUT DATA IN METRIC  UNITS
170 REM  TAMB  - AMBIENT TEMPERATURE
180 REM  RTI   - DETECTOR RESPONSE TIME INDEX
190 REM  TACT  - DETECTOR ACTIVATION TEMPERATURE
200 REM  ROR   - DETECTOR ACTIVATION RATE OF RISE
210 REM  HF    - CEILING HEIGHT
220 REM  ZF    - DETECTOR SPACING
230 REM  M     - GROWTH RATE FACTOR CODE, CHARACTER (S, M, F, U, OR O)
240 REM  ALPHA - FIRE GROWTH RATE CONSTANT (FOR M = O)
250 REM
260 REM OUTPUT:
270 REM  T     - TIME OF ACTIVATION FOR FIXED TEMPERATURE DETECTOR
280 REM  QD    - HEAT RELEASE RATE AT TIME OF ACTIVATION, T
290 REM  TR    - TIME OF ACTIVATION FOR RATE OF RISE DETECTOR
300 REM  QDR   - HEAT RELEASE RATE AT TIME OF ACTIVATION, TR
310 REM  IERR  - ERROR CODE  (0 OR 1)
320 REM          0 - SUCCESSFUL
330 REM          1 - UNSUCCESSFUL
340 REM
350 CLEAR
360 REM
370 REM ENTER INPUT DATA
380 REM
390 READ GE#,CPE#,RHOE#
400 DATA 32.2#,0.24#,0.0735#
410 READ GM#,CPM#,RHOM#
420 DATA 9.8#,1.0035#,1.1768#
430 IERR% = 0
440 PRINT " ENTER: 1 FOR ENGLISH UNIT INPUT"
450 PRINT "        2 FOR METRIC  UNIT INPUT"
460 INPUT "SELECTION = ",J%
470 IF J%<>1 GOTO 740
480 REM
490 REM ENTER DATA IN ENGLISH UNITS
500 REM
510 INPUT "AMBIENT TEMPERATURE <DEGREES F> = ",TAMB#
520 INPUT "DETECTOR RESPONSE TIME INDEX, RTI <(FT-SEC)^(1/2)> = ",RTI#
530 IF RTI#<.0000001# THEN LET RTI# = .0000001#
540 RTIR# = RTI#
550 INPUT "DETECTOR ACTIVATION TEMPERATURE <DEGREES F> = ",TACT#
560 INPUT "DETECTOR RATE OF TEMPERATURE RISE <DEGREES F/MIN> = ",ROR#
570 INPUT "ROOM CEILING HEIGHT <FEET> = ",HF#
580 INPUT "DETECTOR SPACING <FEET> = ",ZF#
590 PRINT "ENTER: S FOR SLOW      FIRE GROWTH RATE,"
600 PRINT "       M FOR MEDIUM    FIRE GROWTH RATE,"
610 PRINT "       F FOR FAST      FIRE GROWTH RATE,"
620 PRINT "       U FOR ULTRAFAST FIRE GROWTH RATE, OR"
630 PRINT "       O FOR OTHER     FIRE GROWTH RATE"
640 INPUT "SELECTION = ",M$
650 IF (M$="s" OR M$="S") THEN LET ALPHA# = .00277778#
660 IF (M$="m" OR M$="M") THEN LET ALPHA# = .01111111#
670 IF (M$="f" OR M$="F") THEN LET ALPHA# = .04444445#
680 IF (M$="u" OR M$="U") THEN LET ALPHA# = .17777778#
690 IF (M$="o" OR M$="O") THEN INPUT "FIRE GROWTH RATE <BTU/SEC^3> = ",ALPHA#
700 GOTO 940
710 REM
720 REM ENTER DATA IN METRIC UNITS
730 REM
740 INPUT "AMBIENT TEMPERATURE <DEGREES C> = ",TAMB#
750 INPUT "DETECTOR RESPONSE TIME INDEX, RTI <(M-SEC)^(1/2)> = ",RTI#
760 IF RTI#<.0000001# THEN LET RTI# = .0000001#
770 RTIR# = RTI#
780 INPUT "DETECTOR ACTIVATION TEMPERATURE <DEGREES C> = ",TACT#
790 INPUT "DETECTOR RATE OF TEMPERATURE RISE <DEGREES C/MIN> = ",ROR#
800 INPUT "ROOM CEILING HEIGHT <METERS> = ",HF#
810 INPUT "DETECTOR SPACING <METERS> = ",ZF#
820 PRINT "ENTER: S FOR SLOW      FIRE GROWTH RATE,"
830 PRINT "       M FOR MEDIUM    FIRE GROWTH RATE,"
840 PRINT "       F FOR FAST      FIRE GROWTH RATE,"
850 PRINT "       U FOR ULTRAFAST FIRE GROWTH RATE, OR"
860 PRINT "       O FOR OTHER     FIRE GROWTH RATE"
870 INPUT "SELECTION = ",M$
880 IF (M$="s" OR M$="S") THEN LET ALPHA# = 2.9305556#
890 IF (M$="m" OR M$="M") THEN LET ALPHA# = 11.722222#
900 IF (M$="f" OR M$="F") THEN LET ALPHA# = 46.888889#
910 IF (M$="u" OR M$="U") THEN LET ALPHA# = 187.55556#
920 IF (M$="o" OR M$="O") THEN INPUT "FIRE GROWTH RATE <J/SEC^3> = ",ALPHA#
930 REM
940 REM ****************  CALCULATIONS  *************************************
950 REM
960 R# = .5# * SQR(2#) * ZF#
970 ROH# = R# /HF#
980 ROR# = ROR# / 60#
990 IF J%<>1 GOTO 1050
1000 TAMB# = TAMB# + 460#
1010 TACT# = TACT# + 460#
1020 A# = GE#/(CPE#*TAMB#*RHOE#)
1030 G# = GE#
1040 GOTO 1090
1050 TAMB# = TAMB# + 273#
1060 TACT# = TACT# + 273#
1070 A# = GM#/(CPM#*TAMB#*RHOM#*1000#)
1080 G# = GM#
1090 TOTS2#=A#^(-1#/5#)*ALPHA#^(-1#/5#)*HF#^(4#/5#)
1100 DLTODL#=A#^(2#/5#)*(TAMB#/G#)*ALPHA#^(2#/5#)*HF#^(-3#/5#)
1110 UOUS2#=A#^(1#/5#)*ALPHA#^(1#/5#)*HF#^(1#/5#)
1120 DELTD# = TACT# - TAMB#
1130 IF (ROH#>.3) THEN UODLTH#=.59*ROH#^(-.63#) ELSE UODLTH#=3.87#/(SQR(9.115#))
1140 TS2F# = .954# * (1# + ROH#)
1150 P# = TOTS2#*(.188#+.313#*ROH#)
1160 A2#=(4#/3#)*DLTODL#*UOUS2#^(-.5#)*UODLTH#^(-.5#)*RTI#/P#
1170 C# = 1# + DELTD# / A2#
1180 GOSUB 2650
1190 IF IERR%=1 GOTO 2550
1200 DELTS2#=(4#/3#)*UOUS2#^(-.5#)*UODLTH#^(-.5#)*RTI#*Y#/P#
1210 TS2#=.954#*(1#+ROH#)+(.188#+.313#*ROH#)*DELTS2#^(3#/4#)
1220 TS2# = TS2# + TS2F#
1230 T#=TS2#*A#^(-1#/5#)*ALPHA#^(-1#/5#)*HF#^(4#/5#)
1240 QD# = ALPHA# * T#^2!
1250 IF RTIR#<=2# THEN LET RTIR# = 2#
1260 D1#=(4#/3#)*DLTODL#/P#
1270 D2#=(3#/4#)*UOUS2#^.5#*UODLTH#^.5#*(1#/RTIR#)*P#
1280 GOSUB 2950
1290 IF IERR%=1 GOTO 2550
1300 TS2R#=.954#*(1#+ROH#)+(.188#+.313#*ROH#)*DELTS2#^(3#/4#)
1310 TS2R# = TS2R# + TS2F#
1320 TR#=TS2R#*A#^(-1#/5#)*ALPHA#^(-1#/5#)*HF#^(4#/5#)
1330 QDR# = ALPHA# * TR#^2!
1340 ROR# = ROR# * 60#
1350 REM
1360 REM PRINT OUT RESULTS
1370 REM
1380 PRINT "RESULTS:"
1390 IF J%<>1 GOTO 1960
1400 REM
1410 REM ENGLISH (METRIC) OUTPUT
1420 REM
1430 HF2# = HF# * .3048
1440 ZF2# = ZF# * .3048
1450 PRINT " "
1460 PRINT " CEILING HEIGHT = ";CSNG(HF#);" FEET"
1470 PRINT "                 (";CSNG(HF2#);" METERS)"
1480 PRINT " "
1490 PRINT " DETECTOR SPACING = ";CSNG(ZF#);" FEET"
1500 PRINT "                   (";CSNG(ZF2#);" METERS)"
1510 PRINT "  "
1520 RTI2# = RTI# * (.3048#^.5#)
1530 PRINT " RTI = ";CSNG(RTI#);" (FT-SEC)^0.5";" (";CSNG(RTI2#);" (M-SEC)^0.5)
1540 PRINT "  "
1550 ALPHA2# = ALPHA# * 1055#
1560 PRINT " FIRE GROWTH RATE = ";CSNG(ALPHA#);" BTU/(SEC^3)"
1570 PRINT "                   (";CSNG(ALPHA2#);" J/(SEC^3))"
1580 PRINT " "
1590 INPUT "<RETURN> TO CONTINUE ";O$
1600 PRINT " "
1610 PRINT " "
1620 PRINT " FOR TEMPERATURE ACTUATED DETECTOR:"
1630 TACT# = TACT# - 460#
1640 TACT2# = (5#/9#) * (TACT# - 32#)
1650 PRINT " "
1660 PRINT "  ACTIVATION TEMPERATURE = ";CSNG(TACT#);" DEGREES F"
1670 PRINT "                          (";CSNG(TACT2#);" DEGREES C)"
1680 PRINT " "
1690 T# = T# / 60#
1700 PRINT "  TIME TO ACTIVATION = ";CSNG(T#);" MINUTES"
1710 PRINT " "
1720 QD2# = QD# * 1.055#
1730 PRINT "  HEAT RELEASE RATE = ";CSNG(QD#);" BTU/SEC"
1740 PRINT "                     (";CSNG(QD2#);" kJ/SEC )"
1750 PRINT " "
1760 INPUT "<RETURN> TO CONTINUE ";O$
1770 PRINT " "
1780 PRINT " "
1790 PRINT " FOR RATE OF RISE ACTUATED DETECTOR:"
1800 ROR2# = ROR# * (5#/9#)
1810 PRINT " "
1820 PRINT "  ACTIVATION RATE OF RISE = ";CSNG(ROR#);" DEGREES F/MIN"
1830 PRINT "                           (";CSNG(ROR2#);" DEGREES C/MIN)"
1840 PRINT " "
1850 TR# = TR# /60#
1860 PRINT "  TIME TO ACTIVATION = ";CSNG(TR#);" MINUTES"
1870 QDR2# = QDR# * 1.055#
1880 PRINT " "
1890 PRINT "  HEAT RELEASE RATE = ";CSNG(QDR#);" BTU/SEC"
1900 PRINT "                     (";CSNG(QDR2#);" kJ/SEC )"
1910 PRINT " "
1920 PRINT " "
1930 INPUT " TRY ANOTHER RUN (YES/NO) ";O$
1940 IF (O$="Y" OR O$="y") GOTO 120
1950 GOTO 2530
1960 HF2# = HF# * (1!/.3048)
1970 ZF2# = ZF# * (1!/.3048)
1980 REM
1990 REM METRIC (ENGLISH) OUTPUT
2000 REM
2010 PRINT " "
2020 PRINT " CEILING HEIGHT = ";CSNG(HF#);" METERS"
2030 PRINT "                 (";CSNG(HF2#);" FEET)"
2040 PRINT " "
2050 PRINT " DETECTOR SPACING = ";CSNG(ZF#);" METERS"
2060 PRINT "                   (";CSNG(ZF2#);" FEET)"
2070 PRINT " "
2080 RTI2# = RTI# * ((1!/.3048)^.5#)
2090 PRINT " RTI = ";CSNG(RTI#);" (M-SEC)^0.5";" (";CSNG(RTI2#);" (FT-SEC)^0.5)
2100 PRINT " "
2110 ALPHA2# = ALPHA# * (1!/1055!)
2120 PRINT " FIRE GROWTH RATE = ";CSNG(ALPHA#);" J/(SEC^3)"
2130 PRINT "                   (";CSNG(ALPHA2#);" BTU/(SEC^3))"
2140 PRINT " "
2150 INPUT "<RETURN> TO CONTINUE ";O$
2160 PRINT " "
2170 PRINT " "
2180 PRINT " FOR TEMPERATURE ACTUATED DETECTOR:"
2190 PRINT " "
2200 TACT# = TACT# - 273#
2210 TACT2# = (9#/5#) * TACT# + 32#
2220 PRINT "  ACTIVATION TEMPERATURE = ";CSNG(TACT#);" DEGREES C"
2230 PRINT "                          (";CSNG(TACT2#);" DEGREES F)"
2240 PRINT " "
2250 T# = T# / 60#
2260 PRINT "  TIME TO ACTIVATION = ";CSNG(T#);" MINUTES"
2270 PRINT " "
2280 QD# = QD# / 1000#
2290 QD2# = QD# * (1!/1.055)
2300 PRINT "  HEAT RELEASE RATE = ";CSNG(QD#);" kJ/SEC"
2310 PRINT "                     (";CSNG(QD2#);" BTU/SEC )"
2320 PRINT " "
2330 INPUT "<RETURN> TO CONTINUE";O$
2340 PRINT " "
2350 PRINT " "
2360 PRINT " FOR RATE OF RISE ACTUATED DETECTOR:"
2370 ROR2# = ROR# * (9#/5#)
2380 PRINT " "
2390 PRINT "  ACTIVATION RATE OF RISE = ";CSNG(ROR#);" DEGREES C/MIN"
2400 PRINT "                           (";CSNG(ROR2#);" DEGREES F/MIN)"
2410 PRINT " "
2420 TR# = TR# /60#
2430 PRINT "  TIME TO ACTIVATION = ";CSNG(TR#);" MINUTES"
2440 PRINT " "
2450 QDR# = QDR# / 1000#
2460 QDR2# = QDR# * (1!/1.055)
2470 PRINT "  HEAT RELEASE RATE = ";CSNG(QDR#);" kJ/SEC"
2480 PRINT "                     (";CSNG(QDR2#);" BTU/SEC )"
2490 PRINT " "
2500 PRINT " "
2510 INPUT " TRY ANOTHER RUN (YES/NO) ";O$
2520 IF (O$="Y" OR O$="y") GOTO 120
2530 END
2540 REM
2550 REM *********** ERROR HANDLING ROUTINE ***********
2560 REM
2570 PRINT " "
2580 PRINT " !!!!! ERROR IN DETACT-T2 ROUTINE !!!!!"
2590 PRINT " !!!!! PROGRAM RUN ABORTED        !!!!!"
2600 PRINT " "
2610 INPUT " WOULD YOU LIKE TO TRY AGAIN (YES/NO) ?";O$
2620 IF (O$="Y" OR O$="y") GOTO 120
2630 END
2640 REM
2650 REM ** NEWTON RAPHSON ROUTINE TO FIND ACTIVATION **
2660 REM ** TIME OF FIXED TEMPERATURE DETECTOR.       **
2670 REM
2680 P0# = .1#
2690 TOL# = .00001#
2700 N0% = 1000
2710 I% = 1
2720 IERR% = 0
2730 REM
2740 IF I%>N0% GOTO 2870
2750 IF (P0#>50#) THEN LET X#=0# ELSE X#=EXP(-P0#)
2760 FX#=P0# + X# - C#
2770 FPMX# = 1# - X#
2780 IF (FPMX#<.00000001#) GOTO 2900
2790 P2# = P0# - (FX#/FPMX#)
2800 IF (ABS(P0#-P2#)>TOL#) GOTO 2840
2810 IERR% = 0
2820 Y# = P2#
2830 RETURN
2840 I% = I% + 1
2850 P0# = P2#
2860 GOTO 2730
2870 IERR% = 1
2880 PRINT "NEWTON RAPHSON FAILED AFTER N0 ITERATIONS, N0 = ",I%
2890 RETURN
2900 PRINT "SLOPE OF EQUATION TOO CLOSE TO ZERO!!!"
2910 PRINT "ERROR IN NEWTON RAPHSON ROUTINE"
2920 IERR% = 1
2930 RETURN
2940 REM
2950 REM ** BISECTION ROUTINE TO FIND ACTIVATION **
2960 REM ** TIME OF RATE OF RISE DETECTOR.       **
2970 REM
2980 IERR% = 0
2990 TOL# = .00001#
3000 N0% = 1000
3010 AA# = 0#
3020 B# = 1000#
3030 RLMT# = TOL# / 20#
3040 REM
3050 IF (D2#*B#)>50# THEN X# = 0# ELSE X# = EXP(-D2#*B#)
3060 FXB# = D1# * B# ^ .25# - D1# * B# ^ .25# * X# - ROR#
3070 IF FXB#>=0# GOTO 3110
3080 AA# = B#
3090 B# = B# + 500#
3100 GOTO 3040
3110 I% = 1
3120 REM
3130 IF I>N0 GOTO 3260
3140 P3# = AA# + (B# - AA#) / 2#
3150 IF (D2#*P3#)>50# THEN X# = 0# ELSE X# = EXP (-D2#*P3#)
3160 FX# = D1# * P3# ^ .25# - D1# * P3# ^ .25# * X# - ROR#
3170 DELTS2# = P3#
3180 IF ((FX#>(-RLMT#)) AND (FX#<RLMT#)) THEN RETURN
3190 IF ((B#-AA#)/2#)<TOL# THEN RETURN
3200 REM
3210 I% = I% + 1
3220 IF (D2#*AA#)>50# THEN X# = 0# ELSE X# = EXP(-D2#*AA#)
3230 FXA# = D1# * AA# ^ .25# - D1# * AA# ^ .25# * X# - ROR#
3240 IF (FXA#*FX#)>0# THEN AA# = P3# ELSE B# = P3#
3250 GOTO 3120
3260 IERR% = 1
3270 PRINT "BISECTION ALGORITHM FAILED TO CONVERGE AFTER ",I%," ITERATIONS."
3280 RETURN
