#! /usr/bin/env python
#
# run-cx-all-simple.py
# Run ContamX on all PRJ files in current directory
#
import os
import array
import glob
import shutil
import subprocess
import sys

#-----------------------------------------------------------------------------#
#                                MAIN PROGRAM
#-----------------------------------------------------------------------------#
#
def main():
	cx_exe = "ContamX3.exe"
	prj_list = []
	prj_list_noext = []
	cx_processes = []

	# Get list of PRJ files in directory
	#
	print ("\nProject files to process...")
	prj_count = 0
	for dirpath, dirnames, filenames in os.walk('.'):
		for name in filenames:
			root, ext = os.path.splitext(name) 
			if dirpath == ".":
				if ext == ".prj":
					prj_list.append(name)
					prj_list_noext.append(root)
					prj_count = prj_count + 1
					print(prj_count, " ", root, ext)

	#----- Run ContamX on all PRJs -----#
	#
	print('Run ContamX on all PRJs')
	i = 0
	for prj_file in prj_list :
		cmd = os.path.join(".",cx_exe)
		cmd = cmd + " " + prj_file
		print("Command line: ", cmd)
		p = subprocess.Popen(cmd)
		cx_processes.append(p)
	i = i+1
	os.chdir( ".." )
	
	# Wait for ContamX processes to complete
	#
	for p in cx_processes:
		retcode = p.wait()
		str_log = "contamx p.wait(" + str(p) + ") = " + str(retcode)
		print(str_log)
			
#--- End main() ---#

if __name__ == "__main__":
	main()
