/*
 * Decompiled with CFR 0.152.
 */
package JGDS2;

import JGDS2.Const;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class GDSWriter
implements Const {
    Vector d = new Vector();
    DataOutputStream dout;
    int l = 2;

    public GDSWriter(DataOutputStream i) {
        this.dout = i;
    }

    public void printL(long l) {
        System.out.println(Long.toBinaryString(l).replace('0', 'O'));
    }

    public static String L(long l) {
        String r = Long.toBinaryString(l);
        String f = "000000000000000000000000000000000000000000000000000000000000000000000000";
        r = f.substring(0, 64 - r.length()) + r;
        StringBuffer s = new StringBuffer(r);
        for (int i = 0; i < 9; ++i) {
            s.insert(i * 9, ' ');
        }
        return s.toString();
    }

    public static String B(long l) {
        StringBuffer s;
        String r = Long.toBinaryString(l);
        String f = "B000000000000000000000000000000000000000000000000000000000000000000000000";
        if (r.length() < 9) {
            r = f.substring(0, 9 - r.length()) + r;
            s = new StringBuffer(r);
        } else {
            s = new StringBuffer(GDSWriter.L(l));
        }
        return s.toString();
    }

    public int floatToGDSint(float n) {
        int c = Float.floatToRawIntBits(n);
        return c;
    }

    public static long doubleToGDSlong(double n) {
        long c = Double.doubleToLongBits(n);
        if (n == 0.0) {
            return c;
        }
        long e = 0x7FFL & (c >>> 52 ^ 0x400L) + 1L;
        long d = (0xFFFFFFFFFFFFFL & c) + 0x10000000000000L;
        int i = (int)(e % 4L) + 1;
        d = d << 3 >> 4 - i;
        e = ((0x7FL & e / 4L + 1L ^ 0x40L) << 56) + d + (c & Long.MIN_VALUE);
        return e;
    }

    public GDSdata gd(int i, Object o) {
        return new GDSdata(i, o);
    }

    public void add(long i) {
        this.d.add(this.gd(2, new Long(i)));
        this.l += 8;
    }

    public void add(String i) {
        if (i.length() % 2 != 0) {
            i = i + '\u0000';
        }
        this.d.add(this.gd(4, i));
        this.l += i.length();
    }

    public void add(double i) {
        this.d.add(this.gd(2, new Long(GDSWriter.doubleToGDSlong(i))));
        this.l += 8;
    }

    public void adds(int i) {
        this.add((short)i);
    }

    public void addInt(int i) {
        this.d.add(this.gd(5, new Integer(i)));
        this.l += 4;
    }

    public void add(short i) {
        this.d.add(this.gd(1, new Short(i)));
        this.l += 2;
    }

    public void write() throws IOException {
        this.dout.writeShort(this.l);
        this.l = 2;
        block6: for (int i = 0; i < this.d.size(); ++i) {
            int s = ((GDSdata)this.d.get((int)i)).i;
            Object o = ((GDSdata)this.d.get((int)i)).o;
            switch (s) {
                case 1: {
                    this.dout.writeShort(((Short)o).shortValue());
                    continue block6;
                }
                case 5: {
                    this.dout.writeInt((Integer)o);
                    continue block6;
                }
                case 2: {
                    this.dout.writeLong((Long)o);
                    continue block6;
                }
                case 4: {
                    this.dout.writeBytes((String)o);
                }
            }
        }
        this.d.clear();
    }

    public class GDSdata {
        int i;
        Object o;

        public GDSdata(int i, Object o) {
            this.i = i;
            this.o = o;
        }
    }
}

