/*
 * Decompiled with CFR 0.152.
 */
package JGDS2;

import JGDS2.GDSWriter;
import JGDS2.Ref;
import JGDS2.Struct;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.IOException;

public class Array
extends Ref {
    int rows = 1;
    int cols = 1;
    double rxX = 0.0;
    double rxY = 0.0;
    double ryX = 0.0;
    double ryY = 0.0;

    public Array(Struct s, double posX, double posY, int cols, int rows, double rxx, double ryy) {
        this.init(s, posX, posY, rows, cols, rxx, 0.0, 0.0, ryy, 0.0);
    }

    public Array(Struct s, double posX, double posY, int columns, int rows, double rxx, double ryy, double ang) {
        this.init(s, posX, posY, rows, columns, rxx, 0.0, 0.0, ryy, ang);
    }

    public Array(Struct s, double posX, double posY, int columns, int rows, double rxx, double rxy, double ryx, double ryy) {
        this.init(s, posX, posY, rows, columns, rxx, rxy, ryx, ryy, 0.0);
    }

    public Array(Struct s, double posX, double posY, int columns, int rows, double rxx, double rxy, double ryx, double ryy, double ang) {
        this.init(s, posX, posY, rows, columns, rxx, rxy, ryx, ryy, ang);
    }

    public Array(Struct s, double posX, double posY, int columns, int rows, double rxx, double ryy, int mirror, double ang) {
        this.init(s, posX, posY, rows, columns, rxx, 0.0, 0.0, ryy, ang);
        this.mirror = mirror;
    }

    final void init(Struct s, double posX, double posY, int r, int c, double dxx, double dxy, double dyx, double dyy, double ang) {
        if (!list.contains(s)) {
            list.add(s);
            ++structNum;
        } else if (s.name.charAt(0) == '?') {
            System.err.println("Struct name " + s.name + " in use already");
            System.exit(1);
        }
        this.sref = s;
        this.x = posX;
        this.y = posY;
        this.rows = r;
        this.cols = c;
        this.rxX = dxx;
        this.rxY = dxy;
        this.ryX = dyx;
        this.ryY = dyy;
        this.angle = ang;
    }

    @Override
    short refType() {
        return 2816;
    }

    @Override
    void colRow(GDSWriter g) throws IOException {
        g.adds(4866);
        g.adds(this.cols);
        g.adds(this.rows);
        g.write();
    }

    @Override
    void delta(GDSWriter g) throws IOException {
        g.addInt(Array.val(this.rxX + this.x));
        g.addInt(Array.val(this.rxY + this.y));
        g.addInt(Array.val(this.ryX + this.x));
        g.addInt(Array.val(this.ryY + this.y));
    }

    @Override
    Area refArea(Area ar) {
        AffineTransform at = AffineTransform.getTranslateInstance(this.x, this.y);
        at.rotate(this.angle / 180.0 * Math.PI);
        at.scale(this.mag, this.mag * (double)(this.mirror == 32768 ? -1 : 1));
        Area s = ar.createTransformedArea(at);
        Area a = new Area();
        AffineTransform tat = new AffineTransform();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                a.add(s.createTransformedArea(tat));
                tat.translate(this.rxX / (double)this.cols, this.rxY / (double)this.cols);
            }
            tat.translate(this.ryX / (double)this.rows - this.rxX, this.ryY / (double)this.rows - this.rxY);
        }
        return a;
    }
}

