/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import JGDS2.GArea;
import JGDS2.Text;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;

public class TextOutline {
    public static ArrayList<GArea> textOutline(String st, String fontName, double fontSize, double tX, double tY, double shapeReso, int gdsLayer, boolean CENTERED) {
        BasicStroke bs;
        double[] testPts = new double[6];
        ArrayList<GArea> ga = new ArrayList<GArea>();
        if (CENTERED) {
            Rectangle2D bounds = TextOutline.findCenter(st, fontName, fontSize, shapeReso, gdsLayer);
            tX = -bounds.getCenterX() + tX;
            tY = -bounds.getCenterY() + tY;
        }
        Font font = new Font(fontName, 0, (int)fontSize);
        AttributedString attributedString = new AttributedString(st);
        attributedString.addAttribute(TextAttribute.FONT, font, 0, st.length());
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        TextLayout layout = new TextLayout(attributedString.getIterator(), fontRenderContext);
        Shape s3 = layout.getOutline(null);
        PathIterator pi = s3.getPathIterator(null);
        Path2D.Double poly = new Path2D.Double();
        GArea g = new GArea();
        while (!pi.isDone()) {
            poly = TextOutline.currentSegmentMirrored(pi, poly);
            if (pi.currentSegment(testPts) == 4) {
                bs = new BasicStroke((float)CNSTscriptingController.getFontOutline(), 0, 0);
                g = new GArea(bs.createStrokedShape(poly), gdsLayer);
                g.transform(AffineTransform.getTranslateInstance(tX, tY));
                g.setRenderReso(shapeReso);
                ga.add(g);
                poly = new Path2D.Double();
            }
            pi.next();
        }
        bs = new BasicStroke((float)CNSTscriptingController.getFontOutline(), 0, 0);
        ga.add(new GArea(bs.createStrokedShape(poly), gdsLayer));
        poly = new Path2D.Double();
        return ga;
    }

    public static Rectangle2D findCenter(String s, String fontName, double fontSize, double shapeReso, int gdsLayer) {
        Font font = new Font(fontName, 0, (int)fontSize);
        Text lb = new Text(s, gdsLayer, font);
        lb.setFontSize(fontSize);
        lb.setRenderReso(shapeReso);
        Area a = new Area(lb.getArea());
        Rectangle2D rec = a.getBounds2D();
        return rec;
    }

    public static Path2D.Double currentSegmentMirrored(PathIterator pi, Path2D.Double poly) {
        double[] pts = new double[6];
        int type = pi.currentSegment(pts);
        switch (type) {
            case 0: {
                poly.moveTo(pts[0], -1.0 * pts[1]);
                return poly;
            }
            case 1: {
                poly.lineTo(pts[0], -1.0 * pts[1]);
                return poly;
            }
            case 2: {
                poly.quadTo(pts[0], -1.0 * pts[1], pts[2], -1.0 * pts[3]);
                return poly;
            }
            case 3: {
                poly.curveTo(pts[0], -1.0 * pts[1], pts[2], -1.0 * pts[3], pts[4], -1.0 * pts[5]);
                return poly;
            }
            case 4: {
                poly.closePath();
                return poly;
            }
        }
        return poly;
    }
}

